<?php
/**
 * Yith Wishlist Integration.
 * @since 1.0
 */

if( !function_exists( 'exponent_yith_add_wishlist_shop_page_html' ) ) {
    function exponent_yith_add_wishlist_shop_page_html( $template, $wishlist_url, $product_type, $exists ) {
        global $product;
        $product_id = $product->get_id();
        ob_start();
        ?>
            <div class="<?php echo be_themes_get_class( 'add-to-wishlist-wrap' ); ?>" >
                <?php if( !$exists ) : ?>
                    <a href="#" class="<?php echo be_themes_get_class( 'add-to-wishlist', 'wc-trigger-add-to-wishlist' ); ?>" data-product-id="<?php echo esc_attr( $product_id ); ?>" data-product-type = "<?php echo esc_attr( $product_type ); ?>" >
                        <div class="<?php echo be_themes_get_class( 'add-to-wishlist-icon-wrap' ) ?>">
                            <div class="<?php echo be_themes_get_class( 'already-in-wishlist-icon' ); ?>">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                                    <path d="M462.3 62.6C407.5 15.9 326 24.3 275.7 76.2L256 96.5l-19.7-20.3C186.1 24.3 104.5 15.9 49.7 62.6c-62.8 53.6-66.1 149.8-9.9 207.9l193.5 199.8c12.5 12.9 32.8 12.9 45.3 0l193.5-199.8c56.3-58.1 53-154.3-9.8-207.9z"/>
                                </svg>
                            </div>
                            <div class="<?php echo be_themes_get_class( 'add-to-wishlist-icon' ); ?>">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                                    <path d="M458.4 64.3C400.6 15.7 311.3 23 256 79.3 200.7 23 111.4 15.6 53.6 64.3-21.6 127.6-10.6 230.8 43 285.5l175.4 178.7c10 10.2 23.4 15.9 37.6 15.9 14.3 0 27.6-5.6 37.6-15.8L469 285.6c53.5-54.7 64.7-157.9-10.6-221.3zm-23.6 187.5L259.4 430.5c-2.4 2.4-4.4 2.4-6.8 0L77.2 251.8c-36.5-37.2-43.9-107.6 7.3-150.7 38.9-32.7 98.9-27.8 136.5 10.5l35 35.7 35-35.7c37.8-38.5 97.8-43.2 136.5-10.6 51.1 43.1 43.5 113.9 7.3 150.8z"/>
                                </svg>   
                            </div>
                        </div>
                    </a>
                <?php else : ?>
                    <a href="<?php echo esc_url( $wishlist_url ); ?>" class="<?php echo be_themes_get_class( 'add-to-wishlist', 'already-in-wishlist' ); ?>">
                        <div class="<?php echo be_themes_get_class( 'add-to-wishlist-icon-wrap' ) ?>">
                            <div class="<?php echo be_themes_get_class( 'already-in-wishlist-icon' ); ?>">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                                    <path d="M462.3 62.6C407.5 15.9 326 24.3 275.7 76.2L256 96.5l-19.7-20.3C186.1 24.3 104.5 15.9 49.7 62.6c-62.8 53.6-66.1 149.8-9.9 207.9l193.5 199.8c12.5 12.9 32.8 12.9 45.3 0l193.5-199.8c56.3-58.1 53-154.3-9.8-207.9z"/>
                                </svg>
                            </div>
                        </div>
                    </a>
                <?php endif; ?>
            </div>
        <?php 
        $add_to_wishlist_html = ob_get_clean();
        return $add_to_wishlist_html;
    }
}

if( !function_exists( 'exponent_yith_add_wishlist_shop_page' ) ) {
    function exponent_yith_add_wishlist_shop_page() {
        add_filter( 'yith_wcwl_add_to_wishlisth_button_html', 'exponent_yith_add_wishlist_shop_page_html', 10, 4 );
        if( shortcode_exists( 'yith_wcwl_add_to_wishlist' ) ) {
            echo do_shortcode( '[yith_wcwl_add_to_wishlist]' );
        }
    }
}

if( !function_exists( 'exponent_yith_add_wishlist_product_page_html' ) ) {
    function exponent_yith_add_wishlist_product_page_html( $template, $wishlist_url, $product_type, $exists ) {
        if( is_product() ) {
        global $product;
        $product_id = $product->get_id();
        $loader_html = be_themes_get_loader();
        ob_start();
        ?>
            <div class="<?php echo be_themes_get_class( 'add-to-wishlist-wrap' ); ?>">
                <?php if( !$exists ) : ?>
                    <a href="#" class="<?php echo be_themes_get_class( 'add-to-wishlist', 'wc-trigger-add-to-wishlist' ); ?>" data-product-id="<?php echo esc_attr( $product_id ); ?>" data-product-type = "<?php echo esc_attr( $product_type ); ?>">
                        <div class="<?php echo be_themes_get_class( 'add-to-wishlist-icon-wrap' ); ?>">
                            <?php echo wp_kses_post( $loader_html ); ?>
                            <div class="<?php echo be_themes_get_class( 'already-in-wishlist-icon' ); ?>">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                                    <path d="M462.3 62.6C407.5 15.9 326 24.3 275.7 76.2L256 96.5l-19.7-20.3C186.1 24.3 104.5 15.9 49.7 62.6c-62.8 53.6-66.1 149.8-9.9 207.9l193.5 199.8c12.5 12.9 32.8 12.9 45.3 0l193.5-199.8c56.3-58.1 53-154.3-9.8-207.9z"/>
                                </svg>
                            </div>
                            <div class="<?php echo be_themes_get_class( 'add-to-wishlist-icon' ); ?>">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                                    <path d="M458.4 64.3C400.6 15.7 311.3 23 256 79.3 200.7 23 111.4 15.6 53.6 64.3-21.6 127.6-10.6 230.8 43 285.5l175.4 178.7c10 10.2 23.4 15.9 37.6 15.9 14.3 0 27.6-5.6 37.6-15.8L469 285.6c53.5-54.7 64.7-157.9-10.6-221.3zm-23.6 187.5L259.4 430.5c-2.4 2.4-4.4 2.4-6.8 0L77.2 251.8c-36.5-37.2-43.9-107.6 7.3-150.7 38.9-32.7 98.9-27.8 136.5 10.5l35 35.7 35-35.7c37.8-38.5 97.8-43.2 136.5-10.6 51.1 43.1 43.5 113.9 7.3 150.8z"/>
                                </svg>                      
                            </div>
                        </div>
                        <div class="<?php echo be_themes_get_class( 'add-to-wishlist-text' ); ?>">
                            Add to Wishlist
                        </div>
                    </a>
                <?php else: ?>
                    <a href="<?php echo esc_url( $wishlist_url );  ?>" class="<?php echo be_themes_get_class( 'add-to-wishlist', 'already-in-wishlist' ); ?>">
                        <div class="<?php echo be_themes_get_class( 'add-to-wishlist-icon-wrap' ); ?>">
                            <div class="<?php echo be_themes_get_class( 'already-in-wishlist-icon' ); ?>">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                                    <path d="M462.3 62.6C407.5 15.9 326 24.3 275.7 76.2L256 96.5l-19.7-20.3C186.1 24.3 104.5 15.9 49.7 62.6c-62.8 53.6-66.1 149.8-9.9 207.9l193.5 199.8c12.5 12.9 32.8 12.9 45.3 0l193.5-199.8c56.3-58.1 53-154.3-9.8-207.9z"/>
                                </svg>
                            </div>
                        </div>
                        <div class="<?php echo be_themes_get_class( 'add-to-wishlist-text' ); ?>">
                            Browse Wishlist
                        </div>
                    </a>
                <?php endif; ?>
            </div>
        <?php
        $add_to_wishlist_html = ob_get_clean();
        return $add_to_wishlist_html;
        }else {
            return $template;
        }
    }
    add_filter( 'yith_wcwl_add_to_wishlisth_button_html', 'exponent_yith_add_wishlist_product_page_html', 10, 4 );
}

if( !function_exists( 'exponent_yith_enqueue_scripts_and_styles' ) ) {
    function exponent_yith_enqueue_scripts_and_styles() {
        //dequeue yith default styles
        wp_dequeue_style( 'yith-wcwl-main' );
        wp_deregister_style( 'yith-wcwl-main' );
        wp_dequeue_style( 'yith-wcwl-font-awesome' );
        wp_deregister_style( 'yith-wcwl-font-awesome' );
    }
    add_action( 'wp_enqueue_scripts', 'exponent_yith_enqueue_scripts_and_styles' );
}

if( !function_exists( 'exponent_yith_single_wishlist_page_wrap_start' ) ) {
    function exponent_yith_single_wishlist_page_wrap_start() {
        echo '<div class="be-themes-content-padding clearfix exp-wrap">';
    }
    add_action( 'yith_wcwl_before_wishlist', 'exponent_yith_single_wishlist_page_wrap_start' );
}

if( !function_exists( 'exponent_yith_single_wishlist_page_wrap_end' ) ) {
    function exponent_yith_single_wishlist_page_wrap_end() {
        echo '</div>';
    }
    add_action( 'yith_wcwl_after_wishlist', 'exponent_yith_single_wishlist_page_wrap_end' );
}

