<?php
/**
 * @wordpress-plugin
 * Plugin Name:       Spyro Modules
 * Plugin URI:        http://spyrowptheme.com
 * Description:       Add Ons for Tatsu Page Builder and Spyro theme
 * Version:           1.0.5
 * Author:            Brand Exponents
 * Author URI:        http://brandspyros.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       spyro-modules
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

if( !defined( 'SPYRO_MODULES_PLUGIN_URL' ) ) {
	define( 'SPYRO_MODULES_PLUGIN_URL', plugins_url( '', __FILE__ ) );
}
if( !defined( 'SPYRO_MODULES_PLUGIN_DIR' ) ) {
	define( 'SPYRO_MODULES_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'SPYRO_MODULES_VERSION', '1.0.5' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-spyro-modules-activator.php
 */
function activate_spyro_modules() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-spyro-modules-activator.php';
	Spyro_Modules_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-spyro-modules-deactivator.php
 */
function deactivate_spyro_modules() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-spyro-modules-deactivator.php';
	Spyro_Modules_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_spyro_modules' );
register_deactivation_hook( __FILE__, 'deactivate_spyro_modules' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-spyro-modules.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_spyro_modules() {

	$plugin = new Spyro_Modules();
	$plugin->run();

}
run_spyro_modules();
