;(function( $ ) {
	'use strict';

	var vendorScriptsUrl = spyroModulesConfig.vendorScriptsUrl,
	dependencies = spyroModulesConfig.dependencies || {};
	//console.log(dependencies);
	if( 'undefined' != typeof dependencies ) {
		for( var dependency in dependencies ) {
			
			if( dependencies.hasOwnProperty( dependency ) ) {
				asyncloader.register( dependencies[ dependency ], dependency );
			}
		}
	}


	jQuery(document).ready( function() {

		

		var $window = jQuery( window ),
		body = jQuery('body');
		var spyroModules = (function() {

			var  tatsuCallbacks = {},
			alreadyVisibleIndex = 0,
			scrollInterval,
			didScroll = false,

			video = function () {
                    var vimeoVideos = $('.be-vimeo-embed'),
                        youtubeVideos = $('.be-youtube-embed'),
                        loadYoutubeVideos,
                        videoReadyCallback;
                    videoReadyCallback = function (iframeEle) {
                        asyncloader.require(['fitvids'], function () {
                            if (null != iframeEle && 0 < iframeEle.length) {
                                iframeEle.closest('.be-video-embed').removeClass('be-embed-placeholder');
                                iframeEle.parent().fitVids();
                                $(document).trigger('be_video_loaded', [iframeEle]);
                                $('.exp-blog .be-grid').isotope('layout');

                            }
                        });
                    };
                    loadYoutubeVideos = function () {
                        youtubeVideos.each(function () {
                            var curVideo = $(this),
                                curPlayer = null,
                                id = null != curVideo.attr('data-video-id') ? curVideo.attr('data-video-id') : null,
                                autoplay = null != curVideo.attr('data-autoplay') ? parseInt(curVideo.attr('data-autoplay')) : null,
                                loopVideo = null != curVideo.attr('data-loop') ? parseInt(curVideo.attr('data-loop')) : null;

                            if (null != id) {
                                curPlayer = new YT.Player(this, {
                                    videoId: id,
                                    playerVars: {
                                        'autoplay': autoplay,
                                        'loop': loopVideo,
                                        'playlist': loopVideo ? id : ''
                                    },
                                    width: curVideo.width(),
                                    height: curVideo.width() / 1.7777,
                                    events: {
                                        'onReady': function (e) {
                                            if (autoplay) {
                                                e.target.mute();
                                            }
                                        }
                                    }
                                });
                                videoReadyCallback($(curPlayer.getIframe()));
                            }
                        });
                    }
                    //vimeo videos
                    if (0 < vimeoVideos.length) {
                        asyncloader.require(['vimeonew'], function () {
                            vimeoVideos.each(function () {
                                var curVideo = $(this),
                                    curPlayer = null,
                                    id = !isNaN(Number(curVideo.attr('data-video-id'))) ? Number(curVideo.attr('data-video-id')) : null,
                                    autoplay = null != curVideo.attr('data-autoplay') ? parseInt(curVideo.attr('data-autoplay')) : false,
                                    loopVideo = null != curVideo.attr('data-loop') ? parseInt(curVideo.attr('data-loop')) : false;
                                if (null != id) {
                                    var curPlayer = new Vimeo.Player(this, {
                                        id: id,
                                        autoplay: autoplay ? true : false,
                                        loop: loopVideo ? true : false,
                                        muted: autoplay ? true : false,
                                        width: curVideo.width(),
                                        height: Math.ceil(curVideo.width() / 1.7777),
                                    });
                                    curPlayer.ready().then(function () {
                                        videoReadyCallback(curVideo.children('iframe'));
                                    });
                                }
                            });
                        });
                    }

                    if (0 < youtubeVideos.length) {
                        if ('undefined' != typeof YT && 'function' == typeof YT.Player) {
                            loadYoutubeVideos();
                        } else {
                            $(document).on('YTAPIReady', loadYoutubeVideos);
                        }
                    }
                },
                slider = function (selector) {
                    var sliders = $(selector || '.be-slider'),
                        initOuterArrows = function (slider) {
                            if (slider instanceof $ && 0 < slider.length && !slider.hasClass('be-slider-with-margin') && (100 < ($window.width() - slider.outerWidth()))) {
                                var gutter = !isNaN(slider.attr('data-gutter')) ? Number(slider.attr('data-gutter')) / 2 : 0;
                                slider.css({
                                    padding: '0 50px',
                                    margin: '0 -' + (gutter + 50) + 'px'
                                });
                            }
                        },
                        getLazyLoadCount = function (slider) {
                            var count = 1;
                            if (slider instanceof $ && 0 < slider.length) {
                                var cols = !isNaN(Number(slider.attr('data-cols'))) ? Number(slider.attr('data-cols')) : 1;
                                if (1 < cols) {
                                    count = cols - 1;
                                }
                            }
                            return count;
                        },
                        hideUnneccessaryNav = function (curSlider) {
                            var navPossible = function (slider) {
                                var cols,
                                    slidesClount;
                                if (slider instanceof $ && 0 < slider.length) {
                                    cols = !isNaN(Number(slider.attr('data-cols'))) ? Number(slider.attr('data-cols')) : 1;
                                    slidesClount = slider.find('.be-slide').length;
                                    if (1024 < $window.width()) {
                                        return cols < slidesClount;
                                    } else if (767 < $window.width()) {
                                        return 2 < slidesClount;
                                    } else {
                                        return 1 < slidesClount;
                                    }
                                }
                            };
                            if (!navPossible(curSlider)) {
                                curSlider.addClass('be-slider-hide-nav');
                            }
                            $window.on('debouncedresize', function () {
                                if (!navPossible(curSlider)) {
                                    curSlider.addClass('be-slider-hide-nav');
                                } else {
                                    curSlider.removeClass('be-slider-hide-nav');
                                }
                            });
                        },
                        equalHeightSlider = function (slider) {
                            if (slider instanceof $ && 0 < slider.length) {
                                var maxHeight = 0,
                                    slides = slider.find('.be-slide');
                                slides.each(function () {
                                    var curSlide = $(this);
                                    if (maxHeight < curSlide.height()) {
                                        maxHeight = curSlide.height();
                                    }
                                });
                                slides.height(maxHeight);
                                slider.addClass('be-equal-height-slider');
                            }
                        };
                    if (0 < sliders.length) {
                        asyncloader.require('flickity', function () {
                            sliders.each(function () {
                                var curSlider = jQuery(this);
                                if (!curSlider.hasClass('flickity-enabled')) {
                                    if ('1' == curSlider.attr('data-arrows') || '1' == curSlider.attr('data-dots')) {
                                        hideUnneccessaryNav(curSlider);
                                    }
                                    if ('1' == curSlider.attr('data-arrows') && '1' == curSlider.attr('data-outer-arrows')) {
                                        initOuterArrows(curSlider);
                                    }
                                    if ('1' == curSlider.attr('data-equal-height')) {
                                        equalHeightSlider(curSlider);
                                    }
                                    curSlider.flickity({
                                        cellAlign: null != curSlider.attr('data-cell-align') ? curSlider.attr('data-cell-align') : 'left',
                                        contain: true,
                                        lazyLoad: '1' == curSlider.attr('data-lazy-load') ? getLazyLoadCount(curSlider) : false,
                                        adaptiveHeight: '1' == curSlider.attr('data-adaptive-height') ? true : false,
                                        pageDots: '1' == curSlider.attr('data-dots') ? true : false,
                                        prevNextButtons: '1' == curSlider.attr('data-arrows') ? true : false,
                                        asNavFor: null != curSlider.attr('data-as-nav-for') ? curSlider.attr('data-as-nav-for') : false,
                                        autoPlay: !isNaN(Number(curSlider.attr('data-auto-play'))) ? Number(curSlider.attr('data-auto-play')) : false,
                                        wrapAround: '1' == curSlider.attr('data-infinite') ? true : false,
                                    });
                                }
                            });
                        });
                    }
                },
                grid = function () {
                    asyncloader.require(['isotope', 'begrid'], function () {
                        var grids = jQuery('.be-grid[data-layout="metro"],.be-grid[data-layout="masonry"]');
                        grids.each(function () {
                            new BeGrid(this);
                        });
                    });
                },

                tatsuCallbacks = function () {
                    
                    $(window).on('tatsu_update', function (event, data) {
                        if (null != data) {
                            var moduleName = data.moduleName,
                                shouldUpdate = data.shouldUpdate,
                                moduleId = data.moduleId;
                            if (null != moduleName && null != moduleId) {
                                if ('exp_contact_form7' === moduleName) {
                                    contactForm();
                                } else if ('exp_recent_posts' === moduleName) {
                                    slider('.exp-recent-posts .be-slider');
                                } else if ('exp_featured_posts' === moduleName) {
                                    slider('.exp-featured-posts .be-slider');
                                } else if ('blog' === moduleName) {
                                    grid();
                                    slider('.exp-blog .be-slider');
                                    video('.exp-blog .be-slider')
                                } else if ('exp_countdown' === moduleName) {
                                    countDown();
                                }
                            }
                        }
                    });
                },
			/**Exp-Team**/
			team = function() {
				
				// asyncloader.require( 'anime', function() {
				// 	$('.exp-team').mouseenter(function () { 
				// 		var functionBasedDelay = anime({
				// 				targets: '.icon-shortcode',
				// 				translateY: [10, -10],
				// 				scale: [0, 1],
				// 				loop: 1,
				// 				delay: function(el, i, l) {
				// 				return i * 100;
				// 				}
				// 			});
				// 	});
				// });
				
			},

			testimonials = function(){

				asyncloader.require( 'slick', function() {
					
					$('.testimonial-outer-slider.slide-here').each( function(){

						var $this = $(this),
						dots = $this.attr('data-dots') == '1' ? true : false,
						autoPlay = $this.attr('data-auto-play') == '1' ? true : false,
						slideShowSpeed = $this.attr('data-slide-show-speed') ? parseInt( $this.attr('data-slide-show-speed') ) : 4000 ;
						//slidesPerRow = $this.attr('data-slide-per-scroll') ? parseInt( $this.attr('data-slide-per-scroll') ) : 1;

						$this.on('init', function(slick){
							$this.css( 'visibility', 'visible' );
						});

						$this.slick({
							dots: dots,
							infinite: true,
							autoplay: autoPlay,
							autoplaySpeed: slideShowSpeed,
							adaptiveHeight: true,
							// slidesToShow: slidesPerRow,
							// slidesToScroll: slidesPerRow,
							//arrow: true
						});
						
					});	


				});
			},
			svgLineAnimate = function(shouldUpdate,moduleId) {
				asyncloader.require( 'vivus', function() {
					var svgAnimateModules = jQuery( '.svg-line-animate' );
					//SVG animate front-end
					if( svgAnimateModules.length > 0 ) {
						svgAnimateModules.each(function (i, el) {
							var el = jQuery( el );
							var svgObject = el.find( 'svg' )[0],
							pathTimingFunction = el.attr( 'data-path-animation' ),
							animTimingFunction = el.attr( 'data-svg-animation' ),
							duration = el.attr( 'data-animation-duration' ),
							delay = el.attr( 'data-animation-delay' );
							new Vivus(
								svgObject, 
								{
									duration: duration,
									pathTimingFunction	: Vivus[pathTimingFunction],
									animTimingFunction	: Vivus[animTimingFunction],
									delay : delay,
									onReady: function() {
										el.css( 'visibility', 'visible' );
									}
								}, 
								function() {
									//console.log('Svg Animated');	
								}); 
						});
					}
					//SVG animate in tatsu
					var svgAnimatesInTatsu = jQuery('.exp-svg-icon span');
					if(svgAnimatesInTatsu.length > 0){
						svgAnimatesInTatsu.each(function(index,element){
							var element = jQuery(element).parent();
							if(!moduleId || element.parent().hasClass('be-pb-observer-'+moduleId)){
								var svgObject1 = element.attr( 'data-target' ),
								pathTimingFunction = element.attr( 'data-path-animation' ),
								animTimingFunction = element.attr( 'data-svg-animation' ),
								duration = element.attr( 'data-animation-duration' ),
								delay = element.attr( 'data-animation-delay' ),
								fileUrl = element.attr( 'data-svg-url');
								element.children().empty();
								new Vivus(svgObject1, {
									file:fileUrl,
									duration: duration,
									pathTimingFunction	: Vivus[pathTimingFunction],
									animTimingFunction	: Vivus[animTimingFunction],
									delay : delay,
									onReady: function() {
										element.css( 'visibility', 'visible' );
									}
								}, 
								function() {
									//console.log('Svg Animated');	
								}); 
							} 
						});
					}

				});
			},
			spy_ver_tabs = function(  ) {

				//var tabsWrap = jQuery( '.spy-tabs-inner' );
				//var tabsWrap = jQuery( '.spyro-fancy-tabs' );
				
				// jQuery('.tab-menu-item a').on('click' , function(){
				// 	jQuery('.fancy-tabs-content').removeClass('active');
				// 	jQuery('.tab-menu-item').removeClass('active');
				// 	jQuery(this).parent().addClass('active');
				// 	var href = jQuery(this).attr('href');
				// 	console.log(href);
				// 	jQuery(href).addClass('active');
				// });

				jQuery('.spyro-fancy-tabs').each(function(){
					var tab_menu_item = jQuery(this).find('.tab-menu-item a');
					var tab_menu = jQuery(this).find('.tab-menu-item');
					var tab_img_container = jQuery(this).find('.tab-img-container');
					var fancy_tab_text = jQuery(this).find('.fancy-tab-text');

						jQuery(tab_menu_item).on('click' , function (e){
						e.preventDefault();
						if(jQuery(this).parent().hasClass('active'))
						{
							return;
						}

						jQuery(tab_menu).removeClass('active');
						jQuery(tab_img_container).removeClass('active');
						jQuery(fancy_tab_text).removeClass('active');

						var href = jQuery(this).attr('href');
						href= href.replace('#' , '');
						console.log(href);
						jQuery('.'+ href).addClass('active');
						jQuery(this).parent().addClass('active');
						return false;
					});

				});

				

				
				// if(!tabsWrap.length)
				// {
				// 	return;
				// }
			
				// 	if(tabsWrap.length > 0) {
				// 		tabsWrap.tabs({
				// 			fx : {
				// 				opacity : 'toggle',
				// 				duration : 200
				// 			}
				// 		}).css('opacity', 1);
				// 	}
			return false;

			},
			spy_advance_tabs = function(shouldUpdate,moduleId){
				
			jQuery('.spyro-tabs').each(function(){
				var tabs_navigation = jQuery(this).find('.tabs-navigation a');
				var tabs_container = jQuery(this).find('.tabs-container .tabs-content');
				jQuery(tabs_navigation).on('click' , function(e){
					 e.preventDefault();
					
					jQuery(tabs_container).removeClass('active');
					jQuery(tabs_navigation).removeClass('active');
					jQuery(this).addClass('active');
					var href = jQuery(this).attr('href');
					
					jQuery(href).addClass('active');
					return false;

				});
			});
				 	
				 
				 
				
				
			},
			spy_packages = function (){
				jQuery('.spyro-package').each(function(){

					var package_navigation = jQuery(this).find('.package-navigation li a');
					var package_block_wrap = jQuery(this).find('.package-block-wrap');
						jQuery(package_navigation).each(function(){
						var class_name = jQuery(this).data('package_name');
						var html = jQuery('.package-block-wrap.'+class_name+' .package-container' ).children();
						
						
						if(html.length == 0)
						{
							//console.log(html);
							jQuery(this).hide();
						}
					});

					jQuery(package_navigation).on('click' , function (){
					if(jQuery(this).hasClass('active'))
					{
						return;
					}
					jQuery(package_navigation).removeClass('active');
					jQuery(package_block_wrap).removeClass('active');
					var class_name = jQuery(this).data('package_name');
					jQuery('.'+class_name).addClass('active');
					jQuery(this).addClass('active');

				});
				});
				
				
			},

			spy_price_toggle = function(  ){

					// jQuery(".custom-switch-input").each(function(i) {
					// 	var classes = jQuery(this).attr("class"),
					// 	id      = jQuery(this).attr("id"),
					// 	name    = jQuery(this).attr("name");
						
					// 	jQuery(this).wrap('<div class="custom-switch" id="' + name + '"></div>');
					// 	jQuery(this).after('<label for="custom-switch-' + i + '"></label>');
					// 	jQuery(this).attr("id", "custom-switch-" + i);
					// 	jQuery(this).attr("name", name);
					// });
				jQuery("input.custom-switch-input").change(function() {
					jQuery(".spyro-pricing-table").toggleClass("price-toggle");
					if(jQuery('.monthly').hasClass('active'))
					{
						jQuery('.monthly').removeClass('active');
					}
					else
					{
						jQuery('.monthly').addClass('active');
					}
					if(jQuery('.annually').hasClass('active'))
					{
						jQuery('.annually').removeClass('active');
					}
					else
					{
						jQuery('.annually').addClass('active');
					}
				});	
			},

			intlTelInput = function(){

				var telInput = jQuery(".phone-number");
				if(!telInput.hasClass('is_country_code'))
				{
					return;
				}
					// initialise plugin
					telInput.intlTelInput({

						allowExtensions: true,
						formatOnDisplay: true,
						autoFormat: true,
						autoHideDialCode: true,
						autoPlaceholder: true,
						defaultCountry: "auto",
						ipinfoToken: "yolo",

						nationalMode: false,
						numberType: "MOBILE",
					  //onlyCountries: ['us', 'gb', 'ch', 'ca', 'do'],
					  preferredCountries: ['in', 'us', 'qa','om','bh','kw','ma'],
					  preventInvalidNumbers: true,
					  separateDialCode: true,
					  initialCountry: "IN",
					
					  // utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/11.0.9/js/utils.js"
					});

					var reset = function() {
						telInput.removeClass("error");
					  // errorMsg.addClass("hide");
					  // validMsg.addClass("hide");
					};

					// on blur: validate
					telInput.blur(function() {
						reset();
						if (jQuery.trim(telInput.val())) {
							if (telInput.intlTelInput("isValidNumber")) {
					      //validMsg.removeClass("hide");
					  } else {
					  	telInput.addClass("error");
					      //errorMsg.removeClass("hide");
					  }
					}
					});

					// on keyup / change flag: reset
					telInput.on("keyup change", reset);
				},

				imageComparision = function(){

					
					asyncloader.require( 'cocoen', function(e) {

						var imageComparisonEl = jQuery( '.cocoen.image-comparison' );                   
            
							imageComparisonEl.each( function() {                      
								new Cocoen( this );
							});
    
					});
				},
				spyro_accordion = function (){
				jQuery('.spyro-accordion').each(function(){
					var accordion_head = jQuery(this).find('.accordion-head');
					var accordion_content_wrap = jQuery(this).find('.accordion-content-wrap');
					var accordion_body = jQuery(this).find('.accordion-body');

					jQuery(accordion_head).on('click' , function (e){

						e.preventDefault();
						if(jQuery(this).hasClass('slide-open'))
						{
							return;
						}
						jQuery(accordion_content_wrap).removeClass('active');
						jQuery(accordion_head).removeClass('slide-open');
						jQuery(accordion_body).slideUp();

						if(jQuery(this).hasClass('slide-open'))
						{	


							jQuery(this).siblings(".accordion-body").slideUp(500 , function(){
								
								

							});
							jQuery(this).parent().removeClass('active');
							jQuery(this).removeClass('slide-open');
						}
						else
						{
							jQuery(this).siblings(".accordion-body").slideDown(500 , function(){
								
								
							});
					    	jQuery(this).parent().addClass('active');
							jQuery(this).addClass('slide-open');

							
						}


					});

				});
					
				},
				spyro_form_js = function(){
					
					jQuery('.arrow-up').on('click' , function(){
					var max_val = 0;
					var parent = jQuery(this).parents('.form-field');
					var max_val = parent.children('.form-element').attr('max');

					console.log(max_val);
					var child_val = parent.children('.form-element').val();
					if(child_val.length == 0)
					{
						child_val = 0;	
					}
					
					child_val = parseInt(child_val);
					child_val = child_val + 1;
					if(max_val)
					{
						if(child_val <= max_val)
						{
							parent.children('.form-element').val(child_val);		
						}
						
					}
					else
					{
						parent.children('.form-element').val(child_val);		
					}
					
					
					
				});

				jQuery('.arrow-down').on('click' , function(){
					var min_val = 0;
					var parent = jQuery(this).parents('.form-field');
					var min_val = parent.children('.form-element').attr('min');
					var child_val = parent.children('.form-element').val();
					if(child_val.length == 0)
					{
						child_val = 0;	
					}
					
						child_val = parseInt(child_val);
						child_val = child_val - 1;
						if(min_val)
						{
							if(child_val >= min_val)
							{
								parent.children('.form-element').val(child_val);	
							}
							
						}
						else
						{
							parent.children('.form-element').val(child_val);	
						}
						
					
					
					});

				jQuery('.form-field.form-radio-button label').on('click',function(e){
					
					e.preventDefault();
					if(jQuery(this).hasClass('is-checked'))
					{
						
						jQuery(this).removeClass('is-checked');
						
					}
					else
					{
						jQuery('.form-field.form-radio-button label').removeClass('is-checked');
						jQuery(this).addClass('is-checked');
					}

					
					
				});

				jQuery('.form-field.form-checkbox-button-style label').on('click',function(e){
					
					e.preventDefault();
					if(jQuery(this).hasClass('is-checked'))
					{
						//console.log('hasClass');
						jQuery(this).removeClass('is-checked');
						jQuery(this).find('input[type="checkbox"]').prop('checked',false);
						
					}
					else
					{
						//console.log('removeClass');
						jQuery(this).addClass('is-checked');
						jQuery(this).find('input[type="checkbox"]').prop('checked',true);
					}

					
					
				});

				jQuery('.form-field.form-checkbox-button-style label.is-checked').each(function(){
					jQuery(this).find('input[type="checkbox"]').prop('checked',true);
				});
				
				},
				

		  mailchimp_spyro = ( function() {
            $(document).on('click', '.form-footer .form-btn-wrap .form-btn', function ( e ) {
                e.preventDefault();
                var $this = $(this),
                    $ajaxUrl = $( '#ajax_url' ).val(),
                    $subscription_form = $this.closest('.spyro-form'), 
                    $subscribe_status = $subscription_form.find(".subscribe_status"),
                    $subscribe_loader = $subscription_form.find(".exp-subscribe-loader");

                    jQuery($subscribe_loader).show();
                    // jQuery($subscribe_status).hide();


                var email_address = jQuery($subscription_form).find('input[data-map_field="email_address"]').val();
                var fname = jQuery($subscription_form).find('input[data-map_field="FNAME"]').val();
                var lname = jQuery($subscription_form).find('input[data-map_field="LNAME"]').val();
                var phone = jQuery($subscription_form).find('input[data-map_field="PHONE"]').val();
                var api_key = jQuery($subscription_form).find('input[name="api_key"]').val();
                var list_id = jQuery($subscription_form).find('input[name="list_id"]').val();
                var double_optin = jQuery($subscription_form).find('input[name="double_optin"]').val();
                var success_text = jQuery($subscription_form).find('input[name="success_text"]').val();
                var failure_text = jQuery($subscription_form).find('input[name="failure_text"]').val();
                var already_in_list = jQuery($subscription_form).find('input[name="already_in_list"]').val();
                var to_email_options = jQuery($subscription_form).find('input[name="to_email_options"]').val();
                var to_email = jQuery($subscription_form).find('input[name="to_email"]').val();
                

                if(jQuery($subscription_form).find('.form-county-code-val'))
                {
                	var county_code = jQuery($subscription_form).find('.form-county-code-val').val();
                	phone = county_code + phone;
                }

                var action = $subscription_form.data('action');
                console.log(action);
                if(action == 'email')
                {
                	 var data = {
        			'action': 'spyro_sent_mail',
        			'success_text': success_text,
	        		'failure_text': failure_text,
	        		'to_email_options': to_email_options,
	        		'to_email': to_email
        			
          			};
                }
                else
                {
                	 var data = {
	        			'action': 'spyro_mailchimp_subscription',
	        			'email_address': email_address,
	        			'fname': fname,
	        			'lname': lname,
	        			'phone': phone,
	        			'api_key': api_key,
	        			'list_id': list_id,
	        			'list_id': list_id,
	        			'double_optin': double_optin,
	        			'success_text': success_text,
	        			'failure_text': failure_text,
	        			'already_in_list': already_in_list
          			};

                }
                
              
                jQuery.ajax({
                    type: "POST",
                    url: $ajaxUrl,
                    data: data,
                    success : function (res) {
                    var msg = JSON.parse(res);

                    	console.log(msg);
                    	$subscribe_loader.hide();
                    	$subscribe_status.html(msg.data).slideDown();
                            $subscription_form.removeClass( 'exp-mc-form-loading' );
                        if (msg.status === "error") {
                            $subscribe_status.removeClass("tatsu-success").addClass("tatsu-error");
                        } else {
                            $subscribe_status.addClass("tatsu-success").removeClass("tatsu-error");
                        }
                        $subscribe_loader.fadeOut(400, 'swing', function() { 
                            
                            $subscribe_status.html(msg.data).slideDown('slow');    
                            $subscription_form.removeClass( 'exp-mc-form-loading' );
                        });
                    },
                    error: function (req , err) {
                    	console.log(err);
                        $subscribe_loader.fadeOut(400, 'swing', function() {  
                            $subscribe_status.removeClass("tatsu-success").addClass("tatsu-error");
                            $subscribe_status.html("Please Try Again Later");
                            
                            $subscription_form.removeClass( 'exp-mc-form-loading' ); 
                        });
                       
                    }
                });
                return false;
            });
            
        } )(),
		
		mailchimp = ( function() {
            $(document).on('click', '.exp-mc-submit', function ( e ) {
                e.preventDefault();
                var $this = $(this),
                    $ajaxUrl = $( '#ajax_url' ).val(),
                    $subscription_form = $this.closest('.exp-mc-form'), 
                    $subscribe_status = $subscription_form.find(".subscribe_status"), 
                    $subscribe_loader = $subscription_form.find(".exp-subscribe-loader");
                $subscription_form.addClass( 'exp-mc-form-loading' );
                $subscribe_loader.fadeIn();
				if('undefined' != typeof spyroModulesConfig && ('undefined' == typeof $ajaxUrl || null == $ajaxUrl)){
					$ajaxUrl = spyroModulesConfig.ajax_url;
				}
                jQuery.ajax({
                    type: "POST",
                    url: $ajaxUrl,
                    dataType: 'json',
                    data: "action=spyro_mailchimp_subscription&" + jQuery(this).closest(".exp-mc-form").serialize(),
                    success : function (msg) {
                        if (msg.status === "error") {
                            $subscribe_status.removeClass("tatsu-success").addClass("tatsu-error");
                        } else {
                            $subscribe_status.addClass("tatsu-success").removeClass("tatsu-error");
                        }
                        $subscribe_loader.fadeOut(400, 'swing', function() { 
                            $subscribe_status.html(msg.data).slideDown();
                            $subscription_form.removeClass( 'exp-mc-form-loading' );
                        });
                    },
                    error: function () {
                        $subscribe_loader.fadeOut(400, 'swing', function() {  
                            $subscribe_status.removeClass("tatsu-success").addClass("tatsu-error");
                            $subscribe_status.html("Please Try Again Later").slideDown();    
                            $subscription_form.removeClass( 'exp-mc-form-loading' ); 
                        });
                       
                    }
                });
                return false;
            });
            return function() {
                var newsletters =  jQuery( '.exp-mc' );
                if( 0 < newsletters.length ) {
                    newsletters.each( function() {
                        var curEle = $(this),
                            parentWidth = curEle.parent().width(),
                            curEleWidth = curEle.find('.exp-mc-email').outerWidth(true) + curEle.find('.exp-mc-submit').outerWidth();
                        if( curEleWidth > parentWidth ) {
                            curEle.addClass( 'exp-mc-block' );
                        }else {
                            curEle.removeClass( 'exp-mc-block' );
                        }
                    } );
                }
            } 
        } )(),

		registerDependencies = function() {

			if( null != spyroModulesConfig && null != spyroModulesConfig.dependencies ) {
				var dependencies = spyroModulesConfig.dependencies;
                //console.log(dependencies);
                for( var dependency in dependencies ) {
                	asyncloader.register( dependencies[dependency], dependency );
                }
            }
        },  

       


        registerCallbacks = function() {
			// ex: tatsuCallbacks['moduleName'] = callbackFunction;
			tatsuCallbacks[ 'spyro_team' ] = team;
			tatsuCallbacks[ 'spy_svg_icon' ] = svgLineAnimate;
			tatsuCallbacks[ 'spyro_price_switch' ] = spy_price_toggle;
			tatsuCallbacks[ 'spyro_tabs' ] = spy_ver_tabs;
			
			tatsuCallbacks[ 'spyro_image_before_after' ] = imageComparision;
			tatsuCallbacks[ 'spyro_accordion' ] = spyro_accordion;
			tatsuCallbacks[ 'spyro_advance_tabs' ] = spy_advance_tabs;
			tatsuCallbacks[ 'spyro_packages' ] = spy_packages;
			tatsuCallbacks[ 'spyro_form' ] = spyro_form_js;
			//tatsuCallbacks[ 'spyro_form' ] = spyro_checkbox_radio;
			//tatsuCallbacks[ 'spy_testimonials' ] = testimonials;

		},

			ready = function() {    

				//contactForm();
				//registerDependencies();
				team();
				testimonials();
				svgLineAnimate();
				
				spy_ver_tabs();
				spy_advance_tabs();
				spy_packages();
				spyro_form_js();
				
				
				spy_price_toggle();
				imageComparision();
				spyro_accordion();

				tatsuCallbacks();
	            grid();
	            slider();
				if( 'undefined' != typeof spyroModulesConfig && 'undefined' != typeof spyroModulesConfig.isexp_module_activated && '0'==spyroModulesConfig.isexp_module_activated ) {
					mailchimp();
				}
				if(typeof jQuery.fn.intlTelInput === 'undefined'){
					asyncloader.require( ['intlTelInput'], function() {
						//intlTelInput()
					});
				}

				

				registerCallbacks();


			},
			
			run = function() {



				ready();

				jQuery(window).on( 'tatsu_update.tatsu', function( e, data )  {
					
				
					if( data ) {
						if( 'trigger_ready' == data.moduleName ) {
							// svgLineAnimate();
							
							// ready();
						} else if( data.moduleName in tatsuCallbacks ) {
								

							tatsuCallbacks[data.moduleName]( data.shouldUpdate, data.moduleId );											
						}
					}
				});

				jQuery(window).on( 'scroll', function(){
					didScroll = true;
				});

			}

			return {
				run: run,
				ready: ready
			}

		})();

		spyroModules.run();

	});

})( jQuery );