<?php
/**************************************
			Price Toggle
**************************************/
if (!function_exists('spyro_price_toggle')) {
	function spyro_price_toggle( $atts, $content, $tag ) {
        $atts = shortcode_atts( array (
        	'icon_color'=> '',
			'price_color' => '',
			'label_color' => '',
			'feature_color' => '',
			'feature_icon_color' => '',
			'feature_border_color' => '',
			'type' => '',
			'button_style'=> '',
			'bg_color' => '',
			'color' => '',
			'hover_bg_color' => '',
			'hover_color' => '',
			
			'table_back_color' => '',
			'monthly_price' => '',
			'annual_price' => '',
			'plan_label' => '',
			'btn_text' => '',
			'icon' => '',
			'url' => '',
			'feature_typography' => '',
			'label_typography' => '',
			'price_typography' => '',
			
			'price_header_font_buton_set' => '',
			'price_body_font_buton_set' => '',
			'table_margin' => '',
			'price_font' => '',
			'label_font' => '',
			'feature_font' => '',
        	'key' => be_uniqid_base36(true),
        ),$atts, $tag );
        
		extract( $atts);
			

		$GLOBALS['tabs_cnt'] = 0;
		$tabs_cnt=0;
        $GLOBALS['features'] = array();
		$rand = rand();
        $content=do_shortcode( $content );
		$custom_style_tag = be_generate_css_from_atts( $atts, 'spyro_price_toggle', $key );


		
		$custom_class_name = 'tatsu-'.$atts['key'];
		$data_animations = be_get_animation_data_atts( $atts );

		$css_id = be_get_id_from_atts( $atts );
		$visibility_classes = be_get_visibility_classes_from_atts( $atts ); 
		
		$animate = ( isset( $animate ) && 1 == $animate  && 'none' != $animation_type ) ? ' tatsu-animate ' : '';


		$plan_icon_tag = ( ! empty($atts['icon']) && $atts['icon'] != 'none' ) ? '<span class="price-head-icon"><i class="'.$atts['icon'].'"></i></span>' : "" ;

		// if(empty($label_font))
		// {
		// 	$label_font = 'default';
		// }
		// if(empty($price_font))
		// {
		// 	$price_font = 'default';
		// }
		// if(empty($feature_font))
		// {
		// 	$feature_font = 'default';
		// }
		$button_style = ( isset( $button_style ) && !empty( $button_style ) ) ? $button_style : '';
		
		ob_start();
		?>
		<div class=" <?php echo $custom_class_name . ' '.$visibility_classes . ' '.$animate;  ?>" <?php echo $css_id; ?> > 
		<div class="spyro-pricing-table price-toggle">
            <div class="pricing-head">
            	<?php 
            	if(!empty($plan_icon_tag))
            	{
            		?>
            		<span class="pricing-head-icon"><?php echo $plan_icon_tag; ?></span>
            		<?php 
            	}
            	?>
                <p class="pricing-price monthly <?php echo $price_font ?>"><?php echo esc_html($atts['monthly_price']); ?></p>
                <p class="pricing-price annually <?php echo $price_font ?>"><?php echo esc_html($atts['annual_price']); ?></p>
                <span class="pricing-label <?php echo $label_font ?>"><?php echo esc_html($atts['plan_label']); ?></span>
            </div>
            <div class="pricing-features-list">
                <ul>
                	<?php 
                	if(is_array($GLOBALS['features'])){ 
                		foreach( $GLOBALS['features'] as $val ) {
									
							$tabs_cnt++;
							$icon_tag = ( ! empty($val['icon']) && $val['icon'] != 'none' ) ? '<i class="'.$val['icon'].'"></i>' : "" ;
                	?>
                    <li class="<?php echo $val['class_name']; ?>"> <?php echo $icon_tag; ?> <span class="feature-item <?php echo $feature_font; ?>"><?php echo esc_html($val['feature']); ?></span> </li>
                    <?php echo $val['custom_style_tag']; ?>
                  <?php } } ?>
                </ul>
            </div>
            <div class="pricing-footer">
            	<?php
            	// 
            	if($type == 'block')
            	{
            		$align = 'align-block';
            	}
            	else
            	{
            		$align = '';
            	}
            	?>
	             <div class="tatsu-module tatsu-normal-button tatsu-button-wrap <?php echo $align; ?>">
	             	<a class="tatsu-shortcode <?php echo $type.'btn'; ?> tatsu-button left-icon  <?php echo $button_style; ?>" href="<?php echo esc_attr($url); ?>" style="" aria-label="Click Here" data-gdpr-atts="{}"><?php echo $btn_text; ?></a>
	             </div>
            </div>
        </div>
    	</div>
    	<?php echo $custom_style_tag ?>
		<?php 

		return ob_get_clean();
		//return $html;
	}
}

if( !function_exists('spyro_plan_features'))
{
	function spyro_plan_features( $atts, $content, $tag ) {
		$atts = shortcode_atts( array(
			
			'feature' => '',
			'icon' => '',
			'icon_sep_color' => '',
			'feature_sep_color' => '',
			'key' => be_uniqid_base36(true),
		),$atts );
		
		$custom_style_tag = be_generate_css_from_atts( $atts, 'spyro_plan_features', $atts['key'] );
		$custom_class_name = 'tatsu-'.$atts['key'];

		extract( $atts );

		

		$content= do_shortcode($content);
		$x = $GLOBALS['tabs_cnt'];
		$GLOBALS['features'][$x] = array(  'feature' => sprintf( $feature, $GLOBALS['tabs_cnt'] ),'icon'=> $icon, 'class_name' => $custom_class_name, 'custom_style_tag' => $custom_style_tag , 
			'icon_sep_color' => $icon_sep_color ,
			
			
			
				);
		$GLOBALS['tabs_cnt']++;
		
	}
}

add_action('tatsu_register_modules', 'spyro_register_price_toggle');
function spyro_register_price_toggle()
{
	$controls = array(
		'icon' => TATSU_PLUGIN_URL . '/builder/svg/modules.svg#tabs',
		'title' => __('Spyro Price', 'spyro-modules'),
		'is_js_dependant' => true,
		'child_module' => 'spyro_plan_features',
		'type' => 'multi',
		'initial_children' => 4,
		'is_built_in' => false,
		'category' => 'pricing',
		'group_atts' => array(
			array(
				'type'		=> 'tabs',
				'style'		=> 'style1',
				'group'		=> array(
					array (
						'type'  => 'tab',
						'title' => __( 'Content', 'spyro-modules' ),
						'group' => array (
							
							'monthly_price',
							'annual_price',
							'plan_label',
							'btn_text',
							'icon',
							'url',
						)
					),
					array(
						'type' => 'tab',
						'style'		=> 'style1',
						'title' => __('Style', 'spyro-modules'),
						'group'	=> array(
							'style',
							array(
								'type' => 'accordion',
								'active' => array(0),
								'group' => array(
									array(
										'type' => 'panel',
										'style'		=> 'style1',
										'title' => __('Price Table Background', 'spyro-modules'),
										'group' => array(
											'table_back_color',
										)
									),
								),
							),
							array(
								'type' => 'accordion',
								'active' => array(0),
								'group' => array(
									array(
										'type' => 'panel',

										'title' => __('Price Table Header', 'spyro-modules'),
										'group' => array(
											'label_color',
											'price_color',
											'icon_color',
											'price_header_font_buton_set',
											'label_typography',
											'label_font',
											'price_typography',
											'price_font',
										)
									),
									array(
										'type' => 'panel',
										'title' => __('Price Table Body', 'spyro-modules'),
										'group' => array(
											'feature_color',
											'feature_icon_color',
											'feature_border_color',
										
											'price_body_font_buton_set',
											'feature_typography',
											'feature_font',
											
										)
									),
									array(
										'type' => 'panel',
										'title' => __('Button Style', 'spyro-modules'),
										'group' => array(
													'type',
													'button_style',
										)
									),
									array(
										'type' => 'panel',
										'title' => __('Button Colors', 'spyro-modules'),
										'group' => array(
													array(
												'type'  	=> 'tabs',
												'style'		=> 'style1',
												'group'		=> array(
													array(
														'type'		=> 'tab',
														'title'		=> esc_html__('Normal', 'spyro-modules'),
														'group'		=> array(
															'bg_color',
															'color',
															
															
														),
													),
													array(
														'type'		=> 'tab',
														'title'		=> esc_html__('Hover', 'spyro-modules'),
														'group'		=> array(
															'hover_bg_color',
															'hover_color',
														),
													),
												),
											),
		                                            

										)
									),
								),
							),
							
						)
					),
					
					array(
						'type' => 'tab',
						'title' => __('Advanced', 'spyro-modules'),
						'group'	=> array(
							'table_margin'
						)
					)
				)
			)
		),
		'atts' => array_values(array_filter(array(
			
			array(
				'att_name' => 'plan_label',
				'type' => 'text',
				'label' => __('Plan Label', 'spyro-modules'),
				'default' => 'Free',
				'tooltip' => ''
			),

			array(
				'att_name' => 'icon',
				'type' => 'icon_picker',
				'label' => __('Plan Icon', 'spyro-modules'),
				'default' => 'tatsu-icon-user2',
				'tooltip' => ''
			),


			array(
				'att_name' => 'monthly_price',
				'type' => 'text',
				'label' => __('Monthly Price', 'spyro-modules'),
				'default' => '$0.00',
				'tooltip' => ''
			),

			array(
				'att_name' => 'annual_price',
				'type' => 'text',
				'label' => __('Annual Price', 'spyro-modules'),
				'default' => '$0.00',
				'tooltip' => ''
			),

			array(
				'att_name' => 'btn_text',
				'type' => 'text',
				'label' => __('Button Text', 'spyro-modules'),
				'default' => 'sign up free',
				'tooltip' => ''
			),
			array(
				'att_name' => 'url',
				'type' => 'text',
				'is_inline' => false,
				'options' => array(
					'placeholder' => 'https://example.com',
				),
				'label' => __('Link URL', 'spyro-modules'),
				'default' => 'https://example.com',
				
			),

			array(
				'att_name' => 'icon_color',
				'type' => 'color',
				'label' => __('Icon Color', 'spyro-modules'),
				'default' => '#2293D7',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID} .spyro-pricing-table .pricing-head .pricing-head-icon i' => array(
						'property' => 'color',
					),
				),
			),

			array(
				'att_name' => 'price_color',
				'type' => 'color',
				'label' => __('Price Color', 'spyro-modules'),
				'default' => '#343638',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID} .spyro-pricing-table .pricing-head .pricing-price' => array(
						'property' => 'color',
					),
				),
			),

			array(
				'att_name' => 'label_color',
				'type' => 'color',
				'label' => __('Label Color', 'spyro-modules'),
				'default' => '#2293D7',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID} .spyro-pricing-table .pricing-head .pricing-label' => array(
						'property' => 'color',
					),
				),
			),

			array(
				'att_name' => 'feature_color',
				'type' => 'color',
				'label' => __('Feature Color', 'spyro-modules'),
				'default' => '#77797D',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID} .pricing-features-list ul li .feature-item' => array(
						'property' => 'color',
					),
				),
			),

		
			array(
				'att_name' => 'feature_icon_color',
				'type' => 'color',
				'label' => __('Feature Icon Color', 'spyro-modules'),
				'default' => '',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}  .pricing-features-list ul li i' => array(
						'property' => 'color',
					),
				),
			),
		

			array(
				'att_name' => 'feature_border_color',
				'type' => 'color',
				'label' => __('Feature Border Color', 'spyro-modules'),
				'default' => '#DFEDFF',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID} .spyro-pricing-table  ul li' => array(
						'property' => 'border-color',
					),
				),
			),

			array(
				'att_name' => 'table_back_color',
				'type' => 'color',
				'label' => __('Background  Color', 'spyro-modules'),
				'default' => '',
				'tooltip' => '',
				'css' => true,
				'options' => array(
					'gradient' => true
				),
				'selectors' => array(
					'.tatsu-{UUID} .spyro-pricing-table' => array(
						'property' => 'background',
					),
				),
			),

			array(
				'att_name' => 'table_margin',
				'type' => 'input_group',
				'label' => __('Table Padding', 'spyro-modules'),
				'default' => '45px 45px 45px 45px',
				'tooltip' => '',
				'responsive' => true,
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID} .spyro-pricing-table' => array(
						'property' => 'padding',
                        'when' => array(
                            array('table_margin', '!=', array( 'd' => '0px 0px 0px 0px' ) ),
							array( 'table_margin', '!=', '0px 0px 0px 0px' ),
							array( 'table_margin', 'notempty' ),
                           
                        ),
                        'relation' => 'and',
					),
				),
			),

			array(
                'att_name' => 'price_body_font_buton_set',
                'type' => 'button_group',
                'label' => __( 'Typography', 'spyro-modules' ),
                'options' => array(
                    'type_hub' => 'Type Hub',
                    'custom_font' => 'Custom Font',
                ),
                'default' => 'type_hub',
				'tooltip' => '',
				'is_inline' => true,
			),


			array(
				'att_name' => 'feature_typography',
				'type' => 'typography',
				'label' => __( 'Feature Font', 'spyro-modules' ),
				'responsive' => true,
				'default' => '',
				'tooltip' => '',
				'css' => true,
				'is_inline' => true,
				'visible' => array('price_body_font_buton_set', '==', 'custom_font'),
				'selectors' => array(
					'.tatsu-{UUID} .spyro-pricing-table .pricing-features-list ul li .feature-item' => array(
						'property' => 'typography',
					)
				),
			),	

			function_exists('spyro_get_exposed_selectors') ? array(
				'att_name'	=> 'feature_font',
				'type'		=> 'select',
				'label'		=> esc_html__('Feature Font', 'spyro-modules'),
				'options'	=> spyro_get_exposed_selectors(),
				'default'	=> 'default',
				'tooltip'	=> '',
				'visible' => array('price_body_font_buton_set', '==', 'type_hub'),
			) : false,

			array(
                'att_name' => 'price_header_font_buton_set',
                'type' => 'button_group',
                'label' => __( 'Typography', 'spyro-modules' ),
                'options' => array(
                    'type_hub' => 'Type Hub',
                    'custom_font' => 'Custom Font',
                ),
                'default' => 'type_hub',
				'tooltip' => '',
				'is_inline' => true,
			),

			array(
				'att_name' => 'price_typography',
				'type' => 'typography',
				'label' => __( 'Price Font', 'spyro-modules' ),
				'responsive' => true,
				'default' => '',
				'tooltip' => '',
				'css' => true,
				'is_inline' => true,
				'visible' => array('price_header_font_buton_set', '==', 'custom_font'),
				'selectors' => array(
					'.tatsu-{UUID} .spyro-pricing-table .pricing-head .pricing-price' => array(
						'property' => 'typography',
					)
				),
			),	
			function_exists('spyro_get_exposed_selectors') ? array(
				'att_name'	=> 'price_font',
				'type'		=> 'select',
				'label'		=> esc_html__('Price Font', 'spyro-modules'),
				'options'	=> spyro_get_exposed_selectors(),
				'default'	=> 'default',
				'tooltip'	=> '',
				'visible' => array('price_header_font_buton_set', '==', 'type_hub'),
			) : false,

			array(
				'att_name' => 'label_typography',
				'type' => 'typography',
				'label' => __( 'Label Font', 'spyro-modules' ),
				'responsive' => true,
				'default' => '',
				'tooltip' => '',
				'css' => true,
				'is_inline' => true,
				'visible' => array('price_header_font_buton_set', '==', 'custom_font'),
				'selectors' => array(
					'.tatsu-{UUID} .spyro-pricing-table .pricing-head .pricing-label' => array(
						'property' => 'typography',
					)
				),
			),	
			function_exists('spyro_get_exposed_selectors') ? array(
				'att_name'	=> 'label_font',
				'type'		=> 'select',
				'label'		=> esc_html__('Label Font', 'spyro-modules'),
				'options'	=> spyro_get_exposed_selectors(),
				'default'	=> 'default',
				'tooltip'	=> '',
				'visible' => array('price_header_font_buton_set', '==', 'type_hub'),
			) : false,

			// Button Options
			array(
				'att_name' => 'type',
				'is_inline' => true,
				'type' => 'button_group',
				'label' => esc_html__('Size', 'spyro-modules'),
				'options' => array(
					'small' => 'S',
					'medium' => 'M',
					'large' => 'L',
					'x-large' => 'XL',
					'block' => 'Block',
				),
				'default' => 'medium',
				'tooltip' => ''
			),
			array(
				'att_name' => 'button_style',
				'is_inline' => true,
				'type' => 'button_group',
				'label' => esc_html__('Shape', 'spyro-modules'),
				'options' => array(
					'none' => 'Rectangular',
					'rounded' => 'Rounded',
					'circular' => 'Pill'
				),
				'default' => 'none',
				'tooltip' => ''
			),
				array(
				'att_name' => 'bg_color',
				'type' => 'color',
				'label' => esc_html__('Background', 'spyro-modules'),
				'default' => '#2293d7',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID} .spyro-pricing-table .pricing-footer .tatsu-button-wrap .tatsu-button' => array(
						'property' => 'background-color'
					),
				),
			),
			array(
				'att_name' => 'hover_bg_color',
				'type' => 'color',
				'label' => esc_html__('Background', 'spyro-modules'),
				'default' => '#2293d7',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID} .spyro-pricing-table .pricing-footer .tatsu-button-wrap .tatsu-button:hover' => array(
						'property' => 'background-color'
					),
				),
			),
			array(
				'att_name' => 'color',
				'type' => 'color',
				'label' => esc_html__('Text', 'spyro-modules'),
				'default' => '#fff',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID} .spyro-pricing-table .pricing-footer .tatsu-button-wrap .tatsu-button' => array(
						'property' => 'color',
					),
				),
			),
			array(
				'att_name' => 'hover_color',
				'type' => 'color',
				'label' => esc_html__('Text', 'spyro-modules'),
				'default' => '#fff',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID} .spyro-pricing-table .pricing-footer .tatsu-button-wrap .tatsu-button:hover' => array(
						'property' => 'color',
					),
				),
			),
			
			
			
		))),
		'presets' => array(
			'default' => array(
				'title' => '',
				
				'preset' => array(
					'style'		=> 'style2',
					
					'feature_icon_color' => array('id' => 'palette:0', 'color' => tatsu_get_color('tatsu_accent_color')),
					
				),
			)
		),


	);
	tatsu_remap_modules(array('spyro_price_toggle', 'labels'), $controls, 'spyro_price_toggle');
}


add_action('tatsu_register_modules', 'spyro_register_plan_features');
function spyro_register_plan_features()
{
	$controls = array(
		'icon' => '',
		'title' => __('Plan Feature', 'spyro-modules'),
		'child_module' => '',
		'type' => 'sub_module',
		'is_built_in' => false,
		'hint' => 'feature',
		'group_atts' => array(

			array(
				'type'		=> 'tabs',
				'style'		=> 'style1',
				'group'		=> array(
					array(
						'type' => 'tab',
						'title' => __('Content', 'spyro-modules'),
						'group'	=> array(
							'feature',
							'icon',
							
						)
					),

					array(
						'type' => 'tab',
						'title' => __('Style', 'spyro-modules'),
						'group'	=> array(
							'icon_sep_color',
							'feature_sep_color',
						)
					),

					
				),
			)
		),
		'atts' => array(
			array(
				'att_name' => 'feature',
				'type' => 'text',
				'label' => __('Feature', 'spyro-modules'),
				'default' => 'Unlimited Projects',
				'tooltip' => ''
			),
			
			array(
				'att_name' => 'icon',
				'type' => 'icon_picker',
				'label' => __('Icon', 'spyro-modules'),
				'default' => 'tatsu-icon-check-square',
				'tooltip' => ''
			),

			array(
				'att_name' => 'feature_sep_color',
				'type' => 'color',
				'label' => __('Feature Color', 'spyro-modules'),
				'default' => '',
				'tooltip' => __('This option used to highlight the feature' , 'spyro-modules'),
				'css' => true,
				'selectors' => array(
					'.spyro-pricing-table .pricing-features-list ul li.tatsu-{UUID} .feature-item' => array(
						'property' => 'color',
					),
				),
			),

			

			array(
				'att_name' => 'icon_sep_color',
				'type' => 'color',
				'label' => __('Icon Color', 'spyro-modules'),
				'default' => '',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.spyro-pricing-table .pricing-features-list ul li.tatsu-{UUID} i' => array(
						'property' => 'color',
					),
				),
			),

			

		

			

			
			
		),
		'presets' => array(
			'default' => array(
				'feature' => '',
				'icon' => '',
				
				'preset' => array(
					'feature' => 'Unlimited Projects',
					
					
				),
			)
		),
	);
	tatsu_remap_modules(array('spyro_plan_features', 'tab'), $controls, 'spyro_plan_features');
}
