<?php
/**************************************
			Price Switch
**************************************/
if (!function_exists('spyro_price_switch')) {
	function spyro_price_switch( $atts, $content, $tag ) {
        $atts = shortcode_atts( array (
        	 'title_color' => '',
        	 'active_title_color' => '',
        	 'switch_color' =>'',
        	 'switch_dot_color' => '',
        	 'discount_back_color' => '',
        	 'discount_color' => '',
			'monthly_title' => '',
			'annual_title' => '',
			'dis_title' => '',
			'label_typography' => '',
			'dis_typography' => '',
			'label_font' => '',
			'dis_font' => '',
        	'key' => be_uniqid_base36(true),
        ),$atts, $tag );
        
		extract( $atts );
		
		
		$GLOBALS['tabs_cnt'] = 0;
		$tabs_cnt=0;
        $GLOBALS['features'] = array();
		$rand = rand();
        $content=do_shortcode( $content );
		$custom_style_tag = be_generate_css_from_atts( $atts, 'spyro_price_switch', $key );
		
		$custom_class_name = 'tatsu-'.$atts['key'];
		$data_animations = be_get_animation_data_atts( $atts );

		$css_id = be_get_id_from_atts( $atts );
		$visibility_classes = be_get_visibility_classes_from_atts( $atts ); 
		
		$animate = ( isset( $animate ) && 1 == $animate  && 'none' != $animation_type ) ? ' tatsu-animate ' : '';
		$html = '';
		ob_start();
		remove_filter('the_content', 'wpautop');
		remove_filter('the_content', 'wptexturize');
		// if(empty($label_font))
		// {
		// 	$label_font = 'default';
		// }
		// if(empty($dis_font))
		// {
		// 	$dis_font = 'default';
		// }
		?>
		<div class="price-main <?php echo $custom_class_name; ?>"  <?php echo $css_id; ?> > 
			 <div class="spyro-price-switcher">
                    <div class="price-switch-container">
                        <span class="switch-label monthly active <?php echo $label_font ?>"><?php echo esc_html($atts['monthly_title']); ?></span>
                        <div class="custom-switcher" >
                           <div class="custom-switch" id="custom-switch-input">
                           		<input type="checkbox" id="custom-switch-0" name="custom-switch-input" class="custom-switch-input" />
                           		<label for="custom-switch-0"></label>
                           	</div>
                        </div>
                        <span class="switch-label annually <?php echo $label_font ?>"><?php echo esc_html($atts['annual_title']); ?></span>
                        <span class="switch-promo <?php echo $dis_font ?>"><?php echo esc_html($atts['dis_title']); ?></span>
                    </div>
            </div>
		<?php 
		echo $custom_style_tag;
		return ob_get_clean();
	}
}
add_action('tatsu_register_modules', 'spyro_register_price_switch');
function spyro_register_price_switch()
{
	$controls = array(
		'icon' => TATSU_PLUGIN_URL . '/builder/svg/modules.svg#tabs',
		'title' => __('Spyro Price Switch', 'spyro-modules'),
		'is_js_dependant' => true,
		'child_module' => '',
		'type' => 'single',
		'is_built_in' => false,
		'category' => 'pricing',
		'group_atts' => array(
			array(
				'type'		=> 'tabs',
				'style'		=> 'style1',
				'group'		=> array(
					array (
						'type'  => 'tab',
						'title' => __( 'Content', 'spyro-modules' ),
						'group' => array (
							'monthly_title',
							'annual_title',
							'dis_title',
							
						)
					),

					array(
						'type' => 'tab',
						'title' => __('Style', 'spyro-modules'),
						'group'	=> array(
							'style',
							array(
								'type' => 'accordion',
								'active' => array(0),
								'group' => array(
									array(
										'type' => 'panel',
										'title' => __('Colors', 'spyro-modules'),
										'group' => array(
											
													array(
														'type'		=> 'tab',
														'title'		=> __('Normal', 'spyro-modules'),
														'group'		=> array(
															'title_color',
															'active_title_color',
															'switch_color',
															'switch_dot_color',
															'discount_back_color',
															'discount_color',
															
														),
													),
													
												
											
										)
									),
									array(
										'type' => 'panel',
										'title' => __('Typography', 'spyro-modules'),
										'group' => array(
											
											array(
												'type'  	=> 'tabs',
												'style'		=> 'style1',
												'group'		=> array(
													array(
														'type'		=> 'tab',
														'title'		=> __('Type Hub', 'spyro-modules'),
														'group'		=> array(
															'label_font',
															'dis_font'
														),
													),
													array(
														'type'		=> 'tab',
														'title'		=> __('Custom Font', 'spyro-modules'),
														'group'		=> array(
															'label_typography',
															'dis_typography',
														),
													),
												),
											),
										)
									),
								),
							),
						),
					),
					
					array(
						'type' => 'tab',
						'title' => __('Advanced', 'spyro-modules'),
						'group'	=> array(
							
						)
					)
				)
			)
		),
		'atts' => array_values(array_filter(array(
			array(
				'att_name' => 'monthly_title',
				'type' => 'text',
				'label' => __('Monthly Title', 'spyro-modules'),
				'default' => 'Billed Monthly',
				'tooltip' => ''
			),

			array(
				'att_name' => 'annual_title',
				'type' => 'text',
				'label' => __('Annually Title', 'spyro-modules'),
				'default' => 'Billed Yearly',
				'tooltip' => ''
			),

			array(
				'att_name' => 'dis_title',
				'type' => 'text',
				'label' => __('Discount Title', 'spyro-modules'),
				'default' => '20% Discount',
				'tooltip' => ''
			),
			array(
				'att_name' => 'active_title_color',
				'type' => 'color',
				'label' => __('Active Title Color', 'spyro-modules'),
				'default' => '#2293D7',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID} .spyro-price-switcher .price-switch-container .switch-label.active' => array(
						'property' => 'color',
					),
				),
			),

			array(
				'att_name' => 'title_color',
				'type' => 'color',
				'label' => __('Title Color', 'spyro-modules'),
				'default' => '#343638',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID} .spyro-price-switcher  .switch-label' => array(
						'property' => 'color',
					),
				),
			),

			array(
				'att_name' => 'switch_color',
				'type' => 'color',
				'label' => __('Switch Background Color', 'spyro-modules'),
				'default' => '#2293d7',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID} .spyro-price-switcher .price-switch-container .custom-switcher label' => array(
						'property' => 'background',
					),
				),
			),

			array(
				'att_name' => 'switch_dot_color',
				'type' => 'color',
				'label' => __('Switch Dot Color', 'spyro-modules'),
				'default' => '#fff',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
                        '.tatsu-{UUID} .spyro-price-switcher .price-switch-container .custom-switcher label:after' =>  array(
                            'property' => 'background'
                        ),
                        '.tatsu-{UUID} .pricing-tables .switch .custom-switch input:checked + label:after'	=> array (
                            'property'	=> 'background',
                        ),
                    ),
			),

			array(
				'att_name' => 'discount_color',
				'type' => 'color',
				'label' => __('Discount Text Color', 'spyro-modules'),
				'default' => '#EA5151',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID} .spyro-price-switcher .price-switch-container .switch-promo' => array(
						'property' => 'color',
					),
				),
			),

			array(
				'att_name' => 'discount_back_color',
				'type' => 'color',
				'label' => __('Discount Background Color', 'spyro-modules'),
				'default' => '#fff',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID} .spyro-price-switcher .price-switch-container .switch-promo' => array(
						'property' => 'background',
					),
				),
			),
			array(
				'att_name' => 'label_typography',
				'type' => 'typography',
				'label' => __( 'Label Font', 'spyro-modules' ),
				'responsive' => true,
				'default' => '',
				'tooltip' => '',
				'css' => true,
				'is_inline' => true,
				'selectors' => array(
					'.tatsu-{UUID} .spyro-price-switcher .price-switch-container .switch-label' => array(
						'property' => 'typography',
					)
				),
			),	
			function_exists('spyro_get_exposed_selectors') ? array(
				'att_name'	=> 'label_font',
				'type'		=> 'select',
				'label'		=> esc_html__('Title Font', 'spyro-modules'),
				'options'	=> spyro_get_exposed_selectors(),
				'default'	=> 'default',
				'tooltip'	=> ''
			) : false,

			array(
				'att_name' => 'dis_typography',
				'type' => 'typography',
				'label' => __( 'Discount Font', 'spyro-modules' ),
				'responsive' => true,
				'default' => '',
				'tooltip' => '',
				'css' => true,
				'is_inline' => true,
				'selectors' => array(
					'.tatsu-{UUID} .spyro-price-switcher .price-switch-container .switch-promo' => array(
						'property' => 'typography',
					)
				),
			),	
			function_exists('spyro_get_exposed_selectors') ? array(
				'att_name'	=> 'dis_font',
				'type'		=> 'select',
				'label'		=> esc_html__('Discount Font', 'spyro-modules'),
				'options'	=> spyro_get_exposed_selectors(),
				'default'	=> 'default',
				'tooltip'	=> ''
			) : false,
			//
		))),
		'presets' => array(
			'default' => array(
				'title' => '',
				'image' => '',
				
				'preset' => array(
					'style'		=> 'style2',
					
					
				),
			)
		),


	);
	tatsu_remap_modules(array('spyro_price_switch', 'labels'), $controls, 'spyro_price_switch');
}



