<?php
/**************************************
			TABS
**************************************/
if (!function_exists('spyro_packages')) {
	function spyro_packages( $atts, $content, $tag ) {
        $atts = shortcode_atts( array (
            'nav_font_button_set' => '',
            'content_font_button_set' => '',
            'content_title_font' => '',
			'desc_font' => '',
			'price_font' => '',
			'content_font' => '',
			'feature_title_font' => '',
			'feature_font' => '',
            'nav_tab_font' => '',
            'active_title_color' =>'',
            'active_background_color' => '',
            'tab_normal_background_color' => '',
            'margin'        => '',
            'tag_to_use'    => 'h4',
			'animate' => '1',
			'content_title_color' => '',
			'content_color' => '',
			
			'content_title_typography' => '',
			'desc_typography' => '',
			'price_typography' => '',
			'content_typography' => '',
			'btn_text' => '',
			
			'package_box_shadow' => '',
			'nav_tab_typography' => '',
			'btn_size' => '',
			'btn_style' => '',
			'button_back_color' => '',
			'button_text_color' => '',
			'button_text_hover_color' => '',
			'button_back_hover_color' => '',
			'btn_hover_box_shadow' => '',
			'btn_box_shadow' => '',
			'btn_text_typography' => '',
			'feature_icon_color' => '',
			'package_container_back_color' => '',
			'feature_color' => '',
			'feature_title_color' => '',
			'feature_typography' => '',
			'feature_title_typography' => '',			
			'image_offset' => '',
			'package_1' => '',
			'package_2' => '',
			'package_3' => '',
			'package_4' => '',
			'package_desc_color' => '',
			'package_price_color' => '',
        	'key' => be_uniqid_base36(true),
        ),$atts, $tag );
        
       	extract( $atts );
        $tag = $atts['tag_to_use'];

		$package_1 = tatsu_parse_custom_fields( $package_1 );
		$package_2 = tatsu_parse_custom_fields( $package_2 );
		$package_3 = tatsu_parse_custom_fields( $package_3 );
		$package_4 = tatsu_parse_custom_fields( $package_4 );

		$GLOBALS['tabs_cnt'] = 0;
		$tabs_cnt=0;
        $GLOBALS['tabs'] = array();
		$rand = rand();
        $content=do_shortcode( $content );
        $custom_style_tag = be_generate_css_from_atts( $atts, 'spyro_packages', $key );
		$custom_class_name = 'tatsu-'.$atts['key'];
		$data_animations = be_get_animation_data_atts( $atts );

		$css_id = be_get_id_from_atts( $atts );
		$visibility_classes = be_get_visibility_classes_from_atts( $atts ); 
		
		$animate = ( isset( $animate ) && 1 == $animate  && 'none' != $animation_type ) ? ' tatsu-animate ' : '';

		$tab_class = '';
		$tab_content_holder = '';
		$tab_holder = '';
		ob_start();

		remove_filter('the_content', 'wpautop');
		remove_filter('the_content', 'wptexturize');
		$pack_array = array('package_1' , 'package_2' , 'package_3' , 'package_4');

		// if(empty($nav_tab_font))
		// {
		// 	$nav_tab_font = 'default';
		// }

		?>
		<div class="spyro-package two-column <?php echo $custom_class_name; ?>">
			 <div class="package-navigation">
			 	
                <ul>
                	<?php 
                	$random = rand(10,99);
			 	 if( is_array( $pack_array ) ) 
        		{
			
			foreach( $pack_array  as $key => $pack_val ) 
			{
				if($key == 0)
				{
					$activeclass = 'active';
				}
				else
				{
					$activeclass = '';
				}
				if(!empty($atts[$pack_val]))
				{
			 	?>
                    <li><a href="#" class="<?php echo $activeclass .' '.$nav_tab_font; ?>" data-package_name="<?php echo $pack_val."_".$random; ?>"><?php echo tatsu_parse_custom_fields( $atts[$pack_val] ); ?></a></li>
                    
             <?php } } } ?>
                </ul>
            </div>
            <?php 

        if( is_array( $pack_array ) ) 
        {
			
			foreach( $pack_array  as $key => $pack_val ) 
			{
				$tabs_cnt++;
				if($key == 0)
				{
					$activeclass = 'active';
				}
				else
				{
					$activeclass = '';
				}
			?>
			 <div class="package-block-wrap <?php echo $activeclass.' '.$pack_val."_".$random; ?>">

	         		<div class="package-container">

	                 <?php 
	                 
	                 	echo spyro_get_link_packages_content($GLOBALS['tabs'] , $pack_val , $atts); 
	                 ?>
	                 
	           </div>
    		</div>             
			<?php
		 	} 
		} 
		?>
		</div>
                                
		

         <?php echo $custom_style_tag; ?>
       
		<?php
		return ob_get_clean();
		
	}

	//add_shortcode( 'tabs', 'spyro_packages' );

}

if (!function_exists('spyro_package')) {
	function spyro_package( $atts, $content ){
		$atts = shortcode_atts( array(
	       
			'title' => '',
			'image' => '',
			'content_title' => '',
			'feature_items' => '',
			'feature_icon' => '',
			'btn_text' => '',
			'btn_url' => '',
			'link_package' =>'',
			'package_price' =>'',
			'package_desc' =>'',
			'feature_title' =>'',
			'package_back_color' =>'',
			'key' => be_uniqid_base36(true),
		),$atts );
		
		$custom_style_tag = be_generate_css_from_atts( $atts, 'spyro_package', $atts['key'] );
		$custom_class_name = 'tatsu-'.$atts['key'];

		extract( $atts );

		$title = tatsu_parse_custom_fields( $title );
		$content_title = tatsu_parse_custom_fields( $content_title );
		$package_price = tatsu_parse_custom_fields( $package_price );
		$package_desc = tatsu_parse_custom_fields( $package_desc );
		$btn_text = tatsu_parse_custom_fields( $btn_text );
		$btn_url = tatsu_parse_custom_fields( $btn_url );
		$content = do_shortcode( $content );

		$x = $GLOBALS['tabs_cnt'];
		$GLOBALS['tabs'][$x] = array( 
				'image' => $image, 'title' => sprintf( $title, $GLOBALS['tabs_cnt'] ), 'content' =>  $content, 'class_name' => $custom_class_name, 'custom_style_tag' => $custom_style_tag , 'feature_items' => $feature_items , 'feature_icon' => $feature_icon , 'btn_text' => $btn_text , 
			'btn_url' => $btn_url , 
			'link_package' => $link_package, 
			'package_price' => $package_price, 
			'package_desc' => $package_desc, 
			'feature_title' => $feature_title, 
			'content_title' => $content_title, 
			'package_back_color' => $package_back_color, 
		);
		$GLOBALS['tabs_cnt']++;
	}
}

add_action('tatsu_register_modules', 'spyro_register_packages');
function spyro_register_packages()
{
	$controls = array(
		'icon' => TATSU_PLUGIN_URL . '/builder/svg/modules.svg#tabs',
		'title' => __('Spyro Packages', 'spyro-modules'),
		'is_js_dependant' => true,
		'child_module' => 'spyro_package',
		'type' => 'multi',
		'initial_children' => 2,
		'is_built_in' => false,
		'is_dynamic' => true,
		'category' => 'pricing',
		'group_atts' => array(
			array(
				'type'		=> 'tabs',
				'style'		=> 'style1',
				'group'		=> array(
					array (
						'type'  => 'tab',
						'title' => __( 'Content', 'spyro-modules' ),
						'group' => array (
							'package_1',
							'package_2',
							'package_3',
							'package_4',
						)
					),
					
					array(
						'type' => 'tab',
						'title' => __('Style', 'spyro-modules'),
						'group'	=> array(
							'style',
							'package_box_shadow',
							array(
								'type' => 'accordion',
								'active' => array(0),
								'group' => array(
									array(
										'type' => 'panel',
										'title' => __('Tab Navigation', 'spyro-modules'),
										'group' => array(
											array(
												'type'  	=> 'tabs',
												'style'		=> 'style1',
												'group'		=> array(
													array(
														'type'		=> 'tab',
														'title'		=> __('Normal Color', 'spyro-modules'),
														'group'		=> array(
															'title_color',
															'tab_normal_background_color',
															
														),
													),
													array(
														'type'		=> 'tab',
														'title'		=> __('Active Color', 'spyro-modules'),
														'group'		=> array(
															'active_title_color',
															'active_background_color',
														),
													),
												),
											),
											'nav_font_button_set',
											'nav_tab_typography',
											'nav_tab_font'
										)
									),
									array(
										'type' => 'panel',
										'title' => __('Tab Content Color', 'spyro-modules'),
										'group' => array(
											
											'content_title_color',
											'package_desc_color',
											'package_price_color',
											'content_color',
											'feature_title_color',
											'feature_color',
											'feature_icon_color',
											'package_container_back_color',
										)
									),
									array(
										'type' => 'panel',
										'title' => __('Tab Content Typography', 'spyro-modules'),
										'group' => array(
											
											

											'content_font_button_set',
											'content_title_typography',
											'desc_typography',
											'price_typography',
											'content_typography',
											'feature_title_typography',
											'feature_typography',
											'content_title_font',
											'desc_font',
											'price_font',
											'content_font',
											'feature_title_font',
											'feature_font'
											
										)
									),
									
									array(
										'type' => 'panel',
										'title' => __('Button Options', 'spyro-modules'),
										'group' => array(
											'btn_size',
											'btn_style',
											
											array(
												'type'  	=> 'tabs',
												'style'		=> 'style1',
												'group'		=> array(
													array(
														'type'		=> 'tab',
														'title'		=> __('Normal Color', 'spyro-modules'),
														'group'		=> array(
															'button_back_color',
															'button_text_color',
															'btn_text_typography',
															'btn_box_shadow',
														),
													),
													array(
														'type'		=> 'tab',
														'title'		=> __('Hover Color', 'spyro-modules'),
														'group'		=> array(
															'button_back_hover_color',
															'button_text_hover_color',
															'btn_hover_box_shadow',
														),
													),
												),
											),
										)
									),

									
									
								),
							),
						),
					),
					array(
						'type' => 'tab',
						'title' => __('Advanced', 'spyro-modules'),
						'group'	=> array(
							array(
								'type' => 'accordion',
								'active' => array(0),
								'group' => array(
									array(
										'type' => 'panel',
										'title' => __('Border', 'spyro-modules'),
										'group' => array(
											
											
											
										)
									),
								)
							)
						)
					)
				)
			)
		),
		'atts' => array_values(array_filter(array(
			/*array(
				'att_name' => 'style',
				'type' => 'select',
				'is_inline' => true,
				'label' => __('Style', 'spyro-modules'),
				'options' => array(
					'style1' 	=> 'Style 1',
					'style2' 	=> 'Style 2',
					'style3' 	=> 'Style 3',
					'style4' 	=> 'Style 4',
				),
				'default' => 'style1',
				'tooltip' => ''
			),*/
			
			array(
				'att_name' => 'title_color',
				'type' => 'color',
				'label' => __('Title', 'spyro-modules'),
				'default' => '#343638',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-package  ul li a' => array(
						'property' => 'color',
					),
				),
			),

			

			array(
				'att_name' => 'tab_normal_background_color',
				'type' => 'color',
				'label' => __('Background', 'spyro-modules'),
				'default' => '#fdfefe',
				'tooltip' => '',
				
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-package  ul li a' => array(
						'property' => 'background',
					),

					
				),
			),
		
			array(
				'att_name' => 'active_title_color',
				'type' => 'color',
				'label' => __('Title', 'spyro-modules'),
				'default' => '#fff',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-package .package-navigation ul li a.active' => array(
						'property' => 'color',
					),
				),
			),

			
			array(
				'att_name' => 'active_background_color',
				'type' => 'color',
				'label' => __('Background', 'spyro-modules'),
				'default' => '#2293D7',
				'tooltip' => '',
				
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-package .package-navigation ul li a.active' => array(
						'property' => 'background',
					),
				),
			),
			array(
				'att_name' => 'package_1',
				'type' => 'text',
				'label' => __('Package 1', 'spyro-modules'),
				'default' => 'Upto to 100 guest',
				'tooltip' => ''
			),
			array(
				'att_name' => 'package_2',
				'type' => 'text',
				'label' => __('Package 2', 'spyro-modules'),
				'default' => 'Upto to 200 guest',
				'tooltip' => ''
			),
			array(
				'att_name' => 'package_3',
				'type' => 'text',
				'label' => __('Package 3', 'spyro-modules'),
				'default' => 'Upto to 300 guest',
				'tooltip' => ''
			),
			array(
				'att_name' => 'package_4',
				'type' => 'text',
				'label' => __('Package 4', 'spyro-modules'),
				'default' => 'Upto to 400 guest',
				'tooltip' => ''
			),
			 array(
                'att_name' => 'tag_to_use',
                'type' => 'select',
                'label' => __('Tag to use for title', 'spyro-modules'),
                'options' => array(
                    'h1' => 'H1',
                    'h2' => 'H2',
                    'h3' => 'H3',
                    'h4' => 'H4',
                    'h5' => 'H5',
                    'h6' => 'H6',
                    'p' => 'P',
                    'span' => 'Span',
                    'div' => 'Div',
                ),
                'default' => 'h4',
                'tooltip' => '',
			),
			array(
				'att_name' => 'content_title_color',
				'type' => 'color',
				'label' => __('Title', 'spyro-modules'),
				'default' => '',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-package .package-container .package-block .package-content-wrap .package-header .package-title' => array(
						'property' => 'color'
					),
				)
			),
			array(
				'att_name' => 'package_desc_color',
				'type' => 'color',
				'label' => __('Subheading', 'spyro-modules'),
				'default' => '',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-package .package-container .package-block .package-content-wrap .package-header .package-desc' => array(
						'property' => 'color'
					),
				)
			),
			array(
				'att_name' => 'package_price_color',
				'type' => 'color',
				'label' => __('Price', 'spyro-modules'),
				'default' => '',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-package .package-container .package-block .package-content-wrap .package-header .package-price' => array(
						'property' => 'color'
					),
				)
			),

			array(
				'att_name' => 'content_color',
				'type' => 'color',
				'label' => __('Content', 'spyro-modules'),
				'default' => '',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-package .package-container .package-block .package-content-wrap .package-body' => array(
						'property' => 'color'
					),
				),
			),
			array(
				'att_name' => 'feature_title_color',
				'type' => 'color',
				'label' => __('List Title', 'spyro-modules'),
				'default' => '',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-package .package-container .package-block .package-content-wrap .package-lists .package-list-title' => array(
						'property' => 'color'
					),
				),
			),
			array(
				'att_name' => 'feature_color',
				'type' => 'color',
				'label' => __('List', 'spyro-modules'),
				'default' => '',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-package .package-container .package-block .package-content-wrap .package-lists ul li .package-list-item' => array(
						'property' => 'color'
					),
				),
			),

			array(
				'att_name' => 'feature_icon_color',
				'type' => 'color',
				'label' => __('List Icon', 'spyro-modules'),
				'default' => '',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-package .package-container .package-block .package-content-wrap .package-lists ul li i' => array(
						'property' => 'color'
					),
				),
			),

			array(
				'att_name' => 'package_container_back_color',
				'type' => 'color',
				'label' => __('Package Container Background', 'spyro-modules'),
				'default' => '',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-package .package-container .package-block' => array(
						'property' => 'background'
					),
				),
			),

			array(
                'att_name' => 'content_font_button_set',
                'type' => 'button_group',
                'label' => __( 'Typography', 'spyro-modules' ),
                'options' => array (
                    'type_hub' => 'Type Hub',
                    'custom_font' => 'Custom',
                ),
                'default' => 'type_hub',
				'tooltip' => '',
				'is_inline' => true,
			),
			
			array(
				'att_name' => 'content_title_typography',
				'type' => 'typography',
				'label' => __( 'TItle', 'spyro-modules' ),
				'responsive' => true,
				'default' => '',
				'tooltip' => '',
				'css' => true,
				'is_inline' => true,
				'visible' => array('content_font_button_set', '==', 'custom_font'),
				'selectors' => array(
					'.tatsu-{UUID}.spyro-package .package-container .package-block .package-content-wrap .package-header .package-title' => array(
						'property' => 'typography',
					)
				),
			),
			function_exists('spyro_get_exposed_selectors') ? array(
				'att_name'	=> 'content_title_font',
				'type'		=> 'select',
				'label'		=> esc_html__('Title', 'spyro-modules'),
				'options'	=> spyro_get_exposed_selectors(),
				'default'	=> 'default',
				'visible' => array('content_font_button_set', '==', 'type_hub'),
				'tooltip'	=> ''
			) : false,
			array(
				'att_name' => 'desc_typography',
				'type' => 'typography',
				'label' => __( 'Subheading', 'spyro-modules' ),
				'responsive' => true,
				'default' => '',
				'tooltip' => '',
				'css' => true,
				'is_inline' => true,
				'visible' => array('content_font_button_set', '==', 'custom_font'),
				'selectors' => array(
					'.tatsu-{UUID}.spyro-package .package-container .package-block .package-content-wrap .package-header .package-desc' => array(
						'property' => 'typography',
					)
				),
			),
			function_exists('spyro_get_exposed_selectors') ? array(
				'att_name'	=> 'desc_font',
				'type'		=> 'select',
				'label'		=> esc_html__('Subheading', 'spyro-modules'),
				'options'	=> spyro_get_exposed_selectors(),
				'default'	=> 'default',
				'visible' => array('content_font_button_set', '==', 'type_hub'),
				'tooltip'	=> ''
			) : false,
			array(
				'att_name' => 'price_typography',
				'type' => 'typography',
				'label' => __( 'Price', 'spyro-modules' ),
				'responsive' => true,
				'default' => '',
				'tooltip' => '',
				'css' => true,
				'is_inline' => true,
				'visible' => array('content_font_button_set', '==', 'custom_font'),
				'selectors' => array(
					'.tatsu-{UUID}.spyro-package .package-container .package-block .package-content-wrap .package-header .package-price' => array(
						'property' => 'typography',
					)
				),
			),
			function_exists('spyro_get_exposed_selectors') ? array(
				'att_name'	=> 'price_font',
				'type'		=> 'select',
				'label'		=> esc_html__('Price', 'spyro-modules'),
				'options'	=> spyro_get_exposed_selectors(),
				'default'	=> 'default',
				'visible' => array('content_font_button_set', '==', 'type_hub'),
				'tooltip'	=> ''
			) : false,
			array(
				'att_name' => 'content_typography',
				'type' => 'typography',
				'label' => __( 'Content', 'spyro-modules' ),
				'responsive' => true,
				'default' => '',
				'tooltip' => '',
				'css' => true,
				'is_inline' => true,
				'visible' => array('content_font_button_set', '==', 'custom_font'),
				'selectors' => array(
					'.tatsu-{UUID}.spyro-package .package-container .package-block .package-content-wrap .package-body' => array(
						'property' => 'typography',
					)
				),
			),
			function_exists('spyro_get_exposed_selectors') ? array(
				'att_name'	=> 'content_font',
				'type'		=> 'select',
				'label'		=> esc_html__('Content', 'spyro-modules'),
				'options'	=> spyro_get_exposed_selectors(),
				'default'	=> 'default',
				'visible' => array('content_font_button_set', '==', 'type_hub'),
				'tooltip'	=> ''
			) : false,
			array(
				'att_name' => 'feature_title_typography',
				'type' => 'typography',
				'label' => __( 'List Title', 'spyro-modules' ),
				'responsive' => true,
				'default' => '',
				'tooltip' => '',
				'visible' => array('content_font_button_set', '==', 'custom_font'),
				'css' => true,
				'is_inline' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-package .package-container .package-block .package-content-wrap .package-lists .package-list-title' => array(
						'property' => 'typography',
					)
				),
			),
			function_exists('spyro_get_exposed_selectors') ? array(
				'att_name'	=> 'feature_title_font',
				'type'		=> 'select',
				'label'		=> esc_html__('List Title', 'spyro-modules'),
				'options'	=> spyro_get_exposed_selectors(),
				'default'	=> 'default',
				'visible' => array('content_font_button_set', '==', 'type_hub'),
				'tooltip'	=> ''
			) : false,

				array(
				'att_name' => 'feature_typography',
				'type' => 'typography',
				'label' => __( 'List', 'spyro-modules' ),
				'responsive' => true,
				'default' => '',
				'tooltip' => '',
				'css' => true,
				'is_inline' => true,
				'visible' => array('content_font_button_set', '==', 'custom_font'),
				'selectors' => array(
					'.tatsu-{UUID}.spyro-package .package-container .package-block .package-content-wrap .package-lists ul li .package-list-item' => array(
						'property' => 'typography',
					)
				),
			),
			function_exists('spyro_get_exposed_selectors') ? array(
				'att_name'	=> 'feature_font',
				'type'		=> 'select',
				'label'		=> esc_html__('List', 'spyro-modules'),
				'options'	=> spyro_get_exposed_selectors(),
				'default'	=> 'default',
				'visible' => array('content_font_button_set', '==', 'type_hub'),
				'tooltip'	=> ''
			) : false,
			array(
                'att_name' => 'nav_font_button_set',
                'type' => 'button_group',
                'label' => __( 'Typography', 'spyro-modules' ),
                'options' => array (
                    'type_hub' => 'Type Hub',
                    'custom_font' => 'Custom',
                ),
                'default' => 'type_hub',
				'tooltip' => '',
				'is_inline' => true,
			),
			array(
				'att_name' => 'nav_tab_typography',
				'type' => 'typography',
				'label' => __( 'Title', 'spyro-modules' ),
				'responsive' => true,
				'default' => '',
				'tooltip' => '',
				'css' => true,
				'is_inline' => true,
				'visible' => array('nav_font_button_set', '==', 'custom_font'),
				'selectors' => array(
					'.tatsu-{UUID}.spyro-package .package-navigation ul li a' => array(
						'property' => 'typography',
					)
				),
			),
			function_exists('spyro_get_exposed_selectors') ? array(
				'att_name'	=> 'nav_tab_font',
				'type'		=> 'select',
				'label'		=> esc_html__('Title', 'spyro-modules'),
				'options'	=> spyro_get_exposed_selectors(),
				'default'	=> '',
				'tooltip'	=> '',
				'visible' => array('nav_font_button_set', '==', 'type_hub'),
			) : false,
			array(
				'att_name' => 'package_box_shadow',
				'type' => 'input_box_shadow',
				'label' => __('Package Box Shadow', 'spyro-modules'),
				'default' => '0px 20px 70px 0px rgba(0, 0, 0, 0.03);',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-package .package-container .package-block' => array(
						'property' => 'box-shadow',
						'when' => array('package_box_shadow', '!=', '0px 0px 0px 0px rgba(0,0,0,0)'),
					),
				),
			),
			
			

			

			// Button Options

		
			array(
				'att_name' => 'button_back_color',
				'type' => 'color',
				'label' => __('Background', 'spyro-modules'),
				'default' => '',
				'tooltip' => '',
				'options' => array(
					'gradient' => true
				),
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-package .package-container .package-block .package-content-wrap .package-footer .package-btn-wrap .package-btn' => array(
						'property' => 'background',
					),
				),
			),

			array(
				'att_name' => 'button_back_hover_color',
				'type' => 'color',
				'label' => __('Background', 'spyro-modules'),
				'default' => '',
				'tooltip' => '',
				'css' => true,
				'options' => array(
					'gradient' => true
				),
				'selectors' => array(
					'.tatsu-{UUID}.spyro-package .package-container .package-block .package-content-wrap .package-footer .package-btn-wrap .package-btn:hover' => array(
						'property' => 'background',
					),
				),
			),

			array(
				'att_name' => 'button_text_color',
				'type' => 'color',
				'label' => __('Text', 'spyro-modules'),
				'default' => '',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-package .package-container .package-block .package-content-wrap .package-footer .package-btn-wrap .package-btn' => array(
						'property' => 'color',
					),
				),
			),

			array(
				'att_name' => 'btn_text_typography',
				'type' => 'typography',
				'label' => __( 'Text', 'spyro-modules' ),
				'responsive' => true,
				'default' => '',
				'tooltip' => '',
				'css' => true,
				'is_inline' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-package .package-container .package-block .package-content-wrap .package-footer .package-btn-wrap .package-btn' => array(
						'property' => 'typography',
					)
				),
			),	

			array(
				'att_name' => 'button_text_hover_color',
				'type' => 'color',
				'label' => __('Text', 'spyro-modules'),
				'default' => '',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-package .package-container .package-block .package-content-wrap .package-footer .package-btn-wrap .package-btn:hover' => array(
						'property' => 'color',
					),
				),
			),
			array (
                'att_name' => 'btn_size',
                'type' => 'button_group',
                'label' => __( 'Size', 'spyro-modules' ),
                'options' => array (
                    'small' => 'S',
                    'medium' => 'M',	        			
                    'large' => 'L',
                    'x-large' => 'XL',
                ),
                'default' => 'large',
				'tooltip' => '',
				'is_inline' => false,
			),
			 array (
                'att_name' => 'btn_style',
                'type' => 'button_group',
                'label' => __( 'Style', 'spyro-modules' ),
                'options' => array (
                    'btn-rct' => 'Rectangular',
                    'rounded' => 'Roudned',	        			
                    'pill' => 'Pill',
                ),
                'default' => 'btn-rct',
				'tooltip' => '',
				'is_inline' => false,
			),

			 array(
				'att_name' => 'btn_box_shadow',
				'type' => 'input_box_shadow',
				'label' => __('Shadow', 'spyro-modules'),
				'default' => '0px 0px 0px 0px rgba(0,0,0,0)',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-package .package-container .package-block .package-content-wrap .package-footer .package-btn-wrap .package-btn' => array(
						'property' => 'box-shadow',
						'when' => array('btn_box_shadow', '!=', '0px 0px 0px 0px rgba(0,0,0,0)'),
					),
				),
			), 
			array(
				'att_name' => 'btn_hover_box_shadow',
				'type' => 'input_box_shadow',
				'label' => __('Shadow', 'spyro-modules'),
				'default' => '0px 0px 0px 0px rgba(0,0,0,0)',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-package .package-container .package-block .package-content-wrap .package-footer .package-btn-wrap .package-btn:hover' => array(
						'property' => 'box-shadow',
						'when' => array('btn_hover_box_shadow', '!=', '0px 0px 0px 0px rgba(0,0,0,0)'),
					),
				),
			),
			
		))),
		'presets' => array(
			'default' => array(
				'title' => '',
				'image' => '',
				'preset' => array(
					'style'		=> 'style1',
					
				),
			)
		),


	);
	tatsu_remap_modules(array('spyro_packages' , 'tabs'), $controls, 'spyro_packages');

	//tatsu_register_module( 'spyro_packages', $controls );
}

add_action('tatsu_register_modules', 'spyro_register_advance_package');
function spyro_register_advance_package()
{
	$controls = array(
		'icon' => '',
		'title' => __('Spyro Package', 'spyro-modules'),
		'child_module' => 'spyro_package',
		'type' => 'sub_module',
		'is_built_in' => false,
		'is_dynamic' => true,
		'hint' => 'link_package',
		'group_atts' => array(
			array(
				'type'		=> 'tabs',
				'style'		=> 'style1',
				'group'		=> array(
					array(
						'type' => 'tab',
						'title' => __('Content', 'spyro-modules'),
						'group'	=> array(
							'link_package',
							'content_title',
							'package_price',
							'package_desc',
							'title',
							'content',
							'image',
							'feature_items',
							'feature_icon',
							'btn_text',
							'btn_url',
							
						)
					),
					array(
						'type' => 'tab',
						'title' => __('Style', 'spyro-modules'),
						'group'	=> array(
							'package_back_color',
						)
					),
					
				),
			)
		),
		'atts' => array(

			array(
                'att_name' => 'link_package',
                'type' => 'select',
                'label' => __('Assign Package', 'spyro-modules'),
                'options' => array(
                    'package_1' => 'Package 1',
                    'package_2' => 'Package 2',
                    'package_3' => 'Package 3',
                    'package_4' => 'Package 4',
                    
                ),
                'default' => 'package_1',
                'tooltip' => '',
			),
			array(
				'att_name' => 'content_title',
				'type' => 'text',
				'label' => __('Content Title', 'spyro-modules'),
				'default' => 'Small Wedding Package',
				'tooltip' => ''
			),
			
			array(
				'att_name' => 'package_desc',
				'type' => 'text',
				'label' => __('Package Description', 'spyro-modules'),
				'default' => 'Basic Package for 50 guests',
				'is_inline' => false,
				'tooltip' => ''
			),

			array(
				'att_name' => 'package_price',
				'type' => 'text',
				'label' => __('Package Price', 'spyro-modules'),
				'default' => '$2,400.00 + Venue Hire*',
				'tooltip' => ''
			),
			
			
			array(
				'att_name' => 'content',
				'type' => 'tinymce',
				'label' => __('Content', 'spyro-modules'),
				'default' => '',
				'tooltip' => ''
			),
			array(
				'att_name' => 'image',
				'type' => 'single_image_picker',
				'label' => __('Image', 'spyro-modules'),
				'tooltip' => '',
				'default' => TATSU_PLUGIN_URL . '/img/image-placeholder.jpg'
			),
			array(
				'att_name' => 'package_back_color',
				'type' => 'color',
				'label' => __('Background Color', 'spyro-modules'),
				'default' => '',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.spyro-package .package-container .tatsu-{UUID}.package-block' => array(
						'property' => 'background',
					),
				),
			),

			array(
				'att_name' => 'feature_title',
				'type' => 'text',
				'label' => __('Feature Title', 'spyro-modules'),
				'default' => 'Package Includes:',
				'tooltip' => ''
			),

			array(
				'att_name' => 'feature_items',
				'type' => 'text_area',
				'label' => __('Features', 'spyro-modules'),
				'default' => "Exclusive Hire of the Venue from 9am until finish\nTea and Coffee Station after the Wedding Breakfast\nJugs of Iced Water on Tables\nJugs of Squash available at the bar (before 19.00)\nUse of music system for background music\nLime Washed Chiavari Chairs – Plain",
				
				'options' => array(
					'placeholder' => "Exclusive Hire of the Venue from 9am until finish\nTea and Coffee Station after the Wedding Breakfast\nJugs of Iced Water on Tables\nJugs of Squash available at the bar (before 19.00)\nUse of music system for background music\nLime Washed Chiavari Chairs – Plain",
				),
				'tooltip' => 'Seprate your feature list by press Enter after every feature end.',
				
			),
			array(
				'att_name' => 'feature_icon',
				'type' => 'icon_picker',
				'label' => __('Feature Icon', 'spyro-modules'),
				'default' => '',
				'tooltip' => ''
			),

			array(
				'att_name' => 'btn_text',
				'type' => 'text',
				'label' => __('Button Text', 'spyro-modules'),
				'default' => 'Enquire',
				'tooltip' => ''
			),
			array(
				'att_name' => 'btn_url',
				'type' => 'text',
				'is_inline' => false,
				'options' => array(
					'placeholder' => 'https://example.com',
				),
				'label' => __('Link URL', 'spyro-modules'),
				'default' => 'https://example.com',
				
			),
			
		),
		'presets' => array(
			'default' => array(
				
				'image' => '',
				'content_title' => '',
				'feature_icon' => '',
				'preset' => array(
					'content_title' => 'Small Wedding Package',
					
					'feature_icon' => 'tatsu-icon-check',
					'content' => 'Spyro WordPress theme is insanely flexible and amazingly easy to use. This alone would be enough for a 5 star rating. On top of a great tool is even better customer support.'
				),
			)
		),
	);
	tatsu_remap_modules(array('spyro_package', 'tab'), $controls, 'spyro_package');
}



?>