<?php
/**************************************
			Price Switch
**************************************/
if (!function_exists('spyro_image_before_after')) {
	function spyro_image_before_after( $atts, $content, $tag ) {
        $atts = shortcode_atts( array (
        	 'before_image' => '',
        	 'after_image' => '',
        	 'drag_color' => '',
			'seprate_line_color' => '',
			'right_arrow_color' => '',
			
        	'key' => be_uniqid_base36(true),
        ),$atts, $tag );
        
		extract( $atts );
		
		
		
        $content=do_shortcode( $content );
		$custom_style_tag = be_generate_css_from_atts( $atts, 'spyro_image_before_after', $key );
		
		$custom_class_name = 'tatsu-'.$atts['key'];
		$data_animations = be_get_animation_data_atts( $atts );

		$css_id = be_get_id_from_atts( $atts );
		$visibility_classes = be_get_visibility_classes_from_atts( $atts ); 
		
		$animate = ( isset( $animate ) && 1 == $animate  && 'none' != $animation_type ) ? ' tatsu-animate ' : '';
		$html = '';
		ob_start();
		remove_filter('the_content', 'wpautop');
		remove_filter('the_content', 'wptexturize');
		?>
		<div class="spyro-image-before-after-wrapper <?php echo $custom_class_name; ?>"  <?php echo $css_id; ?> > 
			  <div class="spyro-image-before-after cocoen image-comparison">
                    <img src="<?php echo esc_url($atts['before_image']) ?>" alt="Car Before Image">
                    <img src="<?php echo esc_url($atts['after_image']) ?>" alt="Car After Image">
                </div>
         </div>    
		<?php 
		echo $custom_style_tag;
		return ob_get_clean();
	}
}
add_action('tatsu_register_modules', 'spyro_register_image_before_after');
function spyro_register_image_before_after()
{
	$controls = array(
		'icon' => TATSU_PLUGIN_URL . '/builder/svg/modules.svg#image',
		'title' => __('Spyro Before After Effect', 'spyro-modules'),
		'is_js_dependant' => true,
		'child_module' => '',
		'type' => 'single',
		'is_built_in' => false,
		'category' => 'animation',
		'group_atts' => array(
			array(
				'type'		=> 'tabs',
				'style'		=> 'style1',
				'group'		=> array(
					array (
						'type'  => 'tab',
						'title' => __( 'Content', 'spyro-modules' ),
						'group' => array (
							'before_image',
							'after_image',
						)
					),

					array (
						'type'  => 'tab',
						'title' => __( 'Style', 'spyro-modules' ),
						'group' => array (
							'drag_color',
							'seprate_line_color',
							'right_arrow_color',
							
						)
					),

					
					
					array(
						'type' => 'tab',
						'title' => __('Advanced', 'spyro-modules'),
						'group'	=> array(
							
						)
					)
				)
			)
		),
		'atts' => array_values(array_filter(array(
		

			array(
				'att_name' => 'before_image',
				'type' => 'single_image_picker',
				'label' => __('Before Image', 'spyro-modules'),
				'tooltip' => '',
				'default' => TATSU_PLUGIN_URL . '/img/image-placeholder.jpg'
			),

			array(
				'att_name' => 'after_image',
				'type' => 'single_image_picker',
				'label' => __('After Image', 'spyro-modules'),
				'tooltip' => '',
				'default' => TATSU_PLUGIN_URL . '/img/image-placeholder.jpg'
			),

			array(
				'att_name' => 'drag_color',
				'type' => 'color',
				'label' => __('Circle', 'spyro-modules'),
				'default' => '',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID} .spyro-image-before-after .cocoen-drag' => array(
						'property' => 'background',
					),
				),
			),

			array(
				'att_name' => 'seprate_line_color',
				'type' => 'color',
				'label' => __('Line', 'spyro-modules'),
				'default' => '',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID} .spyro-image-before-after > div::after' => array(
						'property' => 'background',
					),
				),
			),	

			array(
				'att_name' => 'right_arrow_color',
				'type' => 'color',
				'label' => __('Arrows', 'spyro-modules'),
				'default' => '',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID} .spyro-image-before-after .cocoen-drag:after' => array(
						'property' => 'border-left-color',
					),
					'.tatsu-{UUID} .spyro-image-before-after .cocoen-drag:before' => array(
						'property' => 'border-right-color',
					),
				),
			),	

			// array(
			// 	'att_name' => 'left_arrow_color',
			// 	'type' => 'color',
			// 	'label' => __('Left Arrow Color', 'spyro-modules'),
			// 	'default' => '',
			// 	'tooltip' => '',
			// 	'css' => true,
			// 	'selectors' => array(
			// 		'.tatsu-{UUID} .spyro-image-before-after .cocoen-drag:before' => array(
			// 			'property' => 'border-right-color',
			// 		),
			// 	),
			// ),	
			//
		))),
		'presets' => array(
			'default' => array(
				'title' => '',
				'image' => '',
				
				'preset' => array(
					'style'		=> 'style2',
					'title_color' => '',
					'active_title_color' => array('id' => 'palette:0', 'color' => tatsu_get_color('tatsu_accent_color')) ,
					'switch_color' => array('id' => 'palette:0', 'color' => tatsu_get_color('tatsu_accent_color')),
					
				),
			)
		),


	);
	tatsu_remap_modules(array('spyro_image_before_after', 'labels'), $controls, 'spyro_image_before_after');
}



