<?php
/**************************************
			Forms
**************************************/
if (!function_exists('spyro_form')) {
	function spyro_form( $atts, $content, $tag ) {
        $atts = shortcode_atts( array (
			'animate' => '1',
			'form_type' => '',
			'input_typography' => '',
			'label_typography' => '',
			'accent_color' => '',
			'label_color' => '',
			'input_color' => '',
			'active_input_color' => '',
			'placeholder_color' => '',
			'input_icon_color' => '',
			'isd_code_txt_icon' => '',
			'input_border_color' => '',
			'input_background_color' => '',
			'input_border_focus_color' => '',
			'btn_text' => '',
			'api_key' => '',
			'list_id' => '',
			'double_optin' => '',
			'is_recaptcha' => '0',
			'failure_text' => '',
			'success_text' => '',
			'already_in_list' => '',
			'action_after_submit' => '',
			'to_email_options' => '',
			'to_email' => '',
			'cc_email' => '',
			'bcc_email' => '',
			'from_name' => '',
			'from_email' => '',
			'subject_of_email' => '',
			'reply_to_name' => '',
			'reply_to_email' => '',
			'message_body' => '',
			'autoresponder' => '0',
			'ares_to_email' => '',
			'ares_from_name' => '',
			'ares_from_email' => '',
			'ares_subject_of_email' => '',
			'ares_reply_to_name' => '',
			'ares_reply_to_email' => '',
			'ares_message_body' => '',
			'bg_color' => '',
			'color' => '',
			'hover_bg_color' => '',
			'hover_color' => '',
			'alignment' => '',
			'type' => '',
			'button_style'=>'',
        	'key' => be_uniqid_base36(true),
        ),$atts, $tag );
        
        extract( $atts );
        
        
		$GLOBALS['fld_cnt'] = 0;
		$tabs_cnt=0;
        $GLOBALS['fields'] = array();
		$rand = rand();
        $content=do_shortcode( $content );
        $custom_style_tag = be_generate_css_from_atts( $atts, 'spyro_form', $key );
		$custom_class_name = 'tatsu-'.$atts['key'];
		$data_animations = be_get_animation_data_atts( $atts );
		
		$css_id = be_get_id_from_atts( $atts );
		$visibility_classes = be_get_visibility_classes_from_atts( $atts ); 
		
		$animate = ( isset( $animate ) && 1 == $animate  && 'none' != $animation_type ) ? ' tatsu-animate ' : '';
		ob_start();

		$alignment = ( "block" === $type ) ? 'center' : $alignment;
		if( isset( $alignment ) ){
			if( $alignment != 'none' ){
				$alignment = 'align-block block-'.$alignment;
			} else {
				$alignment = '';
			}
		}

		$button_style = ( isset( $button_style ) && !empty( $button_style ) ) ? $button_style : '';

		remove_filter('the_content', 'wpautop');
		remove_filter('the_content', 'wptexturize');
		?>
		<form method="post" class="spyro-form <?php echo $atts['form_type'].' '.$custom_class_name; ?>" data-action="<?php echo $atts['action_after_submit']; ?>">
			<div style="display:none;">
			<input type="hidden" name="api_key" value="<?php echo $api_key; ?>">
			<input type="hidden" name="list_id" value="<?php echo $list_id; ?>">
			<input type="hidden" name="double_optin" value="<?php echo $double_optin; ?>">
			<input type="hidden" name="is_recaptcha" value="<?php echo $is_recaptcha; ?>">
 			<input type="hidden" name="success_text" value="<?php echo esc_html($success_text); ?>">
 			<input type="hidden" name="failure_text" value="<?php echo esc_html($failure_text); ?>">
 			<input type="hidden" name="already_in_list" value="<?php echo esc_html($already_in_list); ?>">
			 <input type="hidden" name="to_email_options" value="<?php echo esc_html($to_email_options); ?>">
 			<input type="hidden" name="to_email" value="<?php echo esc_html($to_email); ?>">
			 <textarea style="display:none" name="formconfig"><?php echo json_encode($atts,JSON_UNESCAPED_SLASHES); ?></textarea>
 			</div>
			<div class="form-fields-container">
				<?php
				if( is_array( $GLOBALS['fields'] ) ) {
					foreach( $GLOBALS['fields'] as $field ) { 
						
						//print_r($field['width']);
						spyro_build_form_filed( $atts , $field ); 
						
						echo $field['custom_style_tag'];
					}
				}
				if($type == 'block')
				{
					$align = 'align-block';
				}
				else
				{
					$align = '';
				}

				//Add recaptcha
				if(!empty($is_recaptcha)){
					$tatsu_recaptcha_settings=get_option('tatsu_form_recaptcha_settings');
					echo '<div class="form-item-wrap">
						<div class="form-item">';
					if(empty($tatsu_recaptcha_settings) || empty($tatsu_recaptcha_settings['recaptcha_type']) || empty($tatsu_recaptcha_settings['site_key']) || empty($tatsu_recaptcha_settings['secret_key'])){
						echo '<p style="color:red">reCAPTCHA settings are missing. Please visit <strong>admin dashboard>Tatsu>Form settings</strong> and add reCAPTCHA details.</p>';
					}else{
						if($tatsu_recaptcha_settings['recaptcha_type']=='v2'){
						echo '<div class="g-recaptcha" data-sitekey="'.$tatsu_recaptcha_settings['site_key'].'" ></div>';
						}
					}
					echo '</div></div>';
				}
				?>
				<div class="form-item-wrap">
               <div class="form-item">
                  
                  <div class="form-field-wrap">
                     <div class="form-field">
                        <div class="tatsu-module tatsu-normal-button tatsu-button-wrap <?php echo $align . ' ' . $alignment; ?>">
	             			<input type="submit"  class="tatsu-shortcode <?php echo $type.'btn'; ?> tatsu-button left-icon  <?php echo $button_style; ?>"  style="" aria-label="<?php echo esc_html($atts['btn_text']); ?>"  value="<?php echo esc_html($atts['btn_text']); ?>">
             			</div>
                     </div>
                  </div>
               </div>
            </div>
			</div>

			
			
			
		</form>
		<?php 
		echo $custom_style_tag;
		return ob_get_clean();
	}
}
if (!function_exists('spyro_form_field')) {
	function spyro_form_field( $atts, $content ){
		$atts = shortcode_atts( array(
	        'label' => '',
	        'field_type' => 'short_text',
	        'map_field' => '',
	        'is_optional' => true,
	        'is_country_code' => true,
	        'width' => '',
	        'space_on_bottom' => '',
	        'space_on_right' => '',
	        'pattern' => '',
	        'name' => 'name',
	        'long_text_height' => '',
	        'min_number' => '',
	        'max_number' => '',
	        'placeholder' => '',
	        'options' => '',
	        'checkbox_design' => '',
	        'radio_design' => '',
	        'exclude_country' => '',
	        'input_icon' => '',
			'key' => be_uniqid_base36(true),
		),$atts );
		
		$custom_style_tag = be_generate_css_from_atts( $atts, 'spyro_form_field', $atts['key'] );
		$custom_class_name = 'tatsu-'.$atts['key'];
		extract( $atts );
		
		
		$content= do_shortcode($content);
		$x = $GLOBALS['fld_cnt'];
		$GLOBALS['fields'][$x] = array( 
									'label' => $label , 
									'field_type' => $field_type,
									'map_field' => $map_field,
									'is_optional' => $is_optional,
									'is_country_code' => $is_country_code,
									'width' => $width,
									'pattern' => $pattern,
									'pattern' => $pattern,
									'placeholder' => $placeholder,
									'checkbox_design' => $checkbox_design,
									'radio_design' => $radio_design,
									'long_text_height' => $long_text_height,
									'custom_class_name' => $custom_class_name,
									'custom_style_tag' => $custom_style_tag,
									'options' => $options,
									'exclude_country' => $exclude_country,
									'min_number' => $min_number,
									'max_number' => $max_number,
									'input_icon' => $input_icon,
									
									
									'name' => $name,
									);
		$GLOBALS['fld_cnt']++;
	}
}
add_action('tatsu_register_modules', 'spyro_register_form');
function spyro_register_form()
{
	$controls = array(
		'icon' => TATSU_PLUGIN_URL . '/builder/svg/modules.svg#tabs',
		'title' => __('Spyro Form', 'spyro-modules'),
		'is_js_dependant' => true,
		'child_module' => 'spyro_form_field',
		'type' => 'multi',
		'initial_children' => 3,
		'is_built_in' => false,
		'category' => 'forms',
		'group_atts' => array(
			array(
				'type'		=> 'tabs',
				'style'		=> 'style1',
				'group'		=> array(
					array(
						'type' => 'tab',
						 
						  'title' => __('Content', 'spyro-modules'),
						   'group'	=> array(
							'action_after_submit',
							'to_email_options',
							'to_email',
							'cc_email',
							'bcc_email',
							'from_name',
							'from_email',
							'subject_of_email',
							'reply_to_name',
							'reply_to_email',
							'message_body',
							'autoresponder',
							'ares_to_email',
							'ares_from_name',
							'ares_from_email',
							'ares_subject_of_email',
							'ares_reply_to_name',
							'ares_reply_to_email',
							'ares_message_body',
							'api_key',
							'list_id',
							'double_optin',
							'is_recaptcha',
							'success_text',
							'failure_text',
							'already_in_list',
						)
					),
					array(
						'type' => 'tab',
						'title' => __('Style', 'spyro-modules'),
						'group'	=> array(
							'style',
							
							
							array(
								'type' => 'accordion',
								'active' => array(0),
								'group' => array(
								array(
									'type' => 'panel',
									'title' => __('Type', 'spyro-modules'),
									'group' => array(
										
										'form_type',
									)
								),
								array(
									'type' => 'panel',
									'title' => __('Colors', 'spyro-modules'),
									'group' => array(
										'accent_color',
										'label_color',
										'placeholder_color',
										'input_color',
										'active_input_color',
										'input_background_color',
										'input_border_focus_color',
										'input_icon_color',
										'input_border_color',
										'isd_code_txt_icon',
									)
								),
								array(
									'type' => 'panel',
									'title' => __('Typography', 'spyro-modules'),
									'group' => array(
										
										'label_typography',
										'input_typography'
									)
								),
								array(
									'type' => 'panel',
									'title' => __('Button', 'spyro-modules'),
									'group' => array(
												'btn_text',
												'type',
												'button_style',
												'alignment',
												array(
											'type'  	=> 'tabs',
											'style'		=> 'style1',
											'group'		=> array(
												array(
													'type'		=> 'tab',
													'title'		=> esc_html__('Normal Color', 'spyro-modules'),
													'group'		=> array(
														'bg_color',
														'color',
													),
												),
												array(
													'type'		=> 'tab',
													'title'		=> esc_html__('Hover Color', 'spyro-modules'),
													'group'		=> array(
														'hover_bg_color',
														'hover_color',
													),
												),
											),
										),
									)
								),
								
								),
							),
						),
					),
					
					array(
						'type' => 'tab',
						'title' => __('Advanced', 'spyro-modules'),
						'group'	=> array(
							array(
								'type' => 'accordion',
								'active' => array(0),
								'group' => array(
									
								)
							)
						)
					)
				)
			)
		),
		'atts' => array_values(array_filter(array(
			 array (
                'att_name' => 'action_after_submit',
                'type' => 'button_group',
                'label' => __( 'Action After Submit', 'spyro-modules' ),
                'options' => array (
                    'email' => 'Email',
                    'mailchimp' => 'Mailchimp',	        			
                   
                ),
                'default' => 'mailchimp',
				'tooltip' => '',
				'is_inline' => false,
			),
			array(
				'att_name' => 'api_key',
				'type' => 'text',
				'label' => __('Mailchimp Api Key', 'spyro-modules'),
				'default' => '',
				'tooltip' => '',
				'visible' => array('action_after_submit', '==', 'mailchimp'),
				
			),
			array(
				'att_name' => 'list_id',
				'type' => 'text',
				'label' => __('Mailchimp List Id', 'spyro-modules'),
				'default' => '',
				'tooltip' => '',
				'visible' => array('action_after_submit', '==', 'mailchimp'),
				
			),
			array(
				'att_name' => 'double_optin',
				'type' => 'switch',
				'label' => __('Double Optin?', 'spyro-modules'),
				'default' => 0,
				'tooltip' => '',
				'visible' => array('action_after_submit', '==', 'mailchimp'),
			),
			array(
				'att_name' => 'is_recaptcha',
				'type' => 'switch',
				'label' => __('enable recaptcha?', 'spyro-modules'),
				'default' => 0,
				'tooltip' => ''
			),
			array (
                'att_name' => 'to_email_options',
                'type' => 'button_group',
                'label' => __( 'Prefered Email Address', 'spyro-modules' ),
                'options' => array (
                    'admin_email' => 'Admin Email',
                    'other' => 'Other',	        			
                   
                ),
                'default' => 'admin_email',
				'tooltip' => '',
				'is_inline' => false,
				'visible' => array('action_after_submit', '==', 'email'),
			),
			array(
				'att_name' => 'to_email',
				'type' => 'text',
				'label' => __('Receiver Email', 'spyro-modules'),
				'default' => '',
				'tooltip' => 'Email notification receiver email.',
				'visible' => array('to_email_options', '==', 'other'),
				
			),
			array(
				'att_name' => 'cc_email',
				'type' => 'text',
				'label' => __('Cc Email', 'spyro-modules'),
				'default' => '',
				'tooltip' => 'Email notification  cc  receiver email. Separate multiple emails with comma.',
				'visible' => array('action_after_submit', '==', 'email'),	
			),
			array(
				'att_name' => 'bcc_email',
				'type' => 'text',
				'label' => __('Bcc Email', 'spyro-modules'),
				'default' => '',
				'tooltip' => 'Email notification bcc receiver email. Separate multiple emails with comma.',
				'visible' => array('action_after_submit', '==', 'email'),
			),
			array(
				'att_name' => 'from_name',
				'type' => 'text',
				'label' => __('From Name', 'spyro-modules'),
				'default' => '',
				'tooltip' => 'Enter from name for email notification.',
				'visible' => array('to_email_options', '==', 'other'),
			),
			array(
				'att_name' => 'from_email',
				'type' => 'text',
				'label' => __('From email', 'spyro-modules'),
				'default' => '',
				'tooltip' => 'Enter from email for email notification',
				'visible' => array('to_email_options', '==', 'other'),
			),
			array(
				'att_name' => 'subject_of_email',
				'type' => 'text',
				'label' => __('Email Subject', 'spyro-modules'),
				'default' => 'Form received - '.get_bloginfo('name'),
				'tooltip' => 'Enter subject of email notification.',
				'visible' => array('action_after_submit', '==', 'email'),
			),
			array(
				'att_name' => 'reply_to_name',
				'type' => 'text',
				'label' => __('Reply to name', 'spyro-modules'),
				'default' => '',
				'tooltip' => 'Enter form field name in which you will get visitor name e.g. full_name.',
				'visible' => array('action_after_submit', '==', 'email'),
			),
			array(
				'att_name' => 'reply_to_email',
				'type' => 'text',
				'label' => __('Reply to email', 'spyro-modules'),
				'default' => '',
				'tooltip' => 'Enter form email field name.',
				'visible' => array('action_after_submit', '==', 'email'),
			),
			array(
				'att_name' => 'message_body',
				'type' => 'text_area',
				'label' => __('Email message', 'spyro-modules'),
				'default' => '{all_fields}',
				'tooltip' => 'Use tags {all_fields}, {site_title}. For form field tags, add prefix "field_name_" before field name e.g. {field_name_first_name}. Use single quotes instead of double.',
				'visible' => array('action_after_submit', '==', 'email'),
			),
			array(
				'att_name' => 'autoresponder',
				'type' => 'switch',
				'label' => __('Autoresponder email?', 'spyro-modules'),
				'default' => 0,
				'tooltip' => 'Send email notification to visitor on submit form.',
				'visible' => array('action_after_submit', '==', 'email'),
			),
			array(
				'att_name' => 'ares_to_email',
				'type' => 'text',
				'label' => __('Receiver Email', 'spyro-modules'),
				'default' => '',
				'tooltip' => 'Enter form email field name.',
				'visible' => array('autoresponder', '==', '1'),
				
			),
			array(
				'att_name' => 'ares_from_name',
				'type' => 'text',
				'label' => __('From Name', 'spyro-modules'),
				'default' => '',
				'tooltip' => 'Enter from name for email notification. Default value: site name.',
				'visible' => array('autoresponder', '==', '1'),
			),
			array(
				'att_name' => 'ares_from_email',
				'type' => 'text',
				'label' => __('From email', 'spyro-modules'),
				'default' => '',
				'tooltip' => 'Enter from email for email notification. Default value: admin email.',
				'visible' => array('autoresponder', '==', '1'),
			),
			array(
				'att_name' => 'ares_subject_of_email',
				'type' => 'text',
				'label' => __('Email Subject', 'spyro-modules'),
				'default' => 'Form received successfully',
				'tooltip' => 'Enter subject of email notification.',
				'visible' => array('autoresponder', '==', '1'),
			),
			array(
				'att_name' => 'ares_reply_to_name',
				'type' => 'text',
				'label' => __('Reply to name', 'spyro-modules'),
				'default' => '',
				'tooltip' => 'Enter name for admin. Default value: site title.',
				'visible' => array('autoresponder', '==', '1'),
			),
			array(
				'att_name' => 'ares_reply_to_email',
				'type' => 'text',
				'label' => __('Reply to email', 'spyro-modules'),
				'default' => '',
				'tooltip' => 'Enter email for admin. Default value: admin email.',
				'visible' => array('autoresponder', '==', '1'),
			),
			array(
				'att_name' => 'ares_message_body',
				'type' => 'text_area',
				'label' => __('Email message', 'spyro-modules'),
				'default' => 'Thanks for submit a form with us.',
				'tooltip' => 'Use tags {all_fields}, {site_title}. For form field tags, add prefix "field_name_" before field name e.g. {field_name_first_name}. Use single quotes instead of double.',
				'visible' => array('autoresponder', '==', '1'),
			),
			array(
	            'att_name' => 'success_text',
	            'type' => 'text',
	            'label' => __( 'Message After Success', 'spyro-modules' ),
	            'default' => __('Thank you, you have been added to our mailing list.','spyro-modules'),
	            'tooltip' => '',
            ),

            array(
	            'att_name' => 'failure_text',
	            'type' => 'text',
	            'label' => __( 'Message After Failure', 'spyro-modules' ),
	            'default' => __('There has been some error. Please try again','spyro-modules'),
	            'tooltip' => '',
            ),

            array(
	            'att_name' => 'already_in_list',
	            'type' => 'text',
	            'label' => __( 'Message If Already In List', 'spyro-modules' ),
	            'default' => __('is already a list member','spyro-modules'),
	            'tooltip' => '',
            ),

			array(
				'att_name' => 'form_type',
				'type' => 'select',
				'is_inline' => true,
				'label' => __('Form Type', 'spyro-modules'),
				'options' => array(
					'basic' 	=> 'Basic',
					'modern' 	=> 'Modern',
				),
				'default' => 'basic',
				'tooltip' => ''
			),
		
			
			array(
				'att_name' => 'label_typography',
				'type' => 'typography',
				'label' => __( 'Label Text', 'spyro-modules' ),
				'responsive' => true,
				'default' => '',
				'tooltip' => '',
				'css' => true,
				'is_inline' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-form .form-item-wrap .form-label' => array(
						'property' => 'typography',
					)
				),
			),	
			array(
				'att_name' => 'input_typography',
				'type' => 'typography',
				'label' => __( 'Input Text', 'spyro-modules' ),
				'responsive' => true,
				'default' => '',
				'tooltip' => '',
				'css' => true,
				'is_inline' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-form .form-item-wrap .form-field .form-element,
					.tatsu-{UUID}.spyro-form .form-item-wrap.form-radio .form-field .form-radio-text,
					.tatsu-{UUID}.spyro-form .form-item-wrap.form-radio .form-field.form-radio-button > label .form-radio-button-text,
					.tatsu-{UUID}.spyro-form .form-item-wrap.form-checkbox .form-field .form-checkbox-text,
					.tatsu-{UUID}.spyro-form .form-item-wrap.form-checkbox .form-field.form-checkbox-button-style label .form-checkbox-text
					
					' => array(
						'property' => 'typography',
					)
				),
			),	

			array(
				'att_name' => 'accent_color',
				'type' => 'color',
				'label' => __('Accent', 'spyro-modules'),
				'default' => '#2293d7',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-form .form-item-wrap.form-radio .form-field.form-radio-default .form-radio-dot-wrap .form-radio-dot,
					.tatsu-{UUID}.spyro-form .form-item-wrap.form-radio .form-field.form-radio-button > label.is-checked,
					.tatsu-{UUID}.spyro-form .form-item-wrap.form-checkbox .form-field.form-checkbox-button-style > label.is-checked' => array(
						'property' => 'background',
					),

					'.tatsu-{UUID}.spyro-form .form-item-wrap.form-checkbox .form-field.form-checkbox-default .form-checkbox-tick-wrap .form-checkbox-tick path' => array(
						'property' => 'stroke',
					),

					'.tatsu-{UUID}.spyro-form .form-item-wrap.form-number .custom-number-arrows .arrow-up:hover' => array(
						'property' => 'background',
					),
					'.tatsu-{UUID}.spyro-form .form-item-wrap.form-number .custom-number-arrows .arrow-down:hover' => array(
						'property' => 'background',
					),
					'.tatsu-{UUID}.spyro-form .form-item-wrap.form-checkbox .form-field.form-checkbox-button-style > label.is-checked' => array(
						'property' => 'border-color',
					),
					'.tatsu-{UUID}.spyro-form .form-item-wrap.form-radio .form-field.form-radio-button > label.is-checked' => array(
						'property' => 'border-color',
					),
					'.tatsu-{UUID}.spyro-form .form-footer .form-btn-wrap .tatsu-button' => array(
						'property' => 'background',
					),
				),
				
				
			),
			array(
				'att_name' => 'label_color',
				'type' => 'color',
				'label' => __('Label Text', 'spyro-modules'),
				'default' => '#343638',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-form .form-item-wrap .form-label' => array(
						'property' => 'color',
					),
				),
				
			),
			array(
				'att_name' => 'input_border_color',
				'type' => 'color',
				'label' => __('Input Border', 'spyro-modules'),
				'default' => '#77797D',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-form .form-item-wrap .form-field .form-element,
					.tatsu-{UUID}.spyro-form .form-item-wrap.form-radio .form-field.form-radio-default .form-radio-dot-wrap .form-radio-dot,
					.tatsu-{UUID}.spyro-form .form-item-wrap.form-radio .form-field.form-radio-default .form-radio-dot-wrap .form-radio-element,
					.tatsu-{UUID}.spyro-form .form-item-wrap.form-checkbox .form-field.form-checkbox-default .form-checkbox-tick-wrap .form-checkbox-element,
					.tatsu-{UUID}.spyro-form .form-item-wrap .form-field.form-radio-button > label,
					.tatsu-{UUID}.spyro-form .form-item-wrap .form-field.form-checkbox-button-style > label
					' 
					=> array(
						'property' => 'border-color',
					),
				),
				
			),
			array(
				'att_name' => 'input_background_color',
				'type' => 'color',
				'label' => __('Field Background', 'spyro-modules'),
				'default' => '',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-form .form-item-wrap .form-field .form-element' => array(
						'property' => 'background',
					),
				),
				
			),

			
			array(
				'att_name' => 'input_border_focus_color',
				'type' => 'color',
				'label' => __('Field Border Focus', 'spyro-modules'),
				'default' => '#2293d7',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-form .form-item-wrap .form-field .form-element:focus' => array(
						'property' => 'border-color',
					),
					
				),
				
				
			),
			
			array(
				'att_name' => 'input_color',
				'type' => 'color',
				'label' => __('Input Text', 'spyro-modules'),
				'default' => '#77797D',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-form .form-item-wrap .form-field .form-element , .tatsu-{UUID}.spyro-form .form-item-wrap.form-select .form-field .form-select-element option,.tatsu-{UUID}.spyro-form .form-item-wrap.form-phone .form-field .form-select-element-wrap .form-select-arrow i,
						.tatsu-{UUID}.spyro-form .form-item-wrap .form-field .form-radio-text,
						.tatsu-{UUID}.spyro-form .form-item-wrap .form-field.form-radio-button > label .form-radio-button-text,
						.tatsu-{UUID}.spyro-form .form-item-wrap .form-field .form-checkbox-text,
						.tatsu-{UUID}.spyro-form .form-item-wrap .form-field.form-checkbox-button-style > label .form-checkbox-text
						
						' => array(
						'property' => 'color',
					),
				),
				
				
			),
				array(
				'att_name' => 'active_input_color',
				'type' => 'color',
				'label' => __('Active Input Text', 'spyro-modules'),
				'default' => '#fff',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-form .form-item-wrap.form-radio .form-field.form-radio-button > label.is-checked .form-radio-button-text,.spyro-form .form-item-wrap.form-checkbox .form-field.form-checkbox-button-style > label.is-checked .form-checkbox-text
						' => array(
						'property' => 'color',
					),
				),
				
				
			),
			array(
				'att_name' => 'placeholder_color',
				'type' => 'color',
				'label' => __('Placeholder', 'spyro-modules'),
				'default' => '#77797D',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-form .form-item-wrap .form-field .form-element::placeholder' => array(
						'property' => 'color',
					),
					
				),
				
			),
			array(
				'att_name' => 'input_icon_color',
				'type' => 'color',
				'label' => __('Input Icon', 'spyro-modules'),
				'default' => '#77797D',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-form .form-item-wrap.has-icon .form-icon , 
					.tatsu-{UUID}.spyro-form .form-item-wrap.form-date .form-date-element-icon i,
					.tatsu-{UUID}.spyro-form .form-item-wrap.form-select .form-field .form-select-arrow i' => array(
						'property' => 'color',
					),
				),
				
			),
			array(
				'att_name' => 'isd_code_txt_icon',
				'type' => 'color',
				'label' => __('Isd Code And Icon', 'spyro-modules'),
				'default' => '#77797D',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-form .form-item-wrap.form-phone.form-has-country .form-item .form-field .form-select-element,.tatsu-{UUID}.spyro-form .form-item-wrap.form-phone .form-item .form-field .form-select-element-wrap .form-select-arrow i' => array(
						'property' => 'color',
					),
				),
				
			),
			
			array(
	            'att_name' => 'btn_text',
	            'type' => 'text',
	            'label' => __( 'Button Text', 'spyro-modules' ),
	            'default' => 'Submit',
	            'tooltip' => '',
            ),

            array(
				'att_name' => 'type',
				'is_inline' => true,
				'type' => 'button_group',
				'label' => esc_html__('Size', 'spyro-modules'),
				'options' => array(
					'small' => 'S',
					'medium' => 'M',
					'large' => 'L',
					'x-large' => 'XL',
					'block' => 'Block',
				),
				'default' => 'large',
				'tooltip' => ''
			),
			array(
				'att_name' => 'button_style',
				'is_inline' => true,
				'type' => 'button_group',
				'label' => esc_html__('Shape', 'spyro-modules'),
				'options' => array(
					'none' => 'Rectangular',
					'rounded' => 'Rounded',
					'circular' => 'Pill'
				),
				'default' => 'rounded',
				'tooltip' => ''
			),
				array(
				'att_name' => 'bg_color',
				'type' => 'color',
				'label' => esc_html__('Background', 'spyro-modules'),
				'default' => '#2293d7',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-form .tatsu-button' => array(
						'property' => 'background-color'
					),
				),
			),
			array(
				'att_name' => 'hover_bg_color',
				'type' => 'color',
				'label' => esc_html__('Background', 'spyro-modules'),
				'default' => '#2293d7',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-form .tatsu-button:hover' => array(
						'property' => 'background-color'
					),
				),
			),
			array(
				'att_name' => 'color',
				'type' => 'color',
				'label' => esc_html__('Text', 'spyro-modules'),
				'default' => '#fff',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-form .tatsu-button' => array(
						'property' => 'color',
					),
				),
			),
			array(
				'att_name' => 'hover_color',
				'type' => 'color',
				'label' => esc_html__('Text', 'spyro-modules'),
				'default' => '#fff',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-form .tatsu-button:hover' => array(
						'property' => 'color',
					),
				),
			),
			array(
				'att_name' => 'alignment',
				'is_inline' => true,
				'type' => 'button_group',
				'label' => esc_html__('Align', 'tatsu'),
				'options' => array(
					'none' => 'None',
					'left' => 'Left',
					'center' => 'Center',
					'right' => 'Right'
				),
				'default' => 'none',
				'tooltip' => ''
			),

      
            
		
			
			
		))),
		'presets' => array(
			'default' => array(
				'title' => '',
				'image' => '',
				'preset' => array(
					'style'		=> 'style2',
					'title_color' => '',
					'background_color' => '',
					'active_title_color' => '',
					'active_background_color' => '',
				),
			)
		),
	);
	tatsu_remap_modules(array('spyro_form' , 'forms'), $controls, 'spyro_form');
	//tatsu_register_module( 'spyro_form', $controls );
}
add_action('tatsu_register_modules', 'spyro_register_form_field');
function spyro_register_form_field()
{
	$controls = array(
		'icon' => '',
		'title' => __('Field', 'spyro-modules'),
		'child_module' => '',
		'type' => 'sub_module',
		'is_built_in' => false,
		'hint' => 'field_type',
		'group_atts' => array(
			array(
				'type'		=> 'tabs',
				'style'		=> 'style1',
				'group'		=> array(
					array(
						'type' => 'tab',
						'title' => __('Content', 'spyro-modules'),
						'group'	=> array(
							'field_type',
							'label',
							'name',
							'checkbox_design',
							'radio_design',
							'map_field',
							'placeholder',
							'pattern',
							'options',
							'exclude_country',
							'is_optional',
							'input_icon',
							'is_country_code',
							'min_number',
							'max_number',
						)
					),
					array(
						'type' => 'tab',
						'title' => __('Style', 'spyro-modules'),
						'group'	=> array(
							'width',
							'space_on_right',
							'space_on_bottom',
							'long_text_height',
						)
					)
				),
			)
		),
		'atts' => array(
			array(
				'att_name' => 'field_type',
				'type' => 'select',
				'is_inline' => true,
				'label' => __('Field Type', 'spyro-modules'),
				'options' => array(
					'short_text' 	=> 'Short Text',
					'long_text' 	=> 'Long Text',
					'phone' 	=> 'Phone',
					'date' 	=> 'Date',
					'number' 	=> 'Number',
					'email' 	=> 'Email',
					'radio' 	=> 'Radio',
					'checkbox' 	=> 'Checkbox',
					'select' 	=> 'DropDown',
					'country' 	=> 'Country DropDown',
					
				),
				'default' => 'short_text',
				'tooltip' => ''
			),
			array(
				'att_name' => 'map_field',
				'type' => 'select',
				'is_inline' => true,
				'label' => __('Mailchimp Map Filed', 'spyro-modules'),
				'options' => array(
					'email_address' => 'Email',
					'FNAME' 	=> 'First Name',
					'LNAME' 	=> 'Last Name',
					'PHONE' 	=> 'Phone',
					'none' 	=> 'none',
				),
				'default' => 'none',
				'tooltip' => ''
			),
			array(
				'att_name' => 'label',
				'type' => 'text',
				'label' => __('Label', 'spyro-modules'),
				'default' => '',
				'tooltip' => ''
			),
			array(
				'att_name' => 'placeholder',
				'type' => 'text',
				'label' => __('Placeholder', 'spyro-modules'),
				'default' => 'placeholder',
				'tooltip' => '',
				'visible' => array(
					'condition' => array(
						array('field_type', '==', 'short_text'),
						array('field_type', '==', 'long_text'),
						array('field_type', '==', 'phone'),
						array('field_type', '==', 'date'),
						array('field_type', '==', 'email'),
						array('field_type', '==', 'number')
					),
					'relation'	=> 'or',
				),
			),
			array(
				'att_name' => 'name',
				'type' => 'text',
				'label' => __('Name', 'spyro-modules'),
				'default' => '',
				'tooltip' => 'Use only alphabets and underscore'
			),
			array(
				'att_name' => 'pattern',
				'type' => 'text',
				'label' => __('Pattern', 'spyro-modules'),
				'visible' => array(
					'condition' => array(
						array('field_type', '==', 'short_text'),
						array('field_type', '==', 'long_text'),
						array('field_type', '==', 'phone'),
						array('field_type', '==', 'date'),
						array('field_type', '==', 'number')
					),
					'relation'	=> 'or',
				),
				'default' => '',
				'tooltip' => ''
			),
			array(
				'att_name' => 'input_icon',
				'type' => 'icon_picker',
				'label' => __('Icon', 'spyro-modules'),
				'default' => '',
				'visible' => array(
					'condition' => array(
						array('field_type', '==', 'short_text'),
						array('field_type', '==', 'long_text'),
						array('field_type', '==', 'phone'),
						array('field_type', '==', 'number'),
						array('field_type', '==', 'email'),
					),
					'relation'	=> 'or',
				),
				
			),
			
			
			array(
				'att_name' => 'options',
				'type' => 'text_area',
				'label' => __('Options', 'spyro-modules'),
				'default' => "Option 1\nOption 2\nOption 3",
				'tooltip' => 'Press Enter After Each Option',
				'visible' => array(
					'condition' => array(
						array('field_type', '==', 'radio'),
						array('field_type', '==', 'checkbox'),
						array('field_type', '==', 'select')
						
					),
					'relation'	=> 'or',
				),
			),
			array(
				'att_name' => 'radio_design',
				'type' => 'select',
				'is_inline' => true,
				'label' => __('Radio Style', 'spyro-modules'),
				'options' => array(
					'normal' 	=> 'Normal',
					'button_set' 	=> 'Button Set',
				),
				'default' => 'normal',
				'tooltip' => '',
				'visible' => array('field_type', '==', 'radio'),
			),

			array(
				'att_name' => 'checkbox_design',
				'type' => 'select',
				'is_inline' => true,
				'label' => __('Checkbox Style', 'spyro-modules'),
				'options' => array(
					'normal' 	=> 'Normal',
					'button_set' 	=> 'Button Set',
				),
				'default' => 'normal',
				'tooltip' => '',
				'visible' => array('field_type', '==', 'checkbox'),
			),
			array(
				'att_name' => 'exclude_country',
				'type' => 'text_area',
				'label' => __('Exclude Country', 'spyro-modules'),
				'default' => 'Option 1,Option 2,Option 3',
				'tooltip' => '',
				'visible' => array('field_type', '==', 'country'),
			),
			array(
				'att_name' => 'is_optional',
				'type' => 'switch',
				'label' => __('Is Optional?', 'spyro-modules'),
				'default' => 0,
				'tooltip' => '',
			),
			array(
				'att_name' => 'is_country_code',
				'type' => 'switch',
				'label' => __('Use Country Code?', 'spyro-modules'),
				'default' => 1,
				'tooltip' => '',
				'visible' => array('field_type', '==', 'phone'),
			),
			

			array(
				'att_name' => 'width',
				'type' => 'number',
				'is_inline' => true,
				'responsive' => true,
				'label' => __('Width', 'spyro-modules'),
				'options' => array(
					'unit' => array( '%' ),
					'add_unit_to_value' => true,
				),
				'default' => '',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					// '.tatsu-{UUID}.form-item-wrap' => array(
					// 	'property' => 'width',
					// 	'when' => array(
							
					// 		array( 'width', '!=', '0%' ),
					// 		array( 'width', '!=', '' ),
     //                    ),
     //                    'relation' => 'AND',
					// ),
					'.tatsu-{UUID}.form-item-wrap' => array(
						'property' => 'width',
						 'when' => array(
							array( 'width', '!=', '0%' ),
							array( 'width', '!=', '' ),
							array('width', '!=', array( 'd' => '' ) ),
							array('width', '!=', array( 'l' => '' ) ),
							array('width', '!=', array( 't' => '' ) ),
							array('width', '!=', array( 'm' => '' ) ),
							
                        ),
                        'relation' => 'AND',
					),
				),
				
			),
			array(
				'att_name' => 'space_on_right',
				'type' => 'number',
				'is_inline' => true,
				'responsive' => true,
				'label' => __('Space On Right', 'spyro-modules'),
				'options' => array(
					'unit' => array('%' ,'px' ),
					'add_unit_to_value' => true,
				),
				'default' => '',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.form-item-wrap' => array(
						'property' => 'margin-right',
						 'when' => array(
                            
							array( 'space_on_right', '!=', '0px' ),
							array( 'space_on_right', '!=', '0%' ),
							
                        ),
                        'relation' => 'and',
					),
				),
				
			),
			array(
				'att_name' => 'space_on_bottom',
				'type' => 'number',
				'is_inline' => true,
				'responsive' => true,
				'css' => true,
				'label' => __('Space On Bottom', 'spyro-modules'),
				'options' => array(
					'unit' => array('%' ,'px' ),
					'add_unit_to_value' => true,
				),
				'default' => '',
				'tooltip' => '',
				'selectors' => array(
					'.tatsu-{UUID}.form-item-wrap' => array(
						'property' => 'margin-bottom',
						'when' => array(
                            
							array( 'space_on_bottom', '!=', '0px' ),
							array( 'space_on_bottom', '!=', '0%' ),
							
                        ),
                        'relation' => 'and',
						
					),
				),
				
			),
			array(
				'att_name' => 'long_text_height',
				'type' => 'number',
				'is_inline' => true,
				'label' => __('height', 'spyro-modules'),
				'options' => array(
					'unit' => '',
					'add_unit_to_value' => false,
				),
				'default' => '',
				'tooltip' => '',
				'visible' => array('field_type', '=', 'long_text'),
			),
			array(
				'att_name' => 'min_number',
				'type' => 'number',
				'is_inline' => true,
				'label' => __('Min', 'spyro-modules'),
				'options' => array(
					'unit' => '',
					'add_unit_to_value' => false,
				),
				'default' => 0,
				'tooltip' => '',
				'visible' => array('field_type', '=', 'number'),
			),
			array(
				'att_name' => 'max_number',
				'type' => 'number',
				'is_inline' => true,
				'label' => __('Max', 'spyro-modules'),
				'options' => array(
					'unit' => '',
					'add_unit_to_value' => false,
				),
				'default' => '',
				'tooltip' => '',
				'visible' => array('field_type', '=', 'number'),
			),

			
	
			
		

			
			
		),
		'presets' => array(
			'default' => array(
				'title' => '',
				
				'preset' => array(
					'label' => 'Label',
					
				),
			)
		),
	);
	tatsu_remap_modules(array('spyro_form_field', 'field'), $controls, 'spyro_form_field');
}
?>