<?php
if(!function_exists('spyro_build_form_filed'))
{
	function spyro_build_form_filed( $atts , $field )
	{
		
		$element = '';
        
        $ele_attr = array(
                'placeholder' =>  $field['placeholder'],
                'pattern' => $field['pattern'],
                'data-map_field' => $field['map_field'],
                'name' => (empty($field['name'])) ? str_replace(" ","_", $field['label']) : trim($field['name'])
        );
        if(!$field['is_optional'] && $field['field_type'] != 'checkbox')
        {
                 $ele_attr['required'] = "required";
        }

        $wrap_args = array( 
                            'class' => array($field['custom_class_name']),
                            'is_optional' => $field['is_optional']
                        );
		switch ($field['field_type']) 
        {
            //Short  Text
			case 'short_text':
            $wrap_args['label'] = $field['label'];
            array_push($wrap_args['class'], 'form-text');
            $icon_tag = ( ! empty($field['input_icon']) && $field['input_icon'] != 'none' ) ? '<i class="form-icon '.$field['input_icon'].'"></i>' : "";

            if(!empty($icon_tag))
            {
                array_push($wrap_args['class'], 'has-icon');
            }
            
            $element .= ''.spyro_element_wrap_start($wrap_args).'
                            '.$icon_tag.'
                            <input type="text" class="form-element form-text-element" '.spyro_set_form_attribute($ele_attr).'/>
                            '.spyro_element_wrap_end().'';
            break;

            // Long Text
            case 'long_text':
            $wrap_args['label'] = $field['label'];
            array_push($wrap_args['class'], 'form-textarea');

            $icon_tag = ( ! empty($field['input_icon']) && $field['input_icon'] != 'none' ) ? '<i class="form-icon '.$field['input_icon'].'"></i>' : "";

            if(!empty($icon_tag))
            {
                array_push($wrap_args['class'], 'has-icon');
            }

            $rows = 10;
            if(!empty($field['long_text_height']))
            {
                $rows = $field['long_text_height'];
            }
            
            $element .= ''.spyro_element_wrap_start($wrap_args).'
                            '.$icon_tag.'
                             <textarea rows="'.$rows.'" class="form-element form-textarea-element" '.spyro_set_form_attribute($ele_attr).'></textarea>
                            '.spyro_element_wrap_end().'';
            break;

             //Email
            case 'email':
            $wrap_args['label'] = $field['label'];
            array_push($wrap_args['class'], 'form-text');

             if(!empty($field['placeholder']) && $field['placeholder'] == 'placeholder')
            {
              $ele_attr['placeholder'] = 'example@yoursite.xyz';     
            }
            else if(!empty($field['placeholder']))
            {
              $ele_attr['placeholder'] = $field['placeholder'];    
            }

             
            

            $icon_tag = ( ! empty($field['input_icon']) && $field['input_icon'] != 'none' ) ? '<i class="form-icon '.$field['input_icon'].'"></i>' : "";

            if(!empty($icon_tag))
            {
                array_push($wrap_args['class'], 'has-icon');
            }
            
            $element .= ''.spyro_element_wrap_start($wrap_args).'
                            '.$icon_tag.'
                            <input type="email" class="form-element form-text-element" '.spyro_set_form_attribute($ele_attr).'/>
                            '.spyro_element_wrap_end().'';
            break;

            //Email
            case 'date':
            $wrap_args['label'] = $field['label'];
            array_push($wrap_args['class'], 'form-date');
            $icon_tag = ( ! empty($field['input_icon']) && $field['input_icon'] != 'none' ) ? '<i class="form-icon '.$field['input_icon'].'"></i>' : "";

            if(!empty($icon_tag))
            {
                array_push($wrap_args['class'], '');
            }
            
            $element .= ''.spyro_element_wrap_start($wrap_args).'
                             <input type="date" class="form-element form-date-element"  '.spyro_set_form_attribute($ele_attr).'>
                            <span class="form-date-element-icon"><i class="tatsu-icon tatsu-icon-calendar2"></i></span>
                            '.spyro_element_wrap_end().'';
            break;

             //Phone
            case 'phone':
            $wrap_args['label'] = $field['label'];
            array_push($wrap_args['class'], 'form-phone');
            $icon_tag = ( ! empty($field['input_icon']) && $field['input_icon'] != 'none' ) ? '<i class="form-icon '.$field['input_icon'].'"></i>' : "";

            if(!empty($icon_tag))
            {
                array_push($wrap_args['class'], 'has-icon');
            }
            
            

            if($field['is_country_code'])
            {
                $countries =  spyro_get_country_codes();
                array_push($wrap_args['class'], 'form-has-country');
            }
            else
            {
                $countries = '';
            }
                           
             $element.= '<div class="form-item-wrap '.implode(' ' , $wrap_args['class']).'">
                           <div class="form-item">
                              <div class="form-label">'.$field['label'].spyro_check_optional($field['is_optional']).'</div>
                              <div class="form-field-wrap">
                                 <div class="form-field">
                                    '.$countries.'
                                    '.$icon_tag.'
                                    <input type="tel" class="form-element form-phone-text-element" '.spyro_set_form_attribute($ele_attr).'/>
                                 </div>
                              </div>
                           </div>
                        </div>';
            break;

            //Number
            case 'number':
            $wrap_args['label'] = $field['label'];
            array_push($wrap_args['class'], 'form-number');
            $icon_tag = ( ! empty($field['input_icon']) && $field['input_icon'] != 'none' ) ? '<i class="form-icon '.$field['input_icon'].'"></i>' : "";

            if(!empty($icon_tag))
            {
                array_push($wrap_args['class'], 'has-icon');
            }
            $ele_attr['min'] = $field['min_number'];
            $ele_attr['max'] = $field['max_number'];
            if(!empty($field['min_number']))
            {
              $ele_attr['value'] = $field['min_number'];  
            }
            else
            {
              $ele_attr['value'] = 1;   
            }
            
            
            
            $element .= ''.spyro_element_wrap_start($wrap_args).'
                            '.$icon_tag.'
                            <input type="number"  class="form-element form-number-element" '.spyro_set_form_attribute($ele_attr).'/>
                                             <div class="custom-number-arrows">
                                                <div class="arrow-up"></div>
                                                <div class="arrow-down"></div>
                                             </div>
                            
                            '.spyro_element_wrap_end().'';
            break;

            case 'select':
              $opt  = explode("\n",$field['options']);
              $options ='';   
               foreach( $opt as  $val )
                {
                    $options .= '<option class="spyro-form-option" value="'.$val.'">'.$val.'</option>';   
                }
              $element = '<div class="form-item-wrap form-select '.implode(' ' , $wrap_args['class']).'">
                            <div class="form-item">
                               <div class="form-label">'.$field['label'].spyro_check_optional($field['is_optional']).'</div>
                               <div class="form-field-wrap ">
                                  <div class="form-field">
                                     <select  class="form-element form-select-element" '.spyro_set_form_attribute($ele_attr).'>
                                       '.$options.'
                                     </select>
                                     <span class="form-select-arrow"><i class="tatsu-icon-chevron-down2"></i> </span>
                                  </div>
                               </div>
                            </div>
                        </div>';
            break;

             case 'country':
              $opt  = explode("\n",$field['options']);
              $exclude_country  = explode(",",$field['exclude_country']);
              $options =''; 
              $country = spyro_get_county();
              foreach( $country as  $val )
              {
                  if(!in_array($val, $exclude_country))
                  {
                     $options .= '<option value="'.$val.'">'.$val.'</option>';        
                 }
             }  
               
              $element = '<div class="form-item-wrap form-select '.implode(' ' , $wrap_args['class']).'">
                            <div class="form-item">
                               <div class="form-label">'.$field['label'].spyro_check_optional($field['is_optional']).'</div>
                               <div class="form-field-wrap ">
                                  <div class="form-field">
                                     <select  class="form-element form-select-element" '.spyro_set_form_attribute($ele_attr).'>
                                       '.$options.'
                                     </select>
                                     <span class="form-select-arrow"><i class="tatsu-icon-chevron-down2"></i> </span>
                                  </div>
                               </div>
                            </div>
                        </div>';
            break;

            // CheckBox
            case 'checkbox':

            $opt  = explode("\n",$field['options']);
            $options = '';
            
            if($field['checkbox_design'] == 'normal')
            {
                foreach( $opt as  $val )
                {
                    $options .= '<label>
                                <span class="form-checkbox-tick-wrap" >
                                   <input class="form-checkbox-element" type="checkbox" '.spyro_set_form_attribute($ele_attr,$field['field_type']).' value="'.$val.'"/>

                                   <svg class="form-checkbox-tick" xmlns="http://www.w3.org/2000/svg" width="8" height="6" viewBox="0 0 10 9" fill="none">
                                                         <path d="M1 4.6L4.2 7L9 1" stroke-width="2"></path>
                                                      </svg>
                              
                                  
                                </span >
                                <span class="form-checkbox-text">'.$val.'</span>
                             </label>';
                }

                $element .= '<div class="form-item-wrap form-checkbox '.implode(' ' , $wrap_args['class']).' '.($field['is_optional']?"":"spyro-required-checkbox").'">
                        <div class="form-item">
                           <div class="form-label">'.$field['label'].spyro_check_optional($field['is_optional']).'</div>
                           <div class="form-field-wrap">
                              <div class="form-field form-checkbox-default">
                                '.$options.'
                              </div>
                           </div>
                        </div>
                        <div class="error"></div>
                     </div>';
             }
             else
            {
                foreach( $opt as  $key => $val )
                {
                      if($key == 0)
                    {
                        $active = 'is-checked';
                    }
                    else
                    {
                        $active = '';
                    }
                    $options .= '<label class="'.$active.'">
                                      <input class="form-checkbox-element" type="checkbox" value="'.$val.'" '.spyro_set_form_attribute($ele_attr,$field['field_type']).'/>
                                      <span class="form-checkbox-text">'.$val.'</span>
                                 </label>';
                }

                $element .= '<div class="form-item-wrap form-checkbox '.implode(' ' , $wrap_args['class']).' '.($field['is_optional']?"":"spyro-required-checkbox").'">
                        <div class="form-item">
                           <div class="form-label">'.$field['label'].spyro_check_optional($field['is_optional']).'</div>
                           <div class="form-field-wrap">
                              <div class="form-field form-checkbox-button-style">
                                '.$options.'
                              </div>
                           </div>
                        </div>
                        <div class="error"></div>
                     </div>';
             }
            break;

             case 'radio':

            $opt  = explode("\n",$field['options']);
            $options = '';
            if($field['radio_design'] == 'normal')
            {
                foreach( $opt as  $val )
                {
                    $options .= '<label>
                                  <span class="form-radio-dot-wrap">
                                          <input class="form-radio-element" type="radio" value="'.$val.'" '.spyro_set_form_attribute($ele_attr).'/>
                                          <span class="form-radio-dot"></span>
                                  </span>
                                  <span class="form-radio-text">'.$val.'</span>
                             </label>';
                }

                $element .= '<div class="form-item-wrap form-radio '.implode(' ' , $wrap_args['class']).'">
                        <div class="form-item">
                           <div class="form-label">'.$field['label'].spyro_check_optional($field['is_optional']).'</div>
                           <div class="form-field-wrap">
                              <div class="form-field form-radio-default">
                                '.$options.'
                              </div>
                           </div>
                        </div>
                     </div>';
             }
             else
            {
                foreach( $opt as  $key => $val )
                {
                    if($key == 0)
                    {
                        $active = 'is-checked';
                    }
                    else
                    {
                        $active = '';
                    }
                    $options .= '  <label class="'.$active.'">
                                          <input class="form-radio-element" type="radio" value="'.$val.'" '.spyro_set_form_attribute($ele_attr).'/>
                                          <span class="form-radio-button-text">'.$val.'</span>
                                    </label>';
                }

                $element .= '<div class="form-item-wrap form-radio '.implode(' ' , $wrap_args['class']).'">
                        <div class="form-item">
                           <div class="form-label">'.$field['label'].spyro_check_optional($field['is_optional']).'</div>
                           <div class="form-field-wrap">
                              <div class="form-field form-radio-button">
                                '.$options.'
                              </div>
                           </div>
                        </div>
                     </div>';
             }
            break;

      
        }
        echo $element;
    }
}
if(!function_exists('spyro_check_optional'))
{
	function spyro_check_optional($is_optional)
	{
		if($is_optional)
		{
			return ' (optional)';
		}
	}
}
if(!function_exists('spyro_set_form_attribute'))
{
	function spyro_set_form_attribute($attr = array(),$field_type=null)
	{
		$atts = array();
		//print_r($attr);
		foreach($attr as $attribute_key => $attribute_values)
		{
			if(!empty($attribute_values))
			{
				if(is_array($attribute_values))
				{
					$atts[] = sprintf( '%1$s="%2$s"', $attribute_key, esc_attr( implode(' ' , $attribute_values)    ) );		
				}
				else
				{  
                    if(!empty($field_type) && $field_type == 'checkbox' && $attribute_key=='name'){
                        $attribute_values .='[]';
                    }
					$atts[] = sprintf( '%1$s="%2$s"', $attribute_key, esc_attr(  $attribute_values   ) );	
				}
				
			}
			
		}
		return implode( ' ', $atts );
		//return $atts;
	}
}
if(!function_exists('spyro_get_county'))
{
	function spyro_get_county()
	{
       $countries = array( 'AF' => 'Afghanistan',
        'AX' => 'Aland Islands',
        'AL' => 'Albania',
        'DZ' => 'Algeria',
        'AS' => 'American Samoa',
        'AD' => 'Andorra',
        'AO' => 'Angola',
        'AI' => 'Anguilla',
        'AQ' => 'Antarctica',
        'AG' => 'Antigua and Barbuda',
        'AR' => 'Argentina',
        'AM' => 'Armenia',
        'AW' => 'Aruba',
        'AU' => 'Australia',
        'AT' => 'Austria',
        'AZ' => 'Azerbaijan',
        'BS' => 'Bahamas the',
        'BH' => 'Bahrain',
        'BD' => 'Bangladesh',
        'BB' => 'Barbados',
        'BY' => 'Belarus',
        'BE' => 'Belgium',
        'BZ' => 'Belize',
        'BJ' => 'Benin',
        'BM' => 'Bermuda',
        'BT' => 'Bhutan',
        'BO' => 'Bolivia',
        'BA' => 'Bosnia and Herzegovina',
        'BW' => 'Botswana',
        'BV' => 'Bouvet Island (Bouvetoya)',
        'BR' => 'Brazil',
        'IO' => 'British Indian Ocean Territory (Chagos Archipelago)',
        'VG' => 'British Virgin Islands',
        'BN' => 'Brunei Darussalam',
        'BG' => 'Bulgaria',
        'BF' => 'Burkina Faso',
        'BI' => 'Burundi',
        'KH' => 'Cambodia',
        'CM' => 'Cameroon',
        'CA' => 'Canada',
        'CV' => 'Cape Verde',
        'KY' => 'Cayman Islands',
        'CF' => 'Central African Republic',
        'TD' => 'Chad',
        'CL' => 'Chile',
        'CN' => 'China',
        'CX' => 'Christmas Island',
        'CC' => 'Cocos (Keeling) Islands',
        'CO' => 'Colombia',
        'KM' => 'Comoros the',
        'CD' => 'Congo',
        'CG' => 'Congo the',
        'CK' => 'Cook Islands',
        'CR' => 'Costa Rica',
        'CI' => 'Cote d\'Ivoire',
        'HR' => 'Croatia',
        'CU' => 'Cuba',
        'CY' => 'Cyprus',
        'CZ' => 'Czech Republic',
        'DK' => 'Denmark',
        'DJ' => 'Djibouti',
        'DM' => 'Dominica',
        'DO' => 'Dominican Republic',
        'EC' => 'Ecuador',
        'EG' => 'Egypt',
        'SV' => 'El Salvador',
        'GQ' => 'Equatorial Guinea',
        'ER' => 'Eritrea',
        'EE' => 'Estonia',
        'ET' => 'Ethiopia',
        'FO' => 'Faroe Islands',
        'FK' => 'Falkland Islands (Malvinas)',
        'FJ' => 'Fiji the Fiji Islands',
        'FI' => 'Finland',
        'FR' => 'France, French Republic',
        'GF' => 'French Guiana',
        'PF' => 'French Polynesia',
        'TF' => 'French Southern Territories',
        'GA' => 'Gabon',
        'GM' => 'Gambia the',
        'GE' => 'Georgia',
        'DE' => 'Germany',
        'GH' => 'Ghana',
        'GI' => 'Gibraltar',
        'GR' => 'Greece',
        'GL' => 'Greenland',
        'GD' => 'Grenada',
        'GP' => 'Guadeloupe',
        'GU' => 'Guam',
        'GT' => 'Guatemala',
        'GG' => 'Guernsey',
        'GN' => 'Guinea',
        'GW' => 'Guinea-Bissau',
        'GY' => 'Guyana',
        'HT' => 'Haiti',
        'HM' => 'Heard Island and McDonald Islands',
        'VA' => 'Holy See (Vatican City State)',
        'HN' => 'Honduras',
        'HK' => 'Hong Kong',
        'HU' => 'Hungary',
        'IS' => 'Iceland',
        'IN' => 'India',
        'ID' => 'Indonesia',
        'IR' => 'Iran',
        'IQ' => 'Iraq',
        'IE' => 'Ireland',
        'IM' => 'Isle of Man',
        'IL' => 'Israel',
        'IT' => 'Italy',
        'JM' => 'Jamaica',
        'JP' => 'Japan',
        'JE' => 'Jersey',
        'JO' => 'Jordan',
        'KZ' => 'Kazakhstan',
        'KE' => 'Kenya',
        'KI' => 'Kiribati',
        'KP' => 'Korea',
        'KR' => 'Korea',
        'KW' => 'Kuwait',
        'KG' => 'Kyrgyz Republic',
        'LA' => 'Lao',
        'LV' => 'Latvia',
        'LB' => 'Lebanon',
        'LS' => 'Lesotho',
        'LR' => 'Liberia',
        'LY' => 'Libyan Arab Jamahiriya',
        'LI' => 'Liechtenstein',
        'LT' => 'Lithuania',
        'LU' => 'Luxembourg',
        'MO' => 'Macao',
        'MK' => 'Macedonia',
        'MG' => 'Madagascar',
        'MW' => 'Malawi',
        'MY' => 'Malaysia',
        'MV' => 'Maldives',
        'ML' => 'Mali',
        'MT' => 'Malta',
        'MH' => 'Marshall Islands',
        'MQ' => 'Martinique',
        'MR' => 'Mauritania',
        'MU' => 'Mauritius',
        'YT' => 'Mayotte',
        'MX' => 'Mexico',
        'FM' => 'Micronesia',
        'MD' => 'Moldova',
        'MC' => 'Monaco',
        'MN' => 'Mongolia',
        'ME' => 'Montenegro',
        'MS' => 'Montserrat',
        'MA' => 'Morocco',
        'MZ' => 'Mozambique',
        'MM' => 'Myanmar',
        'NA' => 'Namibia',
        'NR' => 'Nauru',
        'NP' => 'Nepal',
        'AN' => 'Netherlands Antilles',
        'NL' => 'Netherlands the',
        'NC' => 'New Caledonia',
        'NZ' => 'New Zealand',
        'NI' => 'Nicaragua',
        'NE' => 'Niger',
        'NG' => 'Nigeria',
        'NU' => 'Niue',
        'NF' => 'Norfolk Island',
        'MP' => 'Northern Mariana Islands',
        'NO' => 'Norway',
        'OM' => 'Oman',
        'PK' => 'Pakistan',
        'PW' => 'Palau',
        'PS' => 'Palestinian Territory',
        'PA' => 'Panama',
        'PG' => 'Papua New Guinea',
        'PY' => 'Paraguay',
        'PE' => 'Peru',
        'PH' => 'Philippines',
        'PN' => 'Pitcairn Islands',
        'PL' => 'Poland',
        'PT' => 'Portugal, Portuguese Republic',
        'PR' => 'Puerto Rico',
        'QA' => 'Qatar',
        'RE' => 'Reunion',
        'RO' => 'Romania',
        'RU' => 'Russian Federation',
        'RW' => 'Rwanda',
        'BL' => 'Saint Barthelemy',
        'SH' => 'Saint Helena',
        'KN' => 'Saint Kitts and Nevis',
        'LC' => 'Saint Lucia',
        'MF' => 'Saint Martin',
        'PM' => 'Saint Pierre and Miquelon',
        'VC' => 'Saint Vincent and the Grenadines',
        'WS' => 'Samoa',
        'SM' => 'San Marino',
        'ST' => 'Sao Tome and Principe',
        'SA' => 'Saudi Arabia',
        'SN' => 'Senegal',
        'RS' => 'Serbia',
        'SC' => 'Seychelles',
        'SL' => 'Sierra Leone',
        'SG' => 'Singapore',
        'SK' => 'Slovakia (Slovak Republic)',
        'SI' => 'Slovenia',
        'SB' => 'Solomon Islands',
        'SO' => 'Somalia, Somali Republic',
        'ZA' => 'South Africa',
        'GS' => 'South Georgia and the South Sandwich Islands',
        'ES' => 'Spain',
        'LK' => 'Sri Lanka',
        'SD' => 'Sudan',
        'SR' => 'Suriname',
        'SJ' => 'Svalbard & Jan Mayen Islands',
        'SZ' => 'Swaziland',
        'SE' => 'Sweden',
        'CH' => 'Switzerland, Swiss Confederation',
        'SY' => 'Syrian Arab Republic',
        'TW' => 'Taiwan',
        'TJ' => 'Tajikistan',
        'TZ' => 'Tanzania',
        'TH' => 'Thailand',
        'TL' => 'Timor-Leste',
        'TG' => 'Togo',
        'TK' => 'Tokelau',
        'TO' => 'Tonga',
        'TT' => 'Trinidad and Tobago',
        'TN' => 'Tunisia',
        'TR' => 'Turkey',
        'TM' => 'Turkmenistan',
        'TC' => 'Turks and Caicos Islands',
        'TV' => 'Tuvalu',
        'UG' => 'Uganda',
        'UA' => 'Ukraine',
        'AE' => 'United Arab Emirates',
        'GB' => 'United Kingdom',
        'US' => 'United States of America',
        'UM' => 'United States Minor Outlying Islands',
        'VI' => 'United States Virgin Islands',
        'UY' => 'Uruguay, Eastern Republic of',
        'UZ' => 'Uzbekistan',
        'VU' => 'Vanuatu',
        'VE' => 'Venezuela',
        'VN' => 'Vietnam',
        'WF' => 'Wallis and Futuna',
        'EH' => 'Western Sahara',
        'YE' => 'Yemen',
        'ZM' => 'Zambia',
        'ZW' => 'Zimbabwe');
        return $countries;
}
}
function spyro_element_wrap_start( $args = '' )
{
    
	if(is_array($args['class']))
    {
        $class = implode(' ',$args['class']);
    } 
    else
    {
        $class = $classes;
    }   
	$return = '<div class="form-item-wrap '.esc_attr($class).'">
                          <div class="form-item">
                             <div class="form-label">'.$args['label'].spyro_check_optional($args['is_optional']).'</div>
                                <div class="form-field-wrap">
                                    <div class="form-field">';
   return $return;	     
}
function spyro_element_wrap_end()
{
	$return = ' </div></div></div></div>';
	return $return;
}


if ( ! function_exists( 'spyro_mailchimp_subscription' ) ) {
    function spyro_mailchimp_subscription() {
        $result = array();
        $response = array();

        $email = '';
        $phone = '';
        $fname = '';
        $lname = '';
        $double_optin = false;

        $success_text = '';
        $failure_text = '';
        $already_in_list = ' already subscribed';
        $merge_fields = array();

        if(isset($_POST['success_text']) && !empty($_POST['success_text']))
        {
            $success_text = $_POST['success_text'];    
        }

        if(isset($_POST['failure_text']) && !empty($_POST['failure_text']))
        {
            $failure_text = $_POST['failure_text'];    
        }

        if(isset($_POST['already_in_list']) && !empty($_POST['already_in_list']))
        {
            $already_in_list = $_POST['already_in_list'];    
        }

        if(isset($_POST['double_optin']))
        {
            $double_optin = $_POST['double_optin'];
        }
                 
        $keys = array_keys($_POST);

        if(isset($_POST['email']))
        {
          $email = $_POST['email'];
        }

        if(isset($_POST['email_address']))
        {
          $email = $_POST['email_address'];
        }

        if(isset($_POST['fname']))
        {
          $fname = $_POST['fname'];
        }

        if(isset($_POST['lname']))
        {
          $lname = $_POST['lname'];
        }

        if(isset($_POST['phone']))
        {
          $phone = $_POST['phone'];

        }


         

      
        if( empty($_POST['api_key']) || empty( $_POST['list_id'] ) || empty( $email ) ) {
            $result['status'] = 'error';
            $result['data'] = __( 'Api Key / List Id / Email Address is missing', 'spyro-modules');
            echo json_encode($result);
            exit;
        }

        $MailChimp = new Spyro_Mailchimp($_POST['api_key']);



      
        $result = $MailChimp->call("/lists/{$_POST['list_id']}/members", array (
            
            'email_address'             =>  $email,
            'merge_fields' => array('FNAME' => $fname , 'LNAME' => $lname , 'PHONE' => $phone),
            'email_type'             => 'text',
            'status'        => 'subscribed',
            'double_optin'      => $double_optin,
            'update_existing'   => true,
            'replace_interests' => false,
            'send_welcome'      => false,
        ) , 'POST');

       
        $result = (array) json_decode($result , true);

        if( isset($result['status']) && $result['status'] == 'subscribed' ) {
            $response['status'] = 'success';
            $response['data'] = $success_text;
        }
        else if( isset($result['status']) && $result['status'] == 400 ) {
            $response['status'] = 'error';
            $response['data'] =  $email . ' ' . $already_in_list;
        }
         else {
            $response['status'] = 'error';
            $response['data'] = $failure_text;
        }
        //header('Content-type: application/json');
        echo json_encode($response);
        die();
    }
    add_action( 'wp_ajax_nopriv_spyro_mailchimp_subscription', 'spyro_mailchimp_subscription' );
    add_action( 'wp_ajax_spyro_mailchimp_subscription', 'spyro_mailchimp_subscription' );
}

if ( ! function_exists( 'spyro_sent_mail' ) ) {
    function spyro_sent_mail() {
        $result = array();
        $response = array();

         $success_text = '';
        $failure_text = '';
        $already_in_list = '';
        $merge_fields = array();
        $to_email = '';
        $to_email_options = '';

        if(isset($_POST['success_text']) && !empty($_POST['success_text']))
        {
            $success_text = $_POST['success_text'];    
        }

        if(isset($_POST['failure_text']) && !empty($_POST['failure_text']))
        {
            $failure_text = $_POST['failure_text'];    
        }


        
        $name = 'test_name';
        $email = 'krunal@expresstech.io';
        $message = 'This is dummy text';

      //php mailer variables
        if($to_email_options == 'admin_email')
        {
          $to = get_option('admin_email');   
        }
        else
        {
          $to = $_POST['to_email'];
        }
       
       
        $subject = "Subject";
        $headers = 'From: '. $email . "\r\n" .
          'Reply-To: ' . $email . "\r\n";

      $sent = wp_mail($to, $subject, strip_tags($message), $headers);
            if($sent) {
              $response['status'] = 'success';
              $response['data'] = $success_text;
            }//message sent!
            else  {
               $response['status'] = 'error';
                $response['data'] = $failure_text;
            }//message wasn't sent
       

        
        echo json_encode($response);
        die();
    }
    add_action( 'wp_ajax_nopriv_spyro_sent_mail', 'spyro_sent_mail' );
    add_action( 'wp_ajax_spyro_sent_mail', 'spyro_sent_mail' );
}

function spyro_get_country_codes()
{
    return '<div class="form-select-element-wrap">
           <select class="form-element form-select-element form-county-code-val">
              <option value="+91">IN +91</option>
              <option value="+1">US +1</option>
              <option value="+7">RU +7</option>
              <option value="+20">EG +20</option>
              <option value="+27">ZA +27</option>
              <option value="+30">GR +30</option>
              <option value="+31">NL +31</option>
              <option value="+32">BE +32</option>
              <option value="+33">FR +33</option>
              <option value="+34">ES +34</option>
              <option value="+36">HU +36</option>
              <option value="+39">IT +39</option>
              <option value="+40">RO +40</option>
              <option value="+41">CH +41</option>
              <option value="+43">AT +43</option>
              <option value="+44">JE +44</option>
              <option value="+45">DK +45</option>
              <option value="+46">SE +46</option>
              <option value="+47">SJ +47</option>
              <option value="+48">PL +48</option>
              <option value="+49">DE +49</option>
              <option value="+51">PE +51</option>
              <option value="+52">MX +52</option>
              <option value="+53">CU +53</option>
              <option value="+54">AR +54</option>
              <option value="+55">BR +55</option>
              <option value="+56">CL +56</option>
              <option value="+57">CO +57</option>
              <option value="+58">VE +58</option>
              <option value="+60">MY +60</option>
              <option value="+61">CC +61</option>
              <option value="+62">ID +62</option>
              <option value="+63">PH +63</option>
              <option value="+64">NZ +64</option>
              <option value="+65">SG +65</option>
              <option value="+66">TH +66</option>
              <option value="+81">JP +81</option>
              <option value="+82">KR +82</option>
              <option value="+84">VN +84</option>
              <option value="+86">CN +86</option>
              <option value="+90">TR +90</option>
              <option value="+92">PK +92</option>
              <option value="+93">AF +93</option>
              <option value="+94">LK +94</option>
              <option value="+95">MM +95</option>
              <option value="+98">IR +98</option>
              <option value="+212">MA +212</option>
              <option value="+213">DZ +213</option>
              <option value="+216">TN +216</option>
              <option value="+218">LY +218</option>
              <option value="+220">GM +220</option>
              <option value="+221">SN +221</option>
              <option value="+222">MR +222</option>
              <option value="+223">ML +223</option>
              <option value="+224">GN +224</option>
              <option value="+225">CI +225</option>
              <option value="+226">BF +226</option>
              <option value="+227">NE +227</option>
              <option value="+228">TG +228</option>
              <option value="+229">BJ +229</option>
              <option value="+230">MU +230</option>
              <option value="+231">LR +231</option>
              <option value="+232">SL +232</option>
              <option value="+233">GH +233</option>
              <option value="+234">NG +234</option>
              <option value="+235">TD +235</option>
              <option value="+236">CF +236</option>
              <option value="+237">CM +237</option>
              <option value="+238">CV +238</option>
              <option value="+239">ST +239</option>
              <option value="+240">GQ +240</option>
              <option value="+241">GA +241</option>
              <option value="+242">CG +242</option>
              <option value="+243">CD +243</option>
              <option value="+244">AO +244</option>
              <option value="+245">GW +245</option>
              <option value="+246">IO +246</option>
              <option value="+248">SC +248</option>
              <option value="+249">SD +249</option>
              <option value="+250">RW +250</option>
              <option value="+251">ET +251</option>
              <option value="+252">SO +252</option>
              <option value="+253">DJ +253</option>
              <option value="+254">KE +254</option>
              <option value="+255">TZ +255</option>
              <option value="+256">UG +256</option>
              <option value="+257">BI +257</option>
              <option value="+258">MZ +258</option>
              <option value="+260">ZM +260</option>
              <option value="+261">MG +261</option>
              <option value="+262">RE +262</option>
              <option value="+263">ZW +263</option>
              <option value="+264">NA +264</option>
              <option value="+265">MW +265</option>
              <option value="+266">LS +266</option>
              <option value="+267">BW +267</option>
              <option value="+268">SZ +268</option>
              <option value="+269">KM +269</option>
              <option value="+290">SH +290</option>
              <option value="+291">ER +291</option>
              <option value="+297">AW +297</option>
              <option value="+298">FO +298</option>
              <option value="+299">GL +299</option>
              <option value="+350">GI +350</option>
              <option value="+351">PT +351</option>
              <option value="+352">LU +352</option>
              <option value="+353">IE +353</option>
              <option value="+354">IS +354</option>
              <option value="+355">AL +355</option>
              <option value="+356">MT +356</option>
              <option value="+358">FI +358</option>
              <option value="+359">BG +359</option>
              <option value="+370">LT +370</option>
              <option value="+371">LV +371</option>
              <option value="+372">EE +372</option>
              <option value="+373">MD +373</option>
              <option value="+374">AM +374</option>
              <option value="+375">BY +375</option>
              <option value="+376">AD +376</option>
              <option value="+377">MC +377</option>
              <option value="+378">SM +378</option>
              <option value="+379">VA +379</option>
              <option value="+380">UA +380</option>
              <option value="+381">RS +381</option>
              <option value="+382">ME +382</option>
              <option value="+385">HR +385</option>
              <option value="+386">SI +386</option>
              <option value="+387">BA +387</option>
              <option value="+389">MK +389</option>
              <option value="+420">CZ +420</option>
              <option value="+421">SK +421</option>
              <option value="+423">LI +423</option>
              <option value="+500">FK +500</option>
              <option value="+501">BZ +501</option>
              <option value="+502">GT +502</option>
              <option value="+503">SV +503</option>
              <option value="+504">HN +504</option>
              <option value="+505">NI +505</option>
              <option value="+506">CR +506</option>
              <option value="+507">PA +507</option>
              <option value="+508">PM +508</option>
              <option value="+509">HT +509</option>
              <option value="+537">CY +537</option>
              <option value="+590">MF +590</option>
              <option value="+591">BO +591</option>
              <option value="+593">EC +593</option>
              <option value="+594">GF +594</option>
              <option value="+595">PY +595</option>
              <option value="+596">MQ +596</option>
              <option value="+597">SR +597</option>
              <option value="+598">UY +598</option>
              <option value="+599">AN +599</option>
              <option value="+670">TL +670</option>
              <option value="+672">NF +672</option>
              <option value="+673">BN +673</option>
              <option value="+674">NR +674</option>
              <option value="+675">PG +675</option>
              <option value="+676">TO +676</option>
              <option value="+677">SB +677</option>
              <option value="+678">VU +678</option>
              <option value="+679">FJ +679</option>
              <option value="+680">PW +680</option>
              <option value="+681">WF +681</option>
              <option value="+682">CK +682</option>
              <option value="+683">NU +683</option>
              <option value="+685">WS +685</option>
              <option value="+686">KI +686</option>
              <option value="+687">NC +687</option>
              <option value="+688">TV +688</option>
              <option value="+689">PF +689</option>
              <option value="+690">TK +690</option>
              <option value="+691">FM +691</option>
              <option value="+692">MH +692</option>
              <option value="+850">KP +850</option>
              <option value="+852">HK +852</option>
              <option value="+853">MO +853</option>
              <option value="+855">KH +855</option>
              <option value="+856">LA +856</option>
              <option value="+872">PN +872</option>
              <option value="+880">BD +880</option>
              <option value="+886">TW +886</option>
              <option value="+960">MV +960</option>
              <option value="+961">LB +961</option>
              <option value="+962">JO +962</option>
              <option value="+963">SY +963</option>
              <option value="+964">IQ +964</option>
              <option value="+965">KW +965</option>
              <option value="+966">SA +966</option>
              <option value="+967">YE +967</option>
              <option value="+968">OM +968</option>
              <option value="+970">PS +970</option>
              <option value="+971">AE +971</option>
              <option value="+972">IL +972</option>
              <option value="+973">BH +973</option>
              <option value="+974">QA +974</option>
              <option value="+975">BT +975</option>
              <option value="+976">MN +976</option>
              <option value="+977">NP +977</option>
              <option value="+992">TJ +992</option>
              <option value="+993">TM +993</option>
              <option value="+994">AZ +994</option>
              <option value="+995">GE +995</option>
              <option value="+996">KG +996</option>
              <option value="+998">UZ +998</option>
              <option value="+1268">AG +1268</option>
              <option value="+1664">MS +1664</option>
              <option value="+1 684">AS +1 684</option>
              <option value="+1 264">AI +1 264</option>
              <option value="+1 242">BS +1 242</option>
              <option value="+1 246">BB +1 246</option>
              <option value="+1 441">BM +1 441</option>
              <option value="+ 345">KY + 345</option>
              <option value="+1 767">DM +1 767</option>
              <option value="+1 849">DO +1 849</option>
              <option value="+1 473">GD +1 473</option>
              <option value="+1 671">GU +1 671</option>
              <option value="+1 876">JM +1 876</option>
              <option value="+7 7">KZ +7 7</option>
              <option value="+1 670">MP +1 670</option>
              <option value="+1 939">PR +1 939</option>
              <option value="+1 868">TT +1 868</option>
              <option value="+1 649">TC +1 649</option>
              <option value="+1 869">KN +1 869</option>
              <option value="+1 758">LC +1 758</option>
              <option value="+1 784">VC +1 784</option>
              <option value="+1 284">VG +1 284</option>
              <option value="+1 340">V +1 340I</option>
           </select>
           <span class="form-select-arrow"><i class="tatsu-icon-chevron-down2"></i> </span>
        </div>';
}
