<?php
    $custom_padding = tatsu_get_post_loop_prop( 'custom_post_details_padding' );
    $post_details_padding = tatsu_get_post_loop_prop( 'post_details_padding' );
    $post_details_color = tatsu_get_post_loop_prop( 'post_details_color' );
    $post_details_style = '';

    $post_details_padding = is_array( $post_details_padding ) ? implode( ' ', $post_details_padding ) : $post_details_padding;

    if( !empty( $post_details_color ) ) {
        $post_details_color = "background : $post_details_color;";
    }else{
        $post_details_color = '';
    }
    if( !empty( $custom_padding ) && !empty( $post_details_padding ) ) {
        $post_details_padding = is_array( $post_details_padding ) ? implode( ' ', $post_details_padding ) : $post_details_padding;
        $post_details_padding = "padding : {$post_details_padding};";
    }else {
        $post_details_padding = '';
    }
    if( !empty( $post_details_color ) || !empty( $post_details_padding ) ) {
        $post_details_style = sprintf( 'style = "%s%s"', $post_details_color, $post_details_padding );
    }
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <div class="<?php echo tatsu_get_element_class( 'post-inner' ); ?>">
        <?php tatsu_get_template_part( 'template-parts/posts/partials/archive', 'thumb' ); ?>
        <div class="<?php echo tatsu_get_element_class( 'post-details' ); ?>" <?php echo !empty( $post_details_style ) ? $post_details_style : ''; ?>>
            <div class="<?php echo tatsu_get_element_class( 'post-details-inner' ); ?>">
                <?php tatsu_get_template_part( 'template-parts/posts/loop', 'title' ); ?>
                <?php tatsu_get_template_part( 'template-parts/posts/partials/archive', 'content' ); ?>
                <?php tatsu_get_template_part( 'template-parts/posts/partials/archive-tertiary', 'meta' ); ?>
            </div>
        </div>
    </div>
</article>