<?php
    $post_shadow = tatsu_get_post_loop_prop( 'post_shadow' );
    $border_radius = tatsu_get_post_loop_prop( 'border_radius' );
    $arrangement = tatsu_get_post_loop_prop( 'arrangement' );

    $post_style = '';
    $post_class = array();
    $post_inner_class = array();
    $post_inner_class[] = tatsu_get_element_class( 'post-inner' );
    if( !empty( $border_radius ) ) {
        $post_style = sprintf( 'style = "border-radius : %spx";', $border_radius );
    }

    if( !empty( $post_shadow ) ) {
        $post_inner_class[] = tatsu_get_element_class( 'post-shadow-' . $post_shadow );
    }
    if( 'grid' === $arrangement ) {
        $post_class[] = 'be-col';
        $double_width = get_post_meta( get_the_ID(), tatsu_get_meta_prefix() . 'blog_double_width', true );
        $double_height = get_post_meta( get_the_ID(), tatsu_get_meta_prefix() . 'blog_double_height', true );
        if( !empty( $double_height ) && !empty( $double_width ) ) {
            $post_class[] = 'be-double-width-height-cell';
        }else if( !empty( $double_width ) ) {
            $post_class[] = 'be-double-width-cell';
        }else if( !empty( $double_height ) ) {
            $post_class[] = 'be-double-height-cell';
        }
    }else if( 'slider' === $arrangement ) {
        $post_class[] = 'be-slide';
        $post_inner_class[] = 'be-slide-inner';
    }

?>
<article id="post-<?php the_ID(); ?>" <?php post_class( $post_class ); ?> <?php tatsu_print_post_slide_or_cell_styles(); ?>>
    <div class="<?php echo implode( ' ', $post_inner_class ); ?>" <?php echo !empty($post_style) ? $post_style : ''; ?>>
        <?php tatsu_get_template_part( 'template-parts/posts/partials/archive', 'thumb' ); ?>
        <div class="<?php echo tatsu_get_element_class( 'post-details' ); ?>">
            <?php tatsu_get_template_part( 'template-parts/posts/loop', 'title' ); ?>
            <?php tatsu_get_template_part( 'template-parts/posts/partials/archive-tertiary', 'meta' ); ?>
        </div>
    </div>
</article>
