<?php
if(!function_exists('is_tatsu_pro_valid')){
    function is_tatsu_pro_valid( ) {
        $tatsu_license = trim(get_option('tatsu_license_key'));
        $tatsu_item_id = trim(get_option( 'tatsu_license_item_id' ));
        if(empty($tatsu_license)|| empty($tatsu_item_id)){
            return false;
        }else{
            return true;
        }		
    }
}

/**
 * Check if specific video format is supported
 */
if ( ! function_exists( 'tatsu_valid_video_format' ) ) {
	function tatsu_valid_video_format( $url = '' ) {
		$default_types = wp_get_video_extensions();
		$type = wp_check_filetype( $url, wp_get_mime_types() );
		if ( ! empty( $type[ 'ext' ] ) && in_array( strtolower( $type[ 'ext' ] ), $default_types ) ) {
			return true;
		}
		return false;
	}
}

/**
 *  Get current theme information.
 */
if ( ! function_exists( 'tatsu_get_theme_info' ) ) {
	function tatsu_get_theme_info( $data = array( 'name', 'version' ) ) {
		if ( empty( $data ) ) {
			return false;
		} else {
			$theme_data = wp_get_theme();
			//if child theme, fetch parent
			if( false !== ( $theme_data->parent() ) ) {
				$theme_data = $theme_data->parent();
			}
			if( ! empty( $theme_data ) && is_object( $theme_data ) ) {
				if ( is_string( $data ) ) {
					$data = ucfirst( $data );
					return $theme_data->get( $data );
				} else if( is_array( $data ) ) {
					$return = array();
					foreach( $data as $prop ) {
						$uc_prop = ucfirst( $prop );
						$prop_value = $theme_data->get( $uc_prop );
						if ( ! empty( $prop_value ) ) {
							$return[ $prop ] = $prop_value;
						}
					}
					return !empty( $return ) ? $return : false;
				}
				return false;
			}
		}
	}
}

/**
 * Check if valid video embed url
 */
if ( ! function_exists( 'tatsu_valid_video_embed' ) ) {
	function tatsu_valid_video_embed( $url = '' ) {
		if ( strpos( $url, 'youtu' ) > 0 || strpos( $url, 'vimeo' ) > 0 ) {
			return true;
		}
		return false;
	}
}

/**
 * Setup Posts Loop
 */
if ( ! function_exists( 'tatsu_setup_post_loop' ) ) {
    function tatsu_setup_post_loop( $args = array() ) {
        $default_args = array(
            'custom_post_details_padding' 	=> '',
            'arrangement'					=> 'grid', // can be grid or slider or list
            'type'							=> 'blog', // can be blog, recent posts, featured or related posts
            'featured_posts_height'			=> '700', 
            'arrows'						=> '0'	// used only for slider arrangement
        );

        // Merge any existing values.
        if ( isset( $GLOBALS['tatsu_posts_loop'] ) ) {
            $default_args = array_merge( $default_args, $GLOBALS['tatsu_posts_loop'] );
        }
        $GLOBALS['tatsu_posts_loop'] = wp_parse_args( $args, $default_args );
        //error_log(print_r( $GLOBALS['tatsu_posts_loop'],1));
    }
}

/**
 * Reset posts loop
 */
if ( ! function_exists( 'tatsu_reset_post_loop' ) ) {
    function tatsu_reset_post_loop() {
        if ( isset( $GLOBALS['tatsu_posts_loop'] ) ) {
            unset( $GLOBALS[ 'tatsu_posts_loop' ] );
        }
    }
}

/**
 * Get post loop props
 */
if ( ! function_exists( 'tatsu_get_post_loop_prop' ) ) {
    function tatsu_get_post_loop_prop( $prop, $default = '' ) {
        if ( ! isset( $GLOBALS['tatsu_posts_loop'] ) ) {
            tatsu_setup_post_loop(); // Ensure be posts loop is setup.
        }
        return isset( $GLOBALS['tatsu_posts_loop'], $GLOBALS['tatsu_posts_loop'][ $prop ] ) ? $GLOBALS['tatsu_posts_loop'][ $prop ] : $default;
    }
}

if ( ! function_exists( 'tatsu_print_post_slide_or_cell_styles' ) ) {
    function tatsu_print_post_slide_or_cell_styles() {
        $gutter = tatsu_get_post_loop_prop( 'posts_gutter' );
        $arrangement = tatsu_get_post_loop_prop( 'arrangement' );
        $post_shadow = tatsu_get_post_loop_prop( 'post_shadow' );
        $gutter = is_numeric( $gutter ) ? $gutter : 20;

        $padding = sprintf( 'padding : 0 %spx;', $gutter/2 );

        if( 'grid' === $arrangement ) {
            $margin = "margin-bottom : {$gutter}px;";
        }else {
            $margin = '';
        }

        echo sprintf( 'style = "%s%s"', esc_attr( $padding ), esc_attr( $margin ) );
    }
}

if ( ! function_exists( 'tatsu_kses_output' ) ) {
    function tatsu_kses_output( $data ){
        return empty( $data ) ? '': wp_kses( $data, 'post' );
    }
}

if ( ! function_exists( 'tatsu_get_categories' ) ) {
    function tatsu_get_categories() {
        $post_categories = get_categories();
        $category_options = array();
        foreach( $post_categories as $category ) {
            if( is_object( $category ) ) {
                $category_options[ $category->slug ] = $category->name;
            }
        }
        return $category_options;
    }
}

/**
 * 	Get theme specific class names
 */
if ( ! function_exists( 'tatsu_get_element_class' ) ) {
    function tatsu_get_element_class() {
        $prefixed_class = '';
        $args = func_get_args();
        $prefixed_args = array_map( 'tatsu_get_element_class_callback', array_filter( $args ) );
        $prefixed_class = implode( ' ', $prefixed_args );
        return esc_attr( $prefixed_class );
    }

    function tatsu_get_element_class_callback( $class ) {
        return 'exp-' . $class;
    }
}

/**
 * 	Get theme specific class names
 */
if ( ! function_exists( 'tatsu_get_template_part' ) ) {
    function tatsu_get_template_part( $path, $suffix = false ) {
        if ( $suffix ) {
            $path = $path . '-' . $suffix;
        }
        require TATSU_PRO_PLUGIN_DIR . 'includes/modules/' . $path . '.php';
    }
}

if ( ! function_exists( 'tatsu_has_blog_thumb' ) ) {
    function tatsu_has_blog_thumb( $post_id = '', $post_format = '' ) {
        if ( ! empty( $post_id ) && ! empty( $post_format ) ) {
            $post_thumb =  get_the_post_thumbnail( $post_id ); 
            return ! empty( $post_thumb ) ? true : false;
        }
        return false;
    }
}

if ( ! function_exists( 'tatsu_do_output' ) ) {
    function tatsu_do_output( $output ) {
        $result = ! empty( $output ) ? $output : '';
		return $result;
    }
}

/** 
 * Pagination.
 */
if ( ! function_exists( 'tatsu_get_pagination' ) ) {
	function tatsu_get_pagination( $args = array() ) {
        global $wp_query;
		if ( function_exists( 'tatsu_get_element_class' ) ) {
			$args = is_array( $args ) ? $args : array();
			$big = 999999999;
			$max_num_pages = $wp_query->max_num_pages;
			$pagination_class = array();
			$pagination_style = '';
			if ( array_key_exists( 'class', $args ) ) {
				$pagination_class[] = $args[ 'class' ];
				unset( $args[ 'class' ] );
			}
			$pagination_class[] = tatsu_get_element_class( 'pagination' );
			if ( array_key_exists( 'padding', $args ) ) {
				$pagination_style = sprintf( 'style = "padding : 0 %spx;"', $args[ 'padding' ] );
				unset( $args[ 'padding' ] );
			}
			$defaults = array (
				'base'              => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
				'format'            => '?paged=%#%', 
				'current'           => 'page' ===  get_option('show_on_front') && is_front_page() ? max( 1, get_query_var( 'page' ) ) : max( 1, get_query_var( 'paged' ) ), //https://codex.wordpress.org/Creating_a_Static_Front_Page#Pagination
				'mid_size'          => 2,
				'end_size'			=> 2,
				'prev_next'         => true,
				'prev_text'			=> '<svg width="6" height="10" viewBox="0 0 6 10" fill="none" xmlns="http://www.w3.org/2000/svg">
				<path d="M4.8583 9.42859L6 8.32073L2.2915 4.7143L6 1.10787L4.8583 1.70663e-05L4.12136e-07 4.7143L4.8583 9.42859Z" fill="#242424"/>
				</svg>',
				'next_text'			=> '<svg width="6" height="10" viewBox="0 0 6 10" fill="none" xmlns="http://www.w3.org/2000/svg">
				<path d="M1.1417 0L0 1.10786L3.7085 4.71429L0 8.32071L1.1417 9.42857L6 4.71429L1.1417 0Z" fill="#242424"/>
				</svg>
				',	
				'total'             => $max_num_pages,
				'type'              => 'plain',
			);
			$defaults[ 'before_page_number' ] = sprintf( '<span class = "%s">', tatsu_get_element_class( 'page-number' ) );
			$defaults[ 'after_page_number' ] =  '</span>';
			$args = wp_parse_args( $args, $defaults );
		    return sprintf( '<div class = "%s" %s>%s</div>', implode( ' ', $pagination_class ), $pagination_style, paginate_links( $args ) );
		}
		return '';
    }
}

/**
 * Get Placeholder padding 
 */
if ( ! function_exists( 'tatsu_get_placeholder_padding' ) ) {
    function tatsu_get_placeholder_padding( $id = '', $post_thumb_size = 'full' ) {
        if ( ! empty( $id ) ) {
            $img_details = wp_get_attachment_image_src( $id, $post_thumb_size );
            if ( ! empty( $img_details ) ) {
                $width = ! empty( $img_details[ 1 ] ) && is_numeric( $img_details[ 1 ] ) && 0 !== $img_details[ 1 ] ? $img_details[ 1 ] : 100;
                $height = ! empty( $img_details[ 2 ] ) && is_numeric( $img_details[ 2 ] ) && 0 !== $img_details[ 2 ] ? $img_details[ 2 ] : 100;
                $aspect_ratio = $width / $height;
                $padding = round( ( 1 / $aspect_ratio ), 5 );
                $padding = $padding * 100;
                return $padding;
            }
        }
        return 100;
    }
}

/**
 * Get theme prefix
 */
if ( ! function_exists( 'tatsu_get_meta_prefix' ) ) {
    function tatsu_get_meta_prefix() {
        $theme_name = tatsu_get_theme_info( 'name' );
        return $theme_name . '_';
    }
}

/**
 * Check if valid hex color.
 * 
 * @source http://php.net/manual/en/function.ctype-xdigit.php
 */
if ( ! function_exists( 'tatsu_check_valid_colorhex' ) ) {
    function tatsu_check_valid_colorhex( $color_code ) {
        // If user accidentally passed along the # sign, strip it off
        $color_code = ltrim( $color_code, '#' );
        if ( ctype_xdigit( $color_code ) && ( strlen( $color_code ) == 6 || strlen( $color_code ) == 3 ) ) {
            return true;
        }
        return false;
    }
}

/**
 * Get terms of post types
 */
if ( ! function_exists( 'tatsu_get_terms' ) ) {
	function tatsu_get_terms( $id = null, $tax = 'category', $class = '', $anchor_class = '', $sep = ',', $color = false, $bg_color = false ) {
		if ( ! empty( $id ) ) {
			$terms = get_the_terms( $id, $tax );
			if( !empty( $terms ) ) {
				$terms_html = '';
				$term_style = '';
				$meta_prefix = tatsu_get_meta_prefix();
				$term_class = tatsu_get_element_class( 'term-link' );
				$last_term = end( $terms );
				$wrapper_class = tatsu_get_element_class( 'tax-list' );
				if( !empty( $class ) ) {
					$wrapper_class .= ' ' . $class;
				}
				if( true === $color || true === $bg_color ) {
					extract( be_get_color_hub() );
				}
				$terms_html = '<div class="' . $wrapper_class . '">';
				foreach( $terms as $term ) {
					$term_color = '';
					$data_term_color = '';
					$term_bg_color = '';
					$data_term_bg_color = '';
					if( true === $color ) {
						if( metadata_exists( 'term', $term->term_id, "{$meta_prefix}cat_color" ) ) {
							$term_color = get_term_meta( $term->term_id, "{$meta_prefix}cat_color", true );
							if( !empty( $term_color ) ) {
								if( tatsu_check_valid_colorhex( $term_color ) ) {
									$data_term_color = sprintf( 'data-color = "#%s"', $term_color );
									$term_color = "color : #{$term_color};";
								}else {
									$data_term_color = sprintf( 'data-color = "%s"', $term_color );
									$term_color = "color : {$term_color};";
								}
							}
						}else {
							$data_term_color = sprintf( 'data-color = "%s"', $alt_bg_text_color );
							$term_color = "color : $alt_bg_text_color;";
						}
					}
					if( true === $bg_color ) {
						if( metadata_exists( 'term', $term->term_id, "{$meta_prefix}cat_bg_color" ) ) {
							$term_bg_color = get_term_meta( $term->term_id, "{$meta_prefix}cat_bg_color", true );
							if( !empty( $term_bg_color ) ) {
								if( tatsu_check_valid_colorhex( $term_bg_color ) ) {
									$data_term_bg_color = sprintf( 'data-bg-color = "#%s"', $term_bg_color );
									$term_bg_color = "background : #{$term_bg_color};";
								}else {
									$data_term_bg_color = sprintf( 'data-bg-color = "%s"', $term_bg_color );
									$term_bg_color = "background : {$term_bg_color};";
								}
							}
						}else {
							$data_term_bg_color = sprintf( 'data-bg-color = "%s"', $color_scheme );
							$term_bg_color = "background : $color_scheme;";
						}
					}
					if( !empty( $term_bg_color ) || !empty( $term_color ) ) {
						$term_style = 'style = "' . $term_color . $term_bg_color . '"';
					}
					$terms_html .= '<a href ="' . get_term_link( $term ) . '" class="' . ( !empty( $anchor_class ) ? ( $anchor_class . ' ' ) : '' ) . tatsu_get_element_class( 'term', !empty( $term_color ) ? 'term-with-custom-color' : '' ) . '" ' . $term_style . ' ' . $data_term_bg_color . ' ' . $data_term_color . '>' . $term->name .'</a>';
					if( !empty( $sep ) && $last_term->term_id !== $term->term_id ) {
						$terms_html .= $sep;
					}
				}
				$terms_html .= '</div>';
				return $terms_html;
			}
		}
		return false;
	}
}

/**
 * Read more link style
 */
if ( ! function_exists( 'tatsu_read_more_link' ) ) {
	function tatsu_read_more_link() {
		$read_more_style = tatsu_get_post_loop_prop( 'read_more' );
		$classes = tatsu_get_element_class( 'more-link' );
        return sprintf(
            '%s<a href="%s" class="%s">%s</a>%s',
            'underlined' === $read_more_style ? '<div>' : '',
            esc_url( get_permalink() ),
            tatsu_get_element_class( 'read-more', 'read-more-' . $read_more_style ),
            'dots' === $read_more_style ? '...' : esc_html__( 'Read More', 'tatsu-pro' ),
            'underlined' === $read_more_style ? '</div>' : ''
        );
	}
}

if ( ! function_exists( 'check_is_tatsu_standalone' ) ) {
	function check_is_tatsu_standalone() {
		if ( function_exists( 'is_tatsu_standalone' ) ) {
			return is_tatsu_standalone();
		}

		$check_theme = strtolower( tatsu_get_theme_info( 'name' ) );
		$allowed_themes = [ 'oshin', 'exponent', 'spyro' ];
		$result = true;
		if ( in_array( $check_theme, $allowed_themes ) ) {
			$result =  false;
		}
		return $result;		
	}
}

/**
 * Parse ACF and WP's custom fields and functions.
 *
 * @author Sayan Datta (@im_sayaan)
 * @since  1.0.3
 *
 * @param string $content
 * 
 * @return string
 */
if ( ! function_exists( 'tatsu_get_custom_fields' ) ) {
	function tatsu_get_custom_fields( $value = false ) {
		$fields = [];

		if ( isset( $_GET['tatsu'], $_GET['id'] ) ) {
			$post_id = intval( $_GET['id'] );
			
			// Check if ACF is active.
			if ( function_exists( 'get_field_objects' ) ) {
				$post_fields = get_field_objects( $post_id );
				if ( $post_fields ) {
					$acf_fields = [];
					foreach( $post_fields as $field ) {
						$key = 'acf/' . $post_id . '/' . $field['name'];
						$acf_fields[ $key ] = $value ? $field['value'] : sprintf( __( '%s', 'tatsu' ), $field['label'] );
					}
					$fields = array_merge( $fields, $acf_fields );
				}
			}
		}

		return apply_filters( 'tatsu_get_custom_fields', $fields );
	}
}

/**
 * Parse ACF and WP's custom fields and functions.
 *
 * @author Sayan Datta (@im_sayaan)
 * @since  1.0.3
 *
 * @param string $content
 * 
 * @return string
 */
if ( ! function_exists( 'tatsu_get_custom_fields_list' ) ) {
	function tatsu_get_custom_fields_list() {
		$fields = [];
		$post_fields = tatsu_get_custom_fields();
		foreach( $post_fields as $key => $field ) {
			$fields[] = [
				'text' => $field,
				'value' => $key,
			];
		}

		return apply_filters( 'tatsu_get_custom_fields_list', $fields );
	}
}

/**
 * List WP Functions and prepare an array.
 *
 * @author Sayan Datta (@im_sayaan)
 * @since  1.0.3
 * 
 * @return array
 */
if ( ! function_exists( 'tatsu_get_wp_functions' ) ) {
	function tatsu_get_wp_functions( $value = false ) {
		$fields = [];

		if ( isset( $_GET['tatsu'], $_GET['id'] ) ) {
			$post_id = intval( $_GET['id'] );
			$post_type = get_post_type( $post_id );

			$functions = [
				'get_the_title' => 'Post Title',
				'get_the_date' => 'Post Date',
				'get_the_modified_date' => 'Post Modified Date',
				'get_the_author' => 'Post Author',
				'get_comments_number' => 'Comment Count',
				'get_the_post_thumbnail_url' => 'Post Featured Image',
			];

			if ( 'post' === $post_type ) {
				$functions['get_the_category'] = 'Post Categories';
				$functions['get_the_tags'] = 'Post Tags';
			}

			$wp_fields = [];
			foreach( $functions as $func => $title ) {
				$key = 'wp/' . $post_id . '/' . $func;
				$wp_fields[ $key ] = $value ? tatsu_parse_wp_functions( $func, $post_id ) : sprintf( __( '%s', 'tatsu' ), $title );
			}
			$fields = array_merge( $fields, $wp_fields );
		}
		
		return apply_filters( 'tatsu_get_wp_functions', $fields );
	}
}

/**
 * List WP Functions and prepare an array.
 *
 * @author Sayan Datta (@im_sayaan)
 * @since  1.0.3
 * 
 * @return array
 */
if ( ! function_exists( 'tatsu_get_wp_functions_list' ) ) {
	function tatsu_get_wp_functions_list() {
		$fields = [];

		$fields = [];
		$post_fields = tatsu_get_wp_functions();
		foreach( $post_fields as $key => $field ) {
			$fields[] = [
				'text' => $field,
				'value' => $key,
			];
		}
		
		return apply_filters( 'tatsu_get_wp_functions_list', $fields );
	}
}

/**
 * List ACF Fields and WP Functions and prepare a group.
 *
 * @author Sayan Datta (@im_sayaan)
 * @since  1.0.3
 * 
 * @return array
 */
if ( ! function_exists( 'tatsu_get_custom_fields_group' ) ) {
	function tatsu_get_custom_fields_group() {
		$fields = [];

		$acf_fields = tatsu_get_custom_fields_list();
		if ( ! empty( $acf_fields ) ) {
			$fields[] = [
				'title' => __( 'Advanced Custom Fields', 'tatsu' ),
				'fields' => $acf_fields,
			];
		}

		$wp_fields = tatsu_get_wp_functions_list();
		if ( ! empty( $wp_fields ) ) {
			$fields[] = [
				'title' => __( 'WordPress', 'tatsu' ),
				'fields' => $wp_fields,
			];
		}

		return apply_filters( 'tatsu_get_custom_fields_group', $fields );
	}
}

/**
 * Parse WP functions.
 *
 * @author Sayan Datta (@im_sayaan)
 * @since  1.0.3
 *
 * @param string $function
 * @param int    $post_id
 * 
 * @return string
 */
if ( ! function_exists( 'tatsu_parse_wp_functions' ) ) {
	function tatsu_parse_wp_functions( $function, $post_id ) {
		global $wpdb;

		$content = '';
		switch ( $function ) {
			case 'get_the_title':
			case 'get_comments_number':
			case 'get_the_post_thumbnail_url':
			  	$content = $function( $post_id );
			  	break;
			case 'get_the_date':
			case 'get_the_modified_date':
				$format = apply_filters( 'tatsu_cf_' . $function, '', $post_id );
				$content = $function( $format, $post_id );
			  	break;
			case 'get_the_author':
				$author_id = (int) $wpdb->get_var( $wpdb->prepare( "SELECT post_author FROM {$wpdb->posts} WHERE ID = %d ", $post_id ) );
				$content = get_the_author_meta( 'display_name', $author_id );
				break;
			case 'get_the_category':
			case 'get_the_tags':
				$taxonomies = $function( $post_id );
				$taxonomies = wp_list_pluck( $taxonomies, 'name' );

				$separator = apply_filters( 'tatsu_cf_separator', ', ' );
				$content = join( $separator, array_unique( $taxonomies ) );
				break;
			default:
				$content = $function;
		}

		return $content;
	}
}

/**
 * List ACF Fields and WP Functions and prepare a group.
 *
 * @author Sayan Datta (@im_sayaan)
 * @since  1.0.3
 * 
 * @return array
 */
add_filter( 'tatsu_get_custom_fields_dropdown', function( $fields ) {
	unset( $fields['pro'] );

	$post_fields = tatsu_get_custom_fields();
	foreach( $post_fields as $key => $field ) {
		$fields[ $key ] = sprintf( __( 'ACF: %s' ), $field );
	}

	$post_fields = tatsu_get_wp_functions();
	foreach( $post_fields as $key => $field ) {
		$fields[ $key ] = sprintf( __( 'WP: %s' ), $field );
	}

	return $fields;
} );

/**
 * Parse ACF and WP's custom fields and functions.
 *
 * @author Sayan Datta (@im_sayaan)
 * @since  1.0.3
 *
 * @param string $content
 * 
 * @return string
 */
add_filter( 'tatsu_parse_custom_fields', function( $content ) {
	if ( strpos( $content, 'acf/' ) !== false ) {
		$is_acf = true;
	} else if ( strpos( $content, 'wp/' ) !== false ) {
		$is_wp = true;
	}

	$content = str_replace( [ 'acf/', 'wp/' ], '', $content );
	$items = explode( '/', $content );
	$post_id = intval( $items[0] );
	array_shift( $items );
	$field_name = join( '/', $items );

	if ( isset( $is_acf ) && function_exists( 'get_field' ) ) {
		$format = apply_filters( 'tatsu_allow_format_field_value', true );
		$content = get_field( $field_name, $post_id, $format );
	} else if ( isset( $is_wp ) ) {
		if ( function_exists( $field_name ) && is_callable( $field_name ) ) {
			$content = tatsu_parse_wp_functions( $field_name, $post_id );
		}
	}

	return $content;
} );

/**
 * Shortcode output.
 * 
 * @return string
 */
add_shortcode( 'tatsu_dynamic_field', function( $atts ) {
	$attributes = shortcode_atts( array(
        'data' => '',
    ), $atts );

	return tatsu_parse_custom_fields( $attributes['data'] );
} )

?>