<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       http://example.com
 * @since      1.0.0
 *
 * @package    Tatsu_Pro
 * @subpackage Tatsu_Pro/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Tatsu_Pro
 * @subpackage Tatsu_Pro/admin
 * @author     Your Name <email@example.com>
 */
class Tatsu_Pro_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $tatsu_pro    The ID of this plugin.
	 */
	private $tatsu_pro;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $tatsu_pro       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $tatsu_pro, $version ) {

		$this->tatsu_pro = $tatsu_pro;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Tatsu_Pro_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Tatsu_Pro_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style( $this->tatsu_pro, plugin_dir_url( __FILE__ ) . 'css/tatsu-pro-admin.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Tatsu_Pro_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Tatsu_Pro_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_script( $this->tatsu_pro, plugin_dir_url( __FILE__ ) . 'js/tatsu-pro-admin.js', array( 'jquery' ), $this->version, false );

	}

}
