<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              http://example.com
 * @since             1.0.0
 * @package           Tatsu_Pro
 *
 * @wordpress-plugin
 * Plugin Name:       Tatsu Pro
 * Plugin URI:        https://www.brandexponents.com
 * Description:       A Powerful and Elegant Live Front End Website Builder for Wordpress.
 * Version:           1.0.5
 * Author:            Brand Exponents
 * Author URI:        https://www.brandexponents.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       tatsu-pro
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}
if ( ! defined( 'TATSU_PRO_PLUGIN_FILE' ) ) {
	define('TATSU_PRO_PLUGIN_FILE', plugin_dir_path( __FILE__ ) . 'tatsu-pro.php');
}
if( !defined( 'TATSU_PRO_PLUGIN_DIR' ) ) {
	define( 'TATSU_PRO_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
}
/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'TATSU_PRO_VERSION', '1.0.5' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-tatsu-pro-activator.php
 */
function activate_tatsu_pro() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-tatsu-pro-activator.php';
	Tatsu_Pro_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-tatsu-pro-deactivator.php
 */
function deactivate_tatsu_pro() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-tatsu-pro-deactivator.php';
	Tatsu_Pro_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_tatsu_pro' );
register_deactivation_hook( __FILE__, 'deactivate_tatsu_pro' );

function tatsu_pro_require_tatsu_admin_notice() {
	if(!class_exists('Tatsu')){
	$class = 'notice notice-error is-dismissible';
	$message = __( 'Please activate Tatsu plugin. Tatsu Pro plugin requires Tatsu plugin to be active. Thanks!', 'tatsu-pro' );
	printf( '<div class="%1$s"><p>%2$s</p></div>', esc_attr( $class ), esc_html( $message ) ); 
	}
}
add_action( 'admin_notices', 'tatsu_pro_require_tatsu_admin_notice' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-tatsu-pro.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_tatsu_pro() {
	$plugin = new Tatsu_Pro();
	$plugin->run();
}
run_tatsu_pro();

require TATSU_PRO_PLUGIN_DIR. 'plugin-update-checker/tatsubuilder-update.php';
$tatsu_update_checker = new TatsubuilderUpdateChecker();