<?php
/**************************************
			TABS
**************************************/
if (!function_exists('spyro_tabs')) {
	function spyro_tabs( $atts, $content, $tag ) {
        $atts = shortcode_atts( array (
        	'content_font_button_set' => '',
			'content_title_font' => '',
			'content_font' => '',
            'nav_font_button_set' => '',
            'nav_tab_title_font' => '',
            'title_color' => '',
            'icon_color' => '',
            'active_icon_color' => '',
            'active_title_color' =>'',
            'active_background_color' => '',
			'style' => 'style1',
			'border_color'	=> '',
			'outer_border_color' => '',
            'margin'        => '',
            'tag_to_use'    => 'h4',
			'animate' => '1',
			'reverse_content' => '',
			'content_title_color' => '',
			'content_color' => '',
			
			'image_alignment' => '',
			'content_title_typography' => '',
			'content_typography' => '',
			
			'nav_box_active_shadow' => '',
			
			'nav_tab_typography' => '',
        	'key' => be_uniqid_base36(true),
        ),$atts, $tag );
        
        extract( $atts );
        $tag = $atts['tag_to_use'];


		$GLOBALS['tabs_cnt'] = 0;
		$tabs_cnt=0;
        $GLOBALS['tabs'] = array();
		$rand = rand();
        $content=do_shortcode( $content );
        $custom_style_tag = be_generate_css_from_atts( $atts, 'spyro_tabs', $key );
		$custom_class_name = 'tatsu-'.$atts['key'];
		$data_animations = be_get_animation_data_atts( $atts );

		$css_id = be_get_id_from_atts( $atts );
		$visibility_classes = be_get_visibility_classes_from_atts( $atts ); 
		
		$animate = ( isset( $animate ) && 1 == $animate  && 'none' != $animation_type ) ? ' tatsu-animate ' : '';

		$tab_class = '';
		$tab_content_holder = '';
		$tab_image_holder = '';
		$tab_nav_holder = '';
		$tab_holder = '';
		
		remove_filter('the_content', 'wpautop');
		remove_filter('the_content', 'wptexturize');
		if($atts['reverse_content'])
		{
			$tab_class = 'reversed';
		}
		// if(empty($nav_tab_title_font))
		// {
		// 	$nav_tab_title_font = 'default';
		// }
		// if(empty($content_title_font))
		// {
		// 	$content_title_font = 'default';
		// }
		// if(empty($content_font))
		// {
		// 	$content_font = 'default';
		// }
		$random = rand(10,99);
		if( is_array( $GLOBALS['tabs'] ) ) {
			foreach( $GLOBALS['tabs'] as $key => $tab ) {
				$tabs_cnt++;
				if($key == 0)
				{
					$activeclass = 'active';
				}
				else
				{
					$activeclass = '';
				}

				$icon_tag = ( ! empty($tab['icon']) && $tab['icon'] != 'none' ) ? '<i class="tab-icon '.$tab['icon'].'"></i>' : "" ;

				$tab_nav_holder .= '<li class="tab-menu-item '.$activeclass.'"> 
                                        <a href="#fragment-'.($key+$random).'" class="'.$activeclass.' '.$nav_tab_title_font.'">
                                         '.$icon_tag.'
                                          <span>'.$tab['title'].'</span>
                                         </a>
                                 	</li>'.$tab['custom_style_tag'];
                $tab_image_holder .= ' <div class="fragment-'.($key+$random).' tab-img-container '.$activeclass.'">
                                                <img class="tab-img" src="'.esc_url($tab['image']).'">
                                            </div>';
                $tab_content_holder .= '<div class="fragment-'.($key+$random).' fancy-tab-text '.$activeclass.'">
                                                    <h4 class="tab-title '.$content_title_font.'">'.$tab['content_title'].'</h4>
                                                    <div class="tab-content '.$content_font.'">'.$tab['content'].'</div>
                                                </div>';
			}

		}

		ob_start();
		?>

                                
		<div class="spyro-fancy-tabs <?php echo $tab_class .' '.$custom_class_name; ?>">
			<div class="fancy-tabs-content">
				<div class="tabs-text-block">
					<div class="fancy-tab-text-container">
						<?php echo $tab_content_holder; ?>
					</div>
					<ul class="fancy-tabs-navigation">
						<?php echo $tab_nav_holder; ?>
					</ul>
				</div>
				<div class="tabs-img-block">
					<?php echo $tab_image_holder; ?>
				</div>
			</div>
        </div> 

         <?php echo $custom_style_tag; ?>
       
		<?php
		return ob_get_clean();
		
	}

	//add_shortcode( 'tabs', 'spyro_tabs' );

}

if (!function_exists('spyro_tab')) {
	function spyro_tab( $atts, $content ){
		$atts = shortcode_atts( array(
	        'icon' => '',
			'title' => '',
			'image' => '',
			'reverse_content' => '',
			'content_title' => '',
			'key' => be_uniqid_base36(true),
		),$atts );
		
		$custom_style_tag = be_generate_css_from_atts( $atts, 'spyro_tab', $atts['key'] );
		$custom_class_name = 'tatsu-'.$atts['key'];

		extract( $atts );

		$title = tatsu_parse_custom_fields( $title );
		$content_title = tatsu_parse_custom_fields( $content_title );
		$content = do_shortcode( $content );

		$x = $GLOBALS['tabs_cnt'];
		$GLOBALS['tabs'][$x] = array( 'image' => $image, 'title' => sprintf( $title, $GLOBALS['tabs_cnt'] ), 'content' =>  $content, 'icon'=> $icon, 'class_name' => $custom_class_name, 'custom_style_tag' => $custom_style_tag , 'reverse_content' => $reverse_content , 'content_title' => $content_title);
		$GLOBALS['tabs_cnt']++;
	}
}

add_action('tatsu_register_modules', 'spyro_register_tabs');
function spyro_register_tabs()
{
	$controls = array(
		'icon' => TATSU_PLUGIN_URL . '/builder/svg/modules.svg#tabs',
		'title' => __('Spyro Fancy Tabs', 'spyro-modules'),
		'is_js_dependant' => true,
		'child_module' => 'spyro_tab',
		'type' => 'multi',
		'initial_children' => 3,
		'is_built_in' => false,
		'category' => 'tab',
		'group_atts' => array(
			array(
				'type'		=> 'tabs',
				'style'		=> 'style1',
				'group'		=> array(
					
					array(
						'type' => 'tab',
						'title' => __('Style', 'spyro-modules'),
						'group'	=> array(
							'style',
							array(
								'type' => 'accordion',
								'active' => array(0),
								'group' => array(
									array(
										'type' => 'panel',
										'title' => __('Tab Navigation', 'spyro-modules'),
										'group' => array(
											array(
												'type'  	=> 'tabs',
												'style'		=> 'style1',
												'group'		=> array(
													array(
														'type'		=> 'tab',
														'title'		=> __('Normal Color', 'spyro-modules'),
														'group'		=> array(
															'title_color',
															'icon_color',
															'border_color',
															
															
														),
													),
													array(
														'type'		=> 'tab',
														'title'		=> __('Active Color', 'spyro-modules'),
														'group'		=> array(
															'active_title_color',
															'active_background_color',
															'active_icon_color',
															
														),
													),
												),
											),
											'nav_font_button_set',
											'nav_tab_typography',
											'nav_tab_title_font',
											'nav_box_active_shadow',
										)
									),
									array(
										'type' => 'panel',
										'title' => __('Tab Content', 'spyro-modules'),
										'group' => array(
											'content_title_color',
											'content_color',
											'content_font_button_set',
											'content_title_typography',
											'content_typography',
											'content_title_font',
											'content_font'
										)
									),
									array(
										'type' => 'panel',
										'title' => __('Alignment', 'spyro-modules'),
										'group' => array(
											'reverse_content',
											
											'image_alignment',
										)
									),
									
									
								),
							),
						),
					),
					array(
						'type' => 'tab',
						'title' => __('Advanced', 'spyro-modules'),
						'group'	=> array(
							array(
								'type' => 'accordion',
								'active' => array(0),
								'group' => array(
									array(
										'type' => 'panel',
										'title' => __('Border', 'spyro-modules'),
										'group' => array(
											'border_style',
											'border',
											'outer_border_color'
										)
									),
								)
							)
						)
					)
				)
			)
		),
		'atts' => array_values(array_filter(array(
			/*array(
				'att_name' => 'style',
				'type' => 'select',
				'is_inline' => true,
				'label' => __('Style', 'spyro-modules'),
				'options' => array(
					'style1' 	=> 'Style 1',
					'style2' 	=> 'Style 2',
					'style3' 	=> 'Style 3',
					'style4' 	=> 'Style 4',
				),
				'default' => 'style1',
				'tooltip' => ''
			),*/
			array(
				'att_name' => 'reverse_content',
				'type' => 'switch',
				'label' => __('Reverse Columns', 'spyro-modules'),
				'default' => 0,
				'tooltip' => '',
			),




			array(
				'att_name' => 'title_color',
				'type' => 'color',
				'label' => __('Title', 'spyro-modules'),
				'default' => '#343638',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-fancy-tabs .fancy-tabs-content .tabs-text-block .fancy-tabs-navigation .tab-menu-item a span' => array(
						'property' => 'color',
					),
				),
			),

			array(
				'att_name' => 'icon_color',
				'type' => 'color',
				'label' => __('Icon', 'spyro-modules'),
				'default' => '#2293D7',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-fancy-tabs .fancy-tabs-content .tabs-text-block .fancy-tabs-navigation .tab-menu-item a i' => array(
						'property' => 'color',
					),
				),
			),
			array(
				'att_name' => 'active_icon_color',
				'type' => 'color',
				'label' => __('Icon', 'spyro-modules'),
				'default' => '#2293D7',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-fancy-tabs .fancy-tabs-content .fancy-tabs-navigation .tab-menu-item.active a i' => array(
						'property' => 'color',
					),
				),
			),
			
			array(
				'att_name' => 'active_title_color',
				'type' => 'color',
				'label' => __('Title', 'spyro-modules'),
				'default' => '#343638',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-fancy-tabs .fancy-tabs-content .tabs-text-block .fancy-tabs-navigation .tab-menu-item.active a span' => array(
						'property' => 'color',
					),
				),
			),
			array(
				'att_name' => 'active_background_color',
				'type' => 'color',
				'label' => __('Background', 'spyro-modules'),
				'default' => '#fff',
				'tooltip' => '',
				
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-fancy-tabs .fancy-tabs-content .tabs-text-block .fancy-tabs-navigation .tab-menu-item.active' => array(
						'property' => 'background',
						
					),
				),
			),
			 array(
                'att_name' => 'tag_to_use',
                'type' => 'select',
                'label' => __('Tag to use for title', 'spyro-modules'),
                'options' => array(
                    'h1' => 'H1',
                    'h2' => 'H2',
                    'h3' => 'H3',
                    'h4' => 'H4',
                    'h5' => 'H5',
                    'h6' => 'H6',
                    'p' => 'P',
                    'span' => 'Span',
                    'div' => 'Div',
                ),
                'default' => 'h4',
                'tooltip' => '',
			),
			array(
				'att_name' => 'content_title_color',
				'type' => 'color',
				'label' => __('Title', 'spyro-modules'),
				'default' => '#343638',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-fancy-tabs .fancy-tabs-content .tabs-text-block .fancy-tab-text-container .fancy-tab-text .tab-title' => array(
						'property' => 'color'
					),
				)
			),

			array(
				'att_name' => 'content_color',
				'type' => 'color',
				'label' => __('Content', 'spyro-modules'),
				'default' => '#77797D',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-fancy-tabs .fancy-tabs-content .tabs-text-block .fancy-tab-text-container .fancy-tab-text .tab-content' => array(
						'property' => 'color'
					),
				),
			),
			
			array(
				'att_name' => 'image_alignment',
				'type' => 'button_group',
				'is_inline' => false,
				'label' => __('Image Align', 'spyro-modules'),
				'options' => array(
					'flex-start' => 'Top',
					'center' => 'Middle',
					'flex-end' => 'Bottom'
				),
				'responsive' => true,
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-fancy-tabs .fancy-tabs-content .tabs-img-block' => array(
						'property' => 'align-items',
					),
				),
				'default' => 'center',
				'tooltip' => ''
			),
			array (
                'att_name' => 'content_font_button_set',
                'type' => 'button_group',
                'label' => __( 'Typography', 'spyro-modules' ),
                'options' => array (
                    'type_hub' => 'Type Hub',
                    'custom_font' => 'Custom ',
                ),
                'default' => 'type_hub',
				'tooltip' => '',
				'is_inline' => true,
			),
			array(
				'att_name' => 'content_title_typography',
				'type' => 'typography',
				'label' => __( 'TItle', 'spyro-modules' ),
				'responsive' => true,
				'default' => '',
				'tooltip' => '',
				'css' => true,
				'is_inline' => true,
				'visible' => array('content_font_button_set', '==', 'custom_font'),
				'selectors' => array(
					'.tatsu-{UUID}.spyro-fancy-tabs .fancy-tabs-content .tabs-text-block .fancy-tab-text-container .fancy-tab-text .tab-title' => array(
						'property' => 'typography',
					)
				),
			),
			function_exists('spyro_get_exposed_selectors') ? array(
				'att_name'	=> 'content_title_font',
				'type'		=> 'select',
				'label'		=> esc_html__('Title ', 'spyro-modules'),
				'options'	=> spyro_get_exposed_selectors(),
				'default'	=> 'default',
				'visible' => array('content_font_button_set', '==', 'type_hub'),
				'tooltip'	=> ''
			) : false,

			array(
				'att_name' => 'content_typography',
				'type' => 'typography',
				'label' => __( 'Content', 'spyro-modules' ),
				'responsive' => true,
				'default' => '',
				'tooltip' => '',
				'css' => true,
				'is_inline' => true,
				'visible' => array('content_font_button_set', '==', 'custom_font'),
				'selectors' => array(
					'.tatsu-{UUID}.spyro-fancy-tabs .fancy-tabs-content .tabs-text-block .fancy-tab-text-container .fancy-tab-text .tab-content' => array(
						'property' => 'typography',
					)
				),
			),
			function_exists('spyro_get_exposed_selectors') ? array(
				'att_name'	=> 'content_font',
				'type'		=> 'select',
				'label'		=> esc_html__('Content ', 'spyro-modules'),
				'options'	=> spyro_get_exposed_selectors(),
				'default'	=> 'default',
				'visible' => array('content_font_button_set', '==', 'type_hub'),
				'tooltip'	=> ''
			) : false,

		
			array(
				'att_name' => 'nav_box_active_shadow',
				'type' => 'input_box_shadow',
				'label' => __('Active Box Shadow', 'spyro-modules'),
				'default' => '0px 0px 15px 0px rgba(34, 90, 255, 0.1)',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-fancy-tabs .fancy-tabs-content .tabs-text-block .fancy-tabs-navigation .tab-menu-item.active' => array(
						'property' => 'box-shadow',
						'when' => array('nav_box_active_shadow', '!=', '0px 0px 0px 0px rgba(0,0,0,0)'),
					),
				),
			),
			array (
                'att_name' => 'nav_font_button_set',
                'type' => 'button_group',
                'label' => __( 'Typography', 'spyro-modules' ),
                'options' => array (
                    'type_hub' => 'Type Hub',
                    'custom_font' => 'Custom ',
                ),
                'default' => 'type_hub',
				'tooltip' => '',
				'is_inline' => true,
			),
			array(
				'att_name' => 'nav_tab_typography',
				'type' => 'typography',
				'label' => __( 'Title ', 'spyro-modules' ),
				'responsive' => true,
				'default' => '',
				'tooltip' => '',
				'css' => true,
				'is_inline' => true,
				'visible' => array('nav_font_button_set', '==', 'custom_font'),
				'selectors' => array(
					'.tatsu-{UUID}.spyro-fancy-tabs .fancy-tabs-content .tabs-text-block .fancy-tabs-navigation .tab-menu-item a' => array(
						'property' => 'typography',
					)
				),
			),	
			function_exists('spyro_get_exposed_selectors') ? array(
				'att_name'	=> 'nav_tab_title_font',
				'type'		=> 'select',
				'label'		=> esc_html__('Title ', 'spyro-modules'),
				'options'	=> spyro_get_exposed_selectors(),
				'default'	=> 'default',
				'visible' => array('nav_font_button_set', '==', 'type_hub'),
				'tooltip'	=> ''
			) : false,

			
			
			// array(
			// 	'att_name' => 'border_color',
			// 	'type'	   => 'color',
			// 	'label'		=> __('Border Color', 'spyro-modules'),
			// 	'default'	=> '#d8d8d8',
			// 	'tooltip'	=> '',
			// 	'visible'	=> array(
			// 		'style', '=', 'style1'
			// 	),
			// 	'css'	=> true,
			// 	'selectors'	=> array(
			// 		'.tatsu-{UUID}.spy-tabs.spy-tabs-vertical ul.be-tab-header.left li a' => array(
			// 			'property'	=> 'border-color',
			// 			'when'		=> array(
			// 				'style', '=', 'style1'
			// 			),
			// 		),
			// 	),
			// ),
			array (
				'att_name' => 'outer_border_color',
				'type' => 'color',
				'label' => __( 'Border Color', 'spyro-modules' ),
				'default' => '',
				'exclude' => array( 'tatsu_image', 'tatsu_lists', 'tatsu_call_to_action' ),
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}' => array(
						'property' => 'border-color',
						'when' => array('border', '!=', '0px 0px 0px 0px'),
					),
				),
			),
			array (
				'att_name' => 'border_style',
				'type' => 'select',
				'label' => __( 'Border Style', 'spyro-modules' ),
				'options' => array(
					'none' => 'None',
					'solid' => 'Solid',
					'dashed' => 'Dashed',
					'double' => 'Double',
					'dotted' => 'Dotted',
				),
				'default' => array( 'd' => 'solid', 'l' => 'solid', 't' => 'solid', 'm' => 'solid' ),
				'tooltip' => '',
				'css' => true,
				'responsive' => true,
				'selectors' => array(
					'.tatsu-{UUID}' => array(
						'property' => 'border-style',
						'when' => array(
							array( 'border', '!=', array( 'd' => '0px 0px 0px 0px' ) ),
							array( 'border', 'notempty' ),
							array( 'border_style', '!=', array( 'd' => 'none' ) ),
						),
						'relation' => 'and',            
					),
				),
			),
			array (
				'att_name' => 'border',
				'type' => 'input_group',
				'label' => __( 'Border Width', 'spyro-modules' ),
				'default' => '0px 0px 0px 0px',
				'tooltip' => '',
				'responsive' => true,
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}' => array(
						'property' => 'border-width',
						'when' => array( 'border', '!=', array( 'd' => '0px 0px 0px 0px' ) ),
					),
				),
			),
		))),
		'presets' => array(
			'default' => array(
				'title' => '',
				'image' => '',
				'preset' => array(
					'style'		=> 'style1',
					
					
				),
			)
		),


	);
	tatsu_remap_modules(array('spyro_tabs' , 'tabs'), $controls, 'spyro_tabs');

	//tatsu_register_module( 'spyro_tabs', $controls );
}

add_action('tatsu_register_modules', 'spyro_register_tab');
function spyro_register_tab()
{
	$controls = array(
		'icon' => '',
		'title' => __('Tab', 'spyro-modules'),
		'child_module' => '',
		'type' => 'sub_module',
		'is_built_in' => false,
		'is_dynamic' => true,
		'hint' => 'title',
		'group_atts' => array(
			array(
				'type'		=> 'tabs',
				'style'		=> 'style1',
				'group'		=> array(
					array(
						'type' => 'tab',
						'title' => __('', 'spyro-modules'),
						'group'	=> array(
							'title',
							'icon',
							'content_title',
							'content',
							'image'
							
						)
					),
					
				),
			)
		),
		'atts' => array(
			array(
				'att_name' => 'title',
				'type' => 'text',
				'label' => __('Title', 'spyro-modules'),
				'default' => 'Deep website ',
				'tooltip' => ''
			),
			array(
				'att_name' => 'icon',
				'type' => 'icon_picker',
				'label' => __('Icon', 'spyro-modules'),
				'default' => '',
				'tooltip' => ''
			),
			array(
				'att_name' => 'content_title',
				'type' => 'text',
				'label' => __('Content Title', 'spyro-modules'),
				'default' => '',
				'tooltip' => ''
			),
			array(
				'att_name' => 'content',
				'type' => 'tinymce',
				'label' => __('Content', 'spyro-modules'),
				'default' => '',
				'tooltip' => ''
			),
			array(
				'att_name' => 'image',
				'type' => 'single_image_picker',
				'label' => __('Image', 'spyro-modules'),
				'tooltip' => '',
				'default' => TATSU_PLUGIN_URL . '/img/image-placeholder.jpg'
			),
			
		),
		'presets' => array(
			'default' => array(
				'title' => '',
				'image' => '',
				'content_title' => '',
				'preset' => array(
					'content_title' => 'Bring back productivity with a new style',
					'title' => 'Deep Website Audit Solution',
					'icon' => 'tab-icon tatsu-icon-search',
					'content' => 'Get started swiftly & easily by importing a demo of your choice in a single click. Over 30 high quality professionally designed pre-built website concepts to choose from.'
				),
			)
		),
	);
	tatsu_remap_modules(array('spyro_tab', 'tab'), $controls, 'spyro_tab');
}

?>