<?php
/**************************************
			TABS
**************************************/
if (!function_exists('spyro_advance_tabs')) {
	function spyro_advance_tabs( $atts, $content, $tag ) {
        $atts = shortcode_atts( array (
            'nav_font_button_set' => '',
            'content_font_button_set' => '',
            'title_color' => '',
            'icon_color' => '',
            'active_icon_color' => '',
            'active_title_color' =>'',
            'active_background_color' => '',
            'tab_normal_background_color' => '',
            'margin'        => '',
            'tag_to_use'    => 'h4',
            'content_title_font'    => '',
            'content_font'    => '',
            'feature_font'    => '',
			'animate' => '1',
			'content_title_color' => '',
			'content_color' => '',
			'content_title_typography' => '',
			'content_typography' => '',
			'btn_text' => '',
			'nav_box_shadow' => '',
			'nav_tab_typography' => '',
			'nav_tab_font' => '',
			'feature_icon_color' => '',
			'feature_color' => '',
			'feature_typography' => '',
			'tab_alignment' => '',
			'image_offset' => '',
			'type' => '',
			'button_style'=> '',
			'bg_color' => '',
			'color' => '',
			'hover_bg_color' => '',
			'hover_color' => '',
			
        	'key' => be_uniqid_base36(true),
        ),$atts, $tag );
        
        extract( $atts );
        $tag = $atts['tag_to_use'];

		$GLOBALS['tabs_cnt'] = 0;
		$tabs_cnt=0;
        $GLOBALS['tabs'] = array();
		$rand = rand();
        $content=do_shortcode( $content );
        $custom_style_tag = be_generate_css_from_atts( $atts, 'spyro_advance_tabs', $key );
		$custom_class_name = 'tatsu-'.$atts['key'];
		$data_animations = be_get_animation_data_atts( $atts );

		$css_id = be_get_id_from_atts( $atts );
		$visibility_classes = be_get_visibility_classes_from_atts( $atts ); 
		
		$animate = ( isset( $animate ) && 1 == $animate  && 'none' != $animation_type ) ? ' tatsu-animate ' : '';

		$tab_class = '';
		$tab_content_holder = '';
		$tab_holder = '';
		ob_start();

		remove_filter('the_content', 'wpautop');
		remove_filter('the_content', 'wptexturize');

		// if(empty($nav_tab_font))
		// {
		// 	$nav_tab_font = 'default';
		// }
		// if(empty($content_title_font))
		// {
		// 	$content_title_font = 'default';
		// }
		// if(empty($content_font))
		// {
		// 	$content_font = 'default';
		// }
		// if(empty($feature_font))
		// {
		// 	$feature_font = 'default';
		// }
		$button_style = ( isset( $button_style ) && !empty( $button_style ) ) ? $button_style : '';
		
		
		?>

                                
		<div <?php echo $css_id; ?> class="tatsu-icon_card-type-svg spyro-tabs <?php echo $custom_class_name . ' '.$visibility_classes; ?>">

			<div class="tabs-navigation <?php echo $tab_alignment; ?>">
                <ul>
                	<?php
                	$random = rand(10,99);
            	if( is_array( $GLOBALS['tabs'] ) ) {
			
				foreach( $GLOBALS['tabs'] as $key => $tab ) {
				$tabs_cnt++;
				if($key == 0)
				{
					$activeclass = 'active';
				}
				else
				{
					$activeclass = '';
				}
				// print_r($tab['svg_icon']);
				// die;
				$icon_tag = ( ! empty($tab['icon']) && $tab['icon'] != 'none' ) ? '<i class="tab-icon '.$tab['icon'].'"></i>' : "" ;
				$svg_icon_html = function_exists( 'tatsu_get_svg_icon' ) ? tatsu_get_svg_icon( $tab['svg_icon'] ) : '';
				
				?>
                    <li class="<?php echo $tab['class_name']; ?>">
                    	<a href="#fragment-<?php echo $key+$random ?>" class="<?php echo $activeclass ." ".$nav_tab_font; ?>">
                    		<?php
                    		if( 'svg' === $tab['icon_type'] ) {
					            
					           echo $svg_icon_html;
    						} 
    						else if('icon' === $tab['icon_type'])
    						{
    							echo $icon_tag;
    						}
    						else if('image' === $tab['icon_type'])
    						{
    							echo '<div class="spyro-icon_card-image">
                                       </div>';
    						}
                    		?>
                    		
                    		<span><?php echo $tab['title']; ?></span>
                    	</a>
                    </li>
                <?php echo $tab['custom_style_tag']; } } ?>
                </ul>
            </div>
            <div class="tabs-container">
            	<?php 
			if( is_array( $GLOBALS['tabs'] ) ) {
			
			foreach( $GLOBALS['tabs'] as $key => $tab ) {
				$tabs_cnt++;
				if($key == 0)
				{
					$activeclass = 'active';
				}
				else
				{
					$activeclass = '';
				}
			?>
            	 <div id="fragment-<?php echo $key+$random ?>" class="tabs-content clearfix <?php echo $activeclass; ?>">
                    <div class="tab-img-wrap">
                        <img class="tab-img" alt=" " src="<?php echo esc_url($tab['image']) ?>">
                     </div>
                    <div class="tab-text-container">
                       <h4 class="tab-title <?php echo $content_title_font; ?>"><?php echo esc_html($tab['content_title']); ?></h4>
                       <div class="tab-content <?php echo $content_font; ?>"> <?php echo $tab['content'] ?> </div>
                       <?php
                       $feature  = array_filter(explode("\n",$tab['feature_items']));
                       if(is_array($feature) && !empty($feature))
                       { 
                       	$icon_tag = ( ! empty($tab['feature_icon']) && $tab['feature_icon'] != 'none' ) ? '<i class="tab-icon '.$tab['feature_icon'].'"></i>' : "" ;
                       ?>
                       <ul class="tab-feature-items">
                       	<?php
	                   	 foreach( $feature as  $val )
	       				 { 
                       	?>
                            <li> <?php echo $icon_tag; ?> <span class="feature-item <?php echo $feature_font; ?>"><?php echo $val; ?></span> </li>
                     	<?php } ?>
                       </ul>
                      <?php } ?>
                      
                      
                       <?php
            	// 
	            	if($type == 'block')
	            	{
	            		$align = 'align-block';
	            	}
	            	else
	            	{
	            		$align = '';
	            	}
	            	?>
	             <div class="tatsu-module tatsu-normal-button tatsu-button-wrap <?php echo $align; ?>">
	             	<a class="tatsu-shortcode <?php echo $type.'btn'; ?> tatsu-button left-icon  <?php echo $button_style; ?>" href="<?php echo esc_url($tab['btn_url']); ?>" style="" aria-label="Click Here" data-gdpr-atts="{}"><?php echo esc_html($tab['btn_text']); ?></a>
	             </div>
                    </div>
                 </div>
             <?php } } ?>
            </div>
         </div> 

         <?php echo $custom_style_tag; ?>
       
		<?php
		return ob_get_clean();
		
	}

	//add_shortcode( 'tabs', 'spyro_advance_tabs' );

}

if (!function_exists('spyro_advance_tab')) {
	function spyro_advance_tab( $atts, $content ){
		$atts = shortcode_atts( array(
	        'icon' => '',
	        'icon_type' => '',
	        'svg_icon' => '',
	        'icon_image' => '',
	        'icon_active_image' => '',
	        'icon_image_bg_size' => '',
			'title' => '',
			'image' => '',
			'content_title' => '',
			'feature_items' => '',
			'feature_icon' => '',
			'btn_text' => '',
			'btn_url' => '',
			'key' => be_uniqid_base36(true),
		),$atts );
		
		$custom_style_tag = be_generate_css_from_atts( $atts, 'spyro_advance_tab', $atts['key'] );
		$custom_class_name = 'tatsu-'.$atts['key'];

		extract( $atts );

		$title = tatsu_parse_custom_fields( $title );
		$content_title = tatsu_parse_custom_fields( $content_title );
		$btn_text = tatsu_parse_custom_fields( $btn_text );
		$btn_url = tatsu_parse_custom_fields( $btn_url );

		$content = do_shortcode( $content );
		$x = $GLOBALS['tabs_cnt'];
		$icon_active_images = empty($icon_active_images)?'':$icon_active_images;
		$GLOBALS['tabs'][$x] = array( 'image' => $image, 'title' => sprintf( $title, $GLOBALS['tabs_cnt'] ), 'content' =>  $content, 'icon'=> $icon, 'class_name' => $custom_class_name, 'custom_style_tag' => $custom_style_tag , 'feature_items' => $feature_items , 'content_title' => $content_title , 'feature_icon' => $feature_icon , 'btn_text' => $btn_text , 'btn_url' => $btn_url ,
			'icon_type' => $icon_type,
			'svg_icon' => $svg_icon,
			'icon_image' => $icon_image,
			'icon_active_images' => $icon_active_images,

			);
		$GLOBALS['tabs_cnt']++;
	}
}

add_action('tatsu_register_modules', 'spyro_register_advance_tabs');
function spyro_register_advance_tabs()
{
	$controls = array(
		'icon' => TATSU_PLUGIN_URL . '/builder/svg/modules.svg#tabs',
		'title' => __('Spyro Advanced Tabs', 'spyro-modules'),
		'is_js_dependant' => true,
		'child_module' => 'spyro_advance_tab',
		'type' => 'multi',
		'initial_children' => 3,
		'is_built_in' => false,
		'category' => 'tab',
        'group_atts' => array(
			array(
				'type'		=> 'tabs',
				'style'		=> 'style1',
				'group'		=> array(
					
					array(
						'type' => 'tab',
						'title' => __('Style', 'spyro-modules'),
						'group'	=> array(
							'style',
							
							array(
								'type' => 'accordion',
								'active' => array(0),
								'group' => array(
									// array(
									// 	'type' => 'panel',
									// 	'title' => __('Colors', 'spyro-modules'),
									// 	'group' => array(
									// 		'color_button_set',
									// 		'title_color',
									// 						'icon_color',
									// 	)
									// ),
									array(
										'type' => 'panel',
										'title' => __('Tab Navigation', 'spyro-modules'),
										'group' => array(
											'tab_alignment',
											array(
												'type'  	=> 'tabs',
												'style'		=> 'style1',
												'group'		=> array(
													array(
														'type'		=> 'tab',
														'title'		=> __('Normal Color', 'spyro-modules'),
														'group'		=> array(
															'title_color',
															'icon_color',
															'tab_normal_background_color',
															
														),
													),
													array(
														'type'		=> 'tab',
														'title'		=> __('Active Color', 'spyro-modules'),
														'group'		=> array(
															'active_title_color',
															'active_background_color',
															'active_icon_color',
														),
													),
												),
											),
											
											'nav_font_button_set',
											'nav_tab_font',
											'nav_tab_typography',
											'nav_box_shadow',

											
											
										)
									),
									array(
										'type' => 'panel',
										'title' => __('Tab Content Color', 'spyro-modules'),
										'group' => array(
											'content_title_color',
											'content_color',
											'feature_color',
											'feature_icon_color',
											
										)
									),
									array(
										'type' => 'panel',
										'title' => __('Tab Content Typography', 'spyro-modules'),
										'group' => array(
											
											'content_font_button_set',
											'content_title_font',
											'content_font',
											'feature_font',
											'tag_to_use',
											'content_title_typography',
											'content_typography',
											'feature_typography',
										)
									),
									
								array(
										'type' => 'panel',
										'title' => __('Button Style', 'spyro-modules'),
										'group' => array(
													'type',
													'button_style',
										)
									),
									array(
										'type' => 'panel',
										'title' => __('Button Colors', 'spyro-modules'),
										'group' => array(
													array(
												'type'  	=> 'tabs',
												'style'		=> 'style1',
												'group'		=> array(
													array(
														'type'		=> 'tab',
														'title'		=> esc_html__('Normal', 'spyro-modules'),
														'group'		=> array(
															'bg_color',
															'color',
															
															
														),
													),
													array(
														'type'		=> 'tab',
														'title'		=> esc_html__('Hover', 'spyro-modules'),
														'group'		=> array(
															'hover_bg_color',
															'hover_color',
														),
													),
												),
											),
		                                            

										)
									),

									// array(
									// 	'type' => 'panel',
									// 	'title' => __('Tab Content Alignment and Width', 'spyro-modules'),
									// 	'group' => array(
									// 		'image_alignment',
											
											
											
											
											
											
									// 	)
									// ),
									
								),
							),
						),
					),
					array(
						'type' => 'tab',
						'title' => __('Advanced', 'spyro-modules'),
						'group'	=> array(
							array(
								'type' => 'accordion',
								'active' => array(0),
								'group' => array(
									array(
										'type' => 'panel',
										'title' => __('Border', 'spyro-modules'),
										'group' => array(
											
											
											
										)
									),
								)
							)
						)
					)
				)
			)
		),
		'atts' => array_values(array_filter(array(
			/*array(
				'att_name' => 'style',
				'type' => 'select',
				'is_inline' => true,
				'label' => __('Style', 'spyro-modules'),
				'options' => array(
					'style1' 	=> 'Style 1',
					'style2' 	=> 'Style 2',
					'style3' 	=> 'Style 3',
					'style4' 	=> 'Style 4',
				),
				'default' => 'style1',
				'tooltip' => ''
			),*/

		
			
			array(
				'att_name' => 'title_color',
				'type' => 'color',
				'label' => __('Title', 'spyro-modules'),
				'default' => '#343638',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-tabs  ul li a span' => array(
						'property' => 'color',
					),
				),
			),

			array(
				'att_name' => 'icon_color',
				'type' => 'color',
				'label' => __('Icon', 'spyro-modules'),
				'default' => '#2293D7',
				'tooltip' => 'This option only work when you choose Icon type as "icon" or "svg"',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-tabs  ul li a i , .tatsu-{UUID}.spyro-tabs .tabs-navigation ul li a svg' => array(
						'property' => 'color',
					),
				),
			),

			// array(
			// 	'att_name'	=> 'svg_icon_color',
			// 	'type' => 'color',
				
			// 	'label' => esc_html__('Svg Icon Color', 'spyro-modules'),
			// 	'default' => '',
			// 	'tooltip' => '',
			// 	'css'	  => true,
			// 	'selectors'	=> array(
			// 		'.tatsu-{UUID}.spyro-tabs .tabs-navigation ul li a svg' => array(
			// 			'property'		=> 'color'
						
			// 		)
			// 	)
			// ),

			array(
				'att_name' => 'tab_normal_background_color',
				'type' => 'color',
				'label' => __('Background', 'spyro-modules'),
				'default' => '#fff',
				'tooltip' => '',
				
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-tabs .tabs-navigation ul li a' => array(
						'property' => 'background',
					),

					
				),
			),
			array(
				'att_name' => 'active_icon_color',
				'type' => 'color',
				'label' => __('Icon', 'spyro-modules'),
				'default' => '#fff',
				'tooltip' => 'This option only work when you choose Icon type as "icon" or "svg"',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-tabs .tabs-navigation ul li a.active i , .tatsu-{UUID}.spyro-tabs .tabs-navigation ul li a.active svg' => array(
						'property' => 'color',
					),
				),
			),
			
			array(
				'att_name' => 'active_title_color',
				'type' => 'color',
				'label' => __('Title', 'spyro-modules'),
				'default' => '#fff',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-tabs .tabs-navigation ul li a.active span' => array(
						'property' => 'color',
					),
				),
			),

			
			array(
				'att_name' => 'active_background_color',
				'type' => 'color',
				'label' => __('Background', 'spyro-modules'),
				'default' => '#2293D7',
				'tooltip' => '',
				
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-tabs .tabs-navigation ul li a.active' => array(
						'property' => 'background',
					),

					'.tatsu-{UUID}.spyro-tabs .tabs-navigation ul li a.active::after' => array(
						'property' => 'border-top-color',
					),
				),
			),
			

			//  array(
   //              'att_name' => 'tag_to_use',
   //              'type' => 'select',
   //              'label' => __('Tag to use for title', 'spyro-modules'),
   //              'options' => array(
   //                  'h1' => 'H1',
   //                  'h2' => 'H2',
   //                  'h3' => 'H3',
   //                  'h4' => 'H4',
   //                  'h5' => 'H5',
   //                  'h6' => 'H6',
   //                  'p' => 'P',
   //                  'span' => 'Span',
   //                  'div' => 'Div',
   //              ),
   //              'default' => 'h4',
   //              'tooltip' => '',
			// ),
			array(
				'att_name' => 'content_title_color',
				'type' => 'color',
				'label' => __('Title', 'spyro-modules'),
				'default' => '#343638',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-tabs .tabs-container .tabs-content .tab-text-container .tab-title' => array(
						'property' => 'color'
					),
				)
			),

			array(
				'att_name' => 'content_color',
				'type' => 'color',
				'label' => __('Content', 'spyro-modules'),
				'default' => '#77797D',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-tabs .tabs-container .tabs-content .tab-text-container .tab-content' => array(
						'property' => 'color'
					),
				),
			),
			array(
				'att_name' => 'feature_color',
				'type' => 'color',
				'label' => __('List', 'spyro-modules'),
				'default' => '#343638',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-tabs .tabs-container .tabs-content .tab-text-container .tab-feature-items li span.feature-item' => array(
						'property' => 'color'
					),
				),
			),
			array(
				'att_name' => 'feature_icon_color',
				'type' => 'color',
				'label' => __('List Icon', 'spyro-modules'),
				'default' => '#2293D7',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-tabs .tabs-container .tabs-content .tab-text-container .tab-feature-items li i' => array(
						'property' => 'color'
					),
				),
			),
			
			array(
                'att_name' => 'content_font_button_set',
                'type' => 'button_group',
                'label' => __( 'Typography', 'spyro-modules' ),
                'options' => array (
                    'type_hub' => 'Type Hub',
                    'custom_font' => 'Custom',
                ),
                'default' => 'type_hub',
				'tooltip' => '',
				'is_inline' => true,
			),
			array(
				'att_name' => 'content_title_typography',
				'type' => 'typography',
				'label' => __( 'TItle', 'spyro-modules' ),
				'responsive' => true,
				'default' => '',
				'tooltip' => '',
				'css' => true,
				'visible' => array('content_font_button_set', '==', 'custom_font'),
				'is_inline' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-tabs .tabs-container .tabs-content .tab-text-container .tab-title' => array(
						'property' => 'typography',
					)
				),
			),
			array(
				'att_name' => 'content_typography',
				'type' => 'typography',
				'label' => __( 'Content  ', 'spyro-modules' ),
				'responsive' => true,
				'default' => '',
				'tooltip' => '',
				'css' => true,
				'is_inline' => true,
				'visible' => array('content_font_button_set', '==', 'custom_font'),
				'selectors' => array(
					'.tatsu-{UUID}.spyro-tabs .tabs-container .tabs-content .tab-text-container .tab-content' => array(
						'property' => 'typography',
					)
				),
			),
			array(
				'att_name' => 'feature_typography',
				'type' => 'typography',
				'label' => __( 'Feature ', 'spyro-modules' ),
				'responsive' => true,
				'default' => '',
				'tooltip' => '',
				'css' => true,
				'visible' => array('content_font_button_set', '==', 'custom_font'),
				'is_inline' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-tabs .tabs-container .tabs-content .tab-text-container .tab-feature-items li span.feature-item' => array(
						'property' => 'typography',
					)
				),
			),
			function_exists('spyro_get_exposed_selectors') ? array(
				'att_name'	=> 'content_title_font',
				'type'		=> 'select',
				'label'		=> esc_html__('Title ', 'spyro-modules'),
				'options'	=> spyro_get_exposed_selectors(),
				'default'	=> 'default',
				'visible' => array('content_font_button_set', '==', 'type_hub'),
				'tooltip'	=> ''
			) : false,
			function_exists('spyro_get_exposed_selectors') ? array(
				'att_name'	=> 'content_font',
				'type'		=> 'select',
				'label'		=> esc_html__('Content ', 'spyro-modules'),
				'options'	=> spyro_get_exposed_selectors(),
				'default'	=> 'default',
				'visible' => array('content_font_button_set', '==', 'type_hub'),
				'tooltip'	=> ''
			) : false,
			function_exists('spyro_get_exposed_selectors') ? array(
				'att_name'	=> 'feature_font',
				'type'		=> 'select',
				'label'		=> esc_html__('Feature ', 'spyro-modules'),
				'options'	=> spyro_get_exposed_selectors(),
				'default'	=> 'default',
				'visible' => array('content_font_button_set', '==', 'type_hub'),
				'tooltip'	=> ''
			) : false,

			

		
			array(
				'att_name' => 'nav_box_shadow',
				'type' => 'input_box_shadow',
				'label' => __('Box Shadow', 'spyro-modules'),
				'default' => '0px 20px 60px 0px rgba(0,0,0,0.05)',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-tabs .tabs-navigation ul li a' => array(
						'property' => 'box-shadow',
						'when' => array('nav_box_shadow', '!=', '0px 0px 0px 0px rgba(0,0,0,0)'),
					),
				),
			),
			array(
                'att_name' => 'nav_font_button_set',
                'type' => 'button_group',
                'label' => __( 'Typography', 'spyro-modules' ),
                'options' => array (
                    'type_hub' => 'Type Hub',
                    'custom_font' => 'Custom',
                ),
                'default' => 'type_hub',
				'tooltip' => '',
				'is_inline' => true,
			),
			array(
				'att_name' => 'nav_tab_typography',
				'type' => 'typography',
				'label' => __( 'Tab Title ', 'spyro-modules' ),
				'responsive' => true,
				'default' => '',
				'tooltip' => '',
				'css' => true,
				'is_inline' => true,
				'visible' => array('nav_font_button_set', '==', 'custom_font'),
				'selectors' => array(
					'.tatsu-{UUID}.spyro-tabs .tabs-navigation ul li a' => array(
						'property' => 'typography',
					)
				),
			),	
			function_exists('spyro_get_exposed_selectors') ? array(
				'att_name'	=> 'nav_tab_font',
				'type'		=> 'select',
				'label'		=> esc_html__('Title ', 'spyro-modules'),
				'options'	=> spyro_get_exposed_selectors(),
				'default'	=> 'default',
				'tooltip'	=> '',
				'visible' => array('nav_font_button_set', '==', 'type_hub'),
			) : false,

			array (
                'att_name' => 'tab_alignment',
                'type' => 'button_group',
                'label' => __( 'Alignment', 'spyro-modules' ),
                'options' => array (
                    'fullwidth-alignment' => 'Fullwidth',
                    'center-alignment' => 'Center',
                ),
                'default' => 'center-alignment',
				'tooltip' => '',
				'is_inline' => true,
			),

			// Button Options
			array(
				'att_name' => 'type',
				'is_inline' => true,
				'type' => 'button_group',
				'label' => esc_html__('Size', 'spyro-modules'),
				'options' => array(
					'small' => 'S',
					'medium' => 'M',
					'large' => 'L',
					'x-large' => 'XL',
					'block' => 'Block',
				),
				'default' => 'medium',
				'tooltip' => ''
			),
			array(
				'att_name' => 'button_style',
				'is_inline' => true,
				'type' => 'button_group',
				'label' => esc_html__('Shape', 'spyro-modules'),
				'options' => array(
					'none' => 'Rectangular',
					'rounded' => 'Rounded',
					'circular' => 'Pill'
				),
				'default' => 'none',
				'tooltip' => ''
			),
				array(
				'att_name' => 'bg_color',
				'type' => 'color',
				'label' => esc_html__('Background', 'spyro-modules'),
				'default' => '#2293d7',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-tabs .tabs-container .tabs-content .tab-text-container .tatsu-button-wrap .tatsu-button' => array(
						'property' => 'background-color'
					),
				),
			),
			array(
				'att_name' => 'hover_bg_color',
				'type' => 'color',
				'label' => esc_html__('Background', 'spyro-modules'),
				'default' => '#2293d7',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-tabs .tabs-container .tabs-content .tab-text-container .tatsu-button-wrap .tatsu-button:hover' => array(
						'property' => 'background-color'
					),
				),
			),
			array(
				'att_name' => 'color',
				'type' => 'color',
				'label' => esc_html__('Text', 'spyro-modules'),
				'default' => '#fff',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-tabs .tabs-container .tabs-content .tab-text-container .tatsu-button-wrap .tatsu-button' => array(
						'property' => 'color',
					),
				),
			),
			array(
				'att_name' => 'hover_color',
				'type' => 'color',
				'label' => esc_html__('Text', 'spyro-modules'),
				'default' => '#fff',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-tabs .tabs-container .tabs-content .tab-text-container .tatsu-button-wrap .tatsu-button:hover' => array(
						'property' => 'color',
					),
				),
			),
			
		
			// array(
			// 	'att_name' => 'image_alignment',
			// 	'type' => 'button_group',
			// 	'is_inline' => false,
			// 	'label' => __('Image Align', 'spyro-modules'),
			// 	'options' => array(
			// 		'left' => 'Left',
			// 		'center' => 'Center',
			// 		'right' => 'Right'
			// 	),
			// 	'responsive' => true,
			// 	'css' => true,
			// 	'selectors' => array(
			// 		'.tatsu-{UUID}.spyro-tabs .tabs-container .tabs-content .tab-img-wrap' => array(
			// 			'property' => 'text-align',
			// 		),
			// 	),
			// 	'default' => 'left',
			// 	'tooltip' => ''
			// ),

			
		

			
			
			
			
			
		))),
		'presets' => array(
			'default' => array(
				'title' => '',
				'image' => '',
				'preset' => array(
					
				),
			)
		),


	);
	tatsu_remap_modules(array('spyro_advance_tabs' , 'tabs'), $controls, 'spyro_advance_tabs');

	//tatsu_register_module( 'spyro_advance_tabs', $controls );
}

add_action('tatsu_register_modules', 'spyro_register_advance_tab');
function spyro_register_advance_tab()
{
	$controls = array(
		'icon' => '',
		'title' => __('Tab', 'spyro-modules'),
		'child_module' => 'spyro_advance_tab',
		'type' => 'sub_module',
		'is_built_in' => false,
		'is_dynamic' => true,
		'hint' => 'title',
		'group_atts' => array(
			array(
				'type'		=> 'tabs',
				'style'		=> 'style1',
				'group'		=> array(
					array(
						'type' => 'tab',
						'title' => __('', 'spyro-modules'),
						'group'	=> array(
							'title',
							'icon_type',
							'svg_icon',
							'icon',
							'icon_image',
							'icon_active_image',
							'icon_image_bg_size',
							'content_title',
							'content',
							'feature_items',
							'feature_icon',
							'image',
							'btn_text',
							'btn_url',
							
						)
					),
					
				),
			)
		),
		'atts' => array(
			array(
				'att_name' => 'title',
				'type' => 'text',
				'label' => __('Title', 'spyro-modules'),
				'default' => 'Deep website ',
				'tooltip' => ''
			),
			array(
				'att_name' => 'icon_type',
				'type' => 'button_group',
				'is_inline' => true,
				'label' => esc_html__('Icon Type', 'spyro-modules'),
				'options' => array(
					'icon' => 'Icon',
					'svg' => 'SVG',
					'image' => 'Image',
				),
				'default' => 'icon',
				'tooltip' => ''
			),
			array(
				'att_name' => 'icon',
				'type' => 'icon_picker',
				'label' => __('Icon', 'spyro-modules'),
				'default' => '',
				'visible' => array('icon_type', '=', 'icon'),
				'tooltip' => ''
			),
			array(
				'att_name' => 'svg_icon',
				'type' => 'svg_icon_picker',
				'label' => esc_html__('Icon', 'spyro-modules'),
				'default' => 'linea:basic_mail',
				'visible' => array('icon_type', '=', 'svg'),
				'tooltip' => ''
			),

			array(
				'att_name' => 'icon_image',
				'type' => 'single_image_picker',
				'label' => esc_html__('Image', 'spyro-modules'),
				'visible' => array('icon_type', '=', 'image'),
				'tooltip' => '',
				'default'	=> 'https://via.placeholder.com/150x150?text=inactive',
				'options' => array(
					'size' => 'thumbnail',
				),
				'css'		=> true,
				'selectors' => array(
					'.spyro-tabs .tatsu-{UUID} .spyro-icon_card-image'	=> array(
						'property'	=> 'background',
						'prepend'	=> 'url(',
						'append'	=> ') center scroll no-repeat',
						'when'	=> array('icon_type', '=', 'image')
					),

				)
				
			),
			array(
				'att_name' => 'icon_active_image',
				'type' => 'single_image_picker',
				'label' => esc_html__('Active Image', 'spyro-modules'),
				'visible' => array('icon_type', '=', 'image'),
				'tooltip' => '',
				'default'	=> 'https://via.placeholder.com/150x150?text=active',
				'options' => array(
					'size' => 'thumbnail',
				),
				'css'		=> true,
				'selectors' => array(
					'.spyro-tabs .tatsu-{UUID} a.active .spyro-icon_card-image'	=> array(
						'property'	=> 'background',
						'prepend'	=> 'url(',
						'append'	=> ') center scroll no-repeat',
						'when'	=> array('icon_type', '=', 'image')
					),

				)
				
			),
			array(
				'att_name' => 'icon_image_bg_size',
				'type' => 'select',
				'label' => esc_html__('Background Size', 'spyro-modules'),
				'visible' => array(
					'condition' => array(
						array('icon_type', '=', 'image'),
						array('image', '!=', ''),
					),
					'relation'	=> 'and',
				),
				'options' => array(
					'cover' => 'Cover',
					'contain' => 'Contain',
					'initial' => 'Initial',
				),
				'default' => 'cover',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.spyro-tabs .tatsu-{UUID} .spyro-icon_card-image,.spyro-tabs .tatsu-{UUID} a.active .spyro-icon_card-image' => array(
						'property' => 'background-size',
						'when' => array(
							array('icon_type', '=', 'image'),
							
						),
						'relation' => 'and',
					),
				)
			),
			array(
				'att_name' => 'content_title',
				'type' => 'text',
				'label' => __('Content Title', 'spyro-modules'),
				'default' => '',
				'tooltip' => ''
			),
			array(
				'att_name' => 'content',
				'type' => 'tinymce',
				'label' => __('Content', 'spyro-modules'),
				'default' => '',
				'tooltip' => ''
			),
			array(
				'att_name' => 'image',
				'type' => 'single_image_picker',
				'label' => __('Image', 'spyro-modules'),
				'tooltip' => '',
				'default' => TATSU_PLUGIN_URL . '/img/image-placeholder.jpg'
			),

			array(
				'att_name' => 'feature_items',
				'type' => 'text_area',
				'label' => __('Lists', 'spyro-modules'),
				'default' => "What'special about your theme?\nHow much do you charge ?\nCan I get a free consultation ?",
				
				'options' => array(
					'placeholder' => "What'special about your theme?\nHow much do you charge ?\nCan I get a free consultation ?",
				),
				'tooltip' => 'Seprate your feature list by press Enter after every feature end.',
				
			),
			array(
				'att_name' => 'feature_icon',
				'type' => 'icon_picker',
				'label' => __('List Icon', 'spyro-modules'),
				'default' => '',
				'tooltip' => ''
			),

			array(
				'att_name' => 'btn_text',
				'type' => 'text',
				'label' => __('Button Text', 'spyro-modules'),
				'default' => 'Make an appointment',
				'tooltip' => ''
			),
			array(
				'att_name' => 'btn_url',
				'type' => 'text',
				'is_inline' => false,
				'options' => array(
					'placeholder' => 'https://example.com',
				),
				'label' => __('Link URL', 'spyro-modules'),
				'default' => 'https://example.com',
				
			),
			
		),
		'presets' => array(
			'default' => array(
				'title' => '',
				'image' => '',
				'content_title' => '',
				'feature_icon' => '',
				'preset' => array(
					'content_title' => 'Hair Loss Treatment',
					'title' => 'Receding Hairline',
					'icon' => 'tatsu-icon-thumbs-up',
					'feature_icon' => 'tatsu-icon-check-circle',
					'content' => 'Spyro WordPress theme is insanely flexible and amazingly easy to use. This alone would be enough for a 5 star rating. On top of a great tool is even better customer support.'
				),
			)
		),
	);
	tatsu_remap_modules(array('spyro_advance_tab', 'tab'), $controls, 'spyro_advance_tab');
}



?>