<?php
/**************************************
			TABS
**************************************/
if (!function_exists('spyro_accordion')) {
	function spyro_accordion( $atts, $content, $tag ) {
        $atts = shortcode_atts( array (
            'active_title_color'=>'',
            'title_color'=>'',
            'active_content_color'=>'',
            'active_background_color'=>'',
            'active_border_color'=>'',
            'content_title_typography'=>'',
            'content_title_typography'=>'',
            'title_font'=>'',
            'content_font'=>'',
            'title_typography'=>'',
            'active_box_shadow'=>'',
        	'key' => be_uniqid_base36(true),
        ),$atts, $tag );
        
        extract( $atts );
       
		$GLOBALS['tabs_cnt'] = 0;
		$tabs_cnt=0;
        $GLOBALS['tabs'] = array();
		$rand = rand();
        $content=do_shortcode( $content );
        $custom_style_tag = be_generate_css_from_atts( $atts, 'spyro_accordion', $key );
		$custom_class_name = 'tatsu-'.$atts['key'];
		$data_animations = be_get_animation_data_atts( $atts );

		$css_id = be_get_id_from_atts( $atts );
		$visibility_classes = be_get_visibility_classes_from_atts( $atts ); 
		
		$animate = ( isset( $animate ) && 1 == $animate  && 'none' != $animation_type ) ? ' tatsu-animate ' : '';
		
		ob_start();

		remove_filter('the_content', 'wpautop');
		remove_filter('the_content', 'wptexturize');
		
		// if(empty($title_font))
		// {
		// 	$title_font = 'default';
		// }
		// if(empty($content_font))
		// {
		// 	$content_font = 'default';
		// }
		?>

                                
		<div class="spyro-accordion <?php echo $tab_class .' '.$custom_class_name; ?>">
			<?php 
			if( is_array( $GLOBALS['tabs'] ) ) {
			
			foreach( $GLOBALS['tabs'] as $key => $tab ) {
				$toggle_cnt++;
				if($key == 0)
				{
					$active = 'active';
					$open = 'slide-open';
				}
				else
				{
					$active = '';	
					$open = '';
				}
			?>
           <div class="accordion-content-wrap <?php echo $active; ?>">
                    <div class="accordion-head <?php echo $open; ?>">
                        <h3 class="accordion-title <?php echo $title_font; ?>"><?php echo esc_html($toggle_cnt.'.'.' '.$tab['title']); ?></h3>
                    </div>
                    <div class="accordion-body">

                        <div class="accordion-description <?php echo $content_font; ?>"><?php echo  $tab['content']; ?></div>
                    </div>
            </div>  
        <?php } } ?>

         </div> 

         <?php echo $custom_style_tag; ?>
       
		<?php
		return ob_get_clean();
		
	}

	//add_shortcode( 'tabs', 'spyro_accordion' );

}

if (!function_exists('spyro_toggle')) {
	function spyro_toggle( $atts, $content ){
		$atts = shortcode_atts( array(
			'title' => '',
			'key' => be_uniqid_base36(true),
		),$atts );
		
		$custom_style_tag = be_generate_css_from_atts( $atts, 'spyro_toggle', $atts['key'] );
		$custom_class_name = 'tatsu-'.$atts['key'];

		extract( $atts );

		$title = tatsu_parse_custom_fields( $title );
		$content= do_shortcode($content);
		$x = $GLOBALS['tabs_cnt'];
		$GLOBALS['tabs'][$x] = array( 'title' => sprintf( $title, $GLOBALS['tabs_cnt'] ), 'content' =>  $content, 'class_name' => $custom_class_name, 'custom_style_tag' => $custom_style_tag );
		$GLOBALS['tabs_cnt']++;
	}
}

add_action('tatsu_register_modules', 'spyro_register_accordion');
function spyro_register_accordion()
{
	$controls = array(
		'icon' => TATSU_PLUGIN_URL . '/builder/svg/modules.svg#tabs',
		'title' => __('Spyro Accordion', 'spyro-modules'),
		'is_js_dependant' => true,
		'child_module' => 'spyro_toggle',
		'type' => 'multi',
		'initial_children' => 3,
		'is_built_in' => false,
		'category' => 'tab',
        'group_atts' => array(
			array(
				'type'		=> 'tabs',
				'style'		=> 'style1',
				'group'		=> array(
					
					array(
						'type' => 'tab',
						'title' => __('Style', 'spyro-modules'),
						'group'	=> array(
							
							array(
								'type' => 'accordion',
								'active' => array(0),
								'group' => array(
									
									array(
										'type' => 'panel',
										'title' => __('Colors And Box Shadow', 'spyro-modules'),
										'group' => array(
											'title_color',
											'active_title_color',
											'active_content_color',
											'active_border_color',
											'active_background_color',
											'active_box_shadow',
											
											
											
										)
									),

									array(
										'type' => 'panel',
										'title' => __('Typography', 'spyro-modules'),
										'group' => array(
											
											array(
												'type'  	=> 'tabs',
												'style'		=> 'style1',
												'group'		=> array(
													array(
														'type'		=> 'tab',
														'title'		=> __('Type Hub', 'spyro-modules'),
														'group'		=> array(
															'title_font',
															'content_font',
															
														),
													),
													array(
														'type'		=> 'tab',
														'title'		=> __('Custom', 'spyro-modules'),
														'group'		=> array(
															'title_typography',
															'content_title_typography',
															
															
														),
													),
												),
											),
										
											
										)
									),
									
								),
							),
						)
					),
					
					array(
						'type' => 'tab',
						'title' => __('Advanced', 'spyro-modules'),
						'group'	=> array(
							
						)
					)
				)
			)
		),
		'atts' => array_values(array_filter(array(

			array(
				'att_name' => 'title_color',
				'type' => 'color',
				'label' => __('Normal Title Color', 'spyro-modules'),
				'default' => '#343638',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-accordion .accordion-content-wrap .accordion-head .accordion-title' => array(
						'property' => 'color',
					),
				),
			),

		

			array(
				'att_name' => 'active_title_color',
				'type' => 'color',
				'label' => __('Active Title Color', 'spyro-modules'),
				'default' => '#2293D7',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-accordion .accordion-content-wrap.active .accordion-head .accordion-title' => array(
						'property' => 'color',
					),
				),
			),

			array(
				'att_name' => 'active_content_color',
				'type' => 'color',
				'label' => __('Active Content Color', 'spyro-modules'),
				'default' => '#77797D',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-accordion .accordion-content-wrap .accordion-body .accordion-description' => array(
						'property' => 'color',
					),
				),
			),

			array(
				'att_name' => 'active_border_color',
				'type' => 'color',
				'label' => __('Active Border Color', 'spyro-modules'),
				'default' => '#2293D7',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-accordion .accordion-content-wrap.active::before' => array(
						'property' => 'background',
					),
				),
			),

			array(
				'att_name' => 'active_background_color',
				'type' => 'color',
				'label' => __('Active Background Color', 'spyro-modules'),
				'default' => '#fff',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-accordion .accordion-content-wrap.active' => array(
						'property' => 'background',
					),
				),
			),
			function_exists('spyro_get_exposed_selectors') ? array(
				'att_name'	=> 'title_font',
				'type'		=> 'select',
				'label'		=> esc_html__('Title Font', 'spyro-modules'),
				'options'	=> spyro_get_exposed_selectors(),
				'default'	=> 'default',
				'tooltip'	=> ''
			) : false,

			array(
				'att_name' => 'title_typography',
				'type' => 'typography',
				'label' => __( 'TItle Font', 'spyro-modules' ),
				'responsive' => true,
				'default' => '',
				'tooltip' => '',
				'css' => true,
				'is_inline' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-accordion .accordion-content-wrap .accordion-head .accordion-title' => array(
						'property' => 'typography',
					)
				),
			),

			array(
				'att_name' => 'content_title_typography',
				'type' => 'typography',
				'label' => __( 'Content Font', 'spyro-modules' ),
				'responsive' => true,
				'default' => '',
				'tooltip' => '',
				'css' => true,
				'is_inline' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-accordion .accordion-content-wrap .accordion-body .accordion-description' => array(
						'property' => 'typography',
					)
				),
			),
				function_exists('spyro_get_exposed_selectors') ? array(
				'att_name'	=> 'content_font',
				'type'		=> 'select',
				'label'		=> esc_html__('Content Font', 'spyro-modules'),
				'options'	=> spyro_get_exposed_selectors(),
				'default'	=> 'default',
				'tooltip'	=> ''
			) : false,

			array(
				'att_name' => 'active_box_shadow',
				'type' => 'input_box_shadow',
				'label' => __('Active Box Shadow', 'spyro-modules'),
				'default' => '0px 30px 60px 0px rgba(0,0,0,0.05)',
				'tooltip' => '',
				'css' => true,
				'selectors' => array(
					'.tatsu-{UUID}.spyro-accordion .accordion-content-wrap.active' => array(
						'property' => 'box-shadow',
						'when' => array('active_box_shadow', '!=', '0px 0px 0px 0px rgba(0,0,0,0)'),
					),
				),
			),

		
			
		))),
		'presets' => array(
			'default' => array(
				'title' => '',
				'image' => '',
				'preset' => array(

				),
			)
		),


	);
	tatsu_remap_modules(array('spyro_accordion' , 'tabs'), $controls, 'spyro_accordion');

	//tatsu_register_module( 'spyro_accordion', $controls );
}

add_action('tatsu_register_modules', 'spyro_register_toggle');
function spyro_register_toggle()
{
	$controls = array(
		'icon' => '',
		'title' => __('Toggle', 'spyro-modules'),
		'child_module' => '',
		'type' => 'sub_module',
		'is_built_in' => false,
		'is_dynamic' => true,
		'hint' => 'title',
		'group_atts' => array(
			array(
				'type'		=> 'tabs',
				'style'		=> 'style1',
				'group'		=> array(
					array(
						'type' => 'tab',
						'title' => __('', 'spyro-modules'),
						'group'	=> array(
							'title',
							'content',
						)
					),
					
				),
			)
		),
		'atts' => array(
			array(
				'att_name' => 'title',
				'type' => 'text',
				'label' => __('Title', 'spyro-modules'),
				'default' => 'Deep website ',
				'is_inline' => false,
				'tooltip' => ''
			),
			
			
			array(
				'att_name' => 'content',
				'type' => 'tinymce',
				'label' => __('Content', 'spyro-modules'),
				'default' => '',
				'tooltip' => ''
			),
			
			
		),
		'presets' => array(
			'default' => array(
				'title' => '',
				
				'preset' => array(
					
					'title' => 'Deep Website Audit Solution',
					'content' => 'Get started swiftly & easily by importing a demo of your choice in a single click. Over 30 high quality professionally designed pre-built website concepts to choose from.'
				),
			)
		),
	);
	tatsu_remap_modules(array('spyro_toggle', 'tab'), $controls, 'spyro_toggle');
}

?>