<?php 
if(!class_exists('Spyro_Mailchimp'))
{
	class Spyro_Mailchimp
	{
		private $api_key;
    	private $api_endpoint = 'https://<dc>.api.mailchimp.com/3.0/';
    	private $verify_ssl   = false;

    	public function __construct($api_key) {
    		$this->api_key = $api_key;
        	list(, $datacentre) = explode('-', $this->api_key);
        	$this->api_endpoint = str_replace('<dc>', $datacentre, $this->api_endpoint);

        	
    	}

    	public function call($method, $args=array(), $request_type = 'POST' , $timeout = 10) 
    	{
	        return $this->makeRequest($method, $args, $request_type, $timeout);
	    }

	    private function makeRequest($method, $args, $request_type, $timeout)
	    {
	    	$url = $this->api_endpoint . $method;
	    	// $url = 'https://' . substr($api_key,strpos($api_key,'-')+1) . '.api.mailchimp.com/3.0/lists/';
	    	if( $request_type == 'GET' )
	    	{
        		$url .= '?' . http_build_query($args);
	    	}
    		$ch = curl_init();
		    $headers = array(
		        'Content-Type: application/json',
		        'Authorization: Basic '.base64_encode( 'user:'. $this->api_key )
		    );
		    curl_setopt($ch, CURLOPT_URL, $url );
      		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
      		//curl_setopt($ch, CURLOPT_USERAGENT, 'PHP-MCAPI/2.0');
      		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // do not echo the result, write it into variable
	      	curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $request_type); // according to MailChimp API: POST/GET/PATCH/PUT/DELETE
	      	curl_setopt($ch, CURLOPT_TIMEOUT, $timeout);
	      	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // certificate verification for TLS/SSL connection
	      	if( $request_type != 'GET' ) {
	        curl_setopt($ch, CURLOPT_POST, true);
	        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($args) ); // send data in json
	   		}
    		$result =  curl_exec($ch);

    		return $result;
	    }
	}
}

  