<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       http://brandspyros.com
 * @since      1.0.0
 *
 * @package    Spyro_Modules
 * @subpackage Spyro_Modules/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Spyro_Modules
 * @subpackage Spyro_Modules/admin
 * @author     Brand Exponents <help@brandspyros.com>
 */
class Spyro_Modules_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

	//	wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/spyro-modules-admin.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

	//wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/spyro-modules-admin.js', array( 'jquery' ), $this->version, false );

	}

	public function enqueue_module_components() {

		$suffix = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';   
		wp_register_script( 'spyro_module_components', SPYRO_MODULES_PLUGIN_URL.'/admin/js/spyro-bundle'.$suffix.'.js', array( 'jquery', 'tatsu' ), $this->version, true );
		wp_enqueue_script( 'spyro_module_components' );

	}

}
